/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff.integrity;

import com.oracle.cie.gdr.carbdiff.CarbDiff;
import com.oracle.cie.gdr.carbdiff.CarbDiffException;
import com.oracle.cie.gdr.carbdiff.FileMapFilterer;
import com.oracle.cie.gdr.carbdiff.integrity.BuildIntegrityHandler;
import com.oracle.cie.gdr.dao.bic.BuildIntegrity;
import com.oracle.cie.gdr.dao.cpd.Component;
import java.io.File;
import java.util.logging.Logger;

public class BuildIntegrityDiff
extends CarbDiff {
    private static final Logger _logger = Logger.getLogger(BuildIntegrityDiff.class.getName());
    private BuildIntegrityHandler _diffHandler;
    private FileMapFilterer _fileMapFilterer;
    private BuildIntegrity _buildIntegrity;

    public boolean diff(Component baseComponent, Component modifiedComponent, File deltaCarbDestination) throws CarbDiffException {
        try {
            _logger.entering(CarbDiff.class.getName(), "diff", new Object[]{baseComponent, modifiedComponent, deltaCarbDestination});
            this._diffHandler = new BuildIntegrityHandler(deltaCarbDestination, baseComponent, modifiedComponent);
            this._diffHandler.setBuildIntegrity(this._buildIntegrity);
            if (this._fileMapFilterer != null) {
                this._diffHandler.setFileMapFilterer(this._fileMapFilterer);
            }
            if (this._diffHandler.diff(baseComponent, modifiedComponent)) {
                _logger.exiting(CarbDiff.class.getName(), "diff");
                return true;
            }
        }
        catch (Exception exception) {
            throw new CarbDiffException("Failed to diff base component " + baseComponent + " and modified component " + modifiedComponent, exception);
        }
        _logger.exiting(CarbDiff.class.getName(), "diff");
        return false;
    }

    public BuildIntegrity getBuildIntegrity() {
        return this._diffHandler.getBuildIntegrity();
    }

    public void setBuildIntegrity(BuildIntegrity buildIntegrity) {
        this._buildIntegrity = buildIntegrity;
    }
}

