/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff;

import com.oracle.cie.common.util.DiffReport;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.carbdiff.CarbDiffException;
import com.oracle.cie.gdr.carbdiff.CarbDiffHandler;
import com.oracle.cie.gdr.carbdiff.CarbDiffUtils;
import com.oracle.cie.gdr.carbdiff.DefaultContentFilterer;
import com.oracle.cie.gdr.carbdiff.FileMapFilterer;
import com.oracle.cie.gdr.carbdiff.ReplacementResolver;
import com.oracle.cie.gdr.carbdiff.Strategy;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.pad.TextFileDiffFilter;
import com.oracle.cie.gdr.packaging.PackagerComponentTarget;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class DefaultCarbDiffHandler
implements CarbDiffHandler {
    private Logger _log = Logger.getLogger(DefaultCarbDiffHandler.class.getName());
    protected File _deltaCarbDestination;
    protected Strategy _strategy;
    protected String _platform;
    protected boolean _excludeGeneric;
    protected FileMapFilterer _fileMapFilterer;
    protected TextFileDiffFilter _textFileDiffFilter;
    protected DefaultContentFilterer _textFileDiffFilterer;
    protected List<FileMap> _deltaFileMaps = new ArrayList<FileMap>();
    protected Map<String, File> _releaseDataFiles;
    protected Map<String, File> _patchedDataFiles;
    protected DiffReport _report;
    protected boolean _includeParentClass;
    private List<FileTarget> _fileTargetsToDelete;

    public DefaultCarbDiffHandler(Strategy strategy, File deltaCarbDestination, String platform, boolean excludeGeneric, Map<String, File> releaseDataFiles, Map<String, File> patchedDataFiles) {
        this._strategy = strategy;
        this._deltaCarbDestination = deltaCarbDestination;
        this._platform = platform;
        this._excludeGeneric = excludeGeneric;
        this._releaseDataFiles = releaseDataFiles;
        this._patchedDataFiles = patchedDataFiles;
    }

    @Override
    public boolean diff(File baseCarb, File carb) throws CarbDiffException {
        try {
            return this.diff(CarbDiffUtils.getComponentFromCarb(baseCarb), CarbDiffUtils.getComponentFromCarb(carb));
        }
        catch (Exception e) {
            throw new CarbDiffException("Failed to perform carb diff of " + baseCarb + " vs. " + carb, e);
        }
    }

    private List<FileMap> getFilteredFileMaps(Component component, File dist) throws CarbDiffException, IOException {
        List<FileMap> filteredFileMaps = this._fileMapFilterer.apply(component, component.getFileMaps(), dist);
        if (component.getFileMaps().size() != filteredFileMaps.size()) {
            this._log.info("There are empty file maps after applying filtering rules, examining file-maps in corresponding order.");
            ArrayList<FileMap> filtered = new ArrayList<FileMap>();
            for (FileMap fileMapTemp : component.getFileMaps()) {
                FileMap singleFiltered = this._fileMapFilterer.filterSingleFileMap(component, fileMapTemp);
                if (singleFiltered == null) {
                    singleFiltered = new FileMap();
                    singleFiltered.setSource(fileMapTemp.getSource());
                    singleFiltered.setExpanded(true);
                }
                filtered.add(singleFiltered);
            }
            filteredFileMaps = filtered;
        }
        return filteredFileMaps;
    }

    @Override
    public boolean diff(Component releaseComponent, Component patchComponent) throws CarbDiffException {
        if (releaseComponent == null) {
            throw new CarbDiffException("The release component specified was null.");
        }
        if (patchComponent == null) {
            throw new CarbDiffException("The patch component specified was null.");
        }
        File releaseCarb = releaseComponent.getArchiveLocation();
        File patchCarb = patchComponent.getArchiveLocation();
        ReplacementResolver fileDiffResolver = new ReplacementResolver(releaseCarb, patchCarb, this._deltaCarbDestination, this._strategy.isUpgrade() ? Strategy.Replacement : this._strategy);
        fileDiffResolver.setTextFileDiffFilter(this._textFileDiffFilter);
        fileDiffResolver.setDiffReport(this._report);
        fileDiffResolver.setIncludeParentClass(this._includeParentClass);
        try {
            this._log.info("Starting diff on base carb " + releaseCarb.getCanonicalPath() + " and patched carb " + patchCarb.getCanonicalPath());
            releaseComponent.setFileMaps(CarbDiffUtils.filterFileMaps(releaseComponent.getFileMaps(), this._platform, this._excludeGeneric));
            patchComponent.setFileMaps(CarbDiffUtils.filterFileMaps(patchComponent.getFileMaps(), this._platform, this._excludeGeneric));
            if (this._fileMapFilterer != null) {
                File distBase = new File(this.getDestination(), "distBase" + File.separator + releaseComponent.getName() + File.separator + releaseComponent.getVersion());
                File distPatched = new File(this.getDestination(), "distPatched" + File.separator + patchComponent.getName() + File.separator + patchComponent.getVersion());
                this._fileMapFilterer.setDataFilesMap(this._releaseDataFiles);
                releaseComponent.setFileMaps(this.getFilteredFileMaps(releaseComponent, distBase));
                fileDiffResolver.setBaseFilteredArchives(this._fileMapFilterer.getFilteredArchives());
                if (this._fileMapFilterer.getIncludedManifest() != null && !this._fileMapFilterer.getIncludedManifest().isEmpty()) {
                    fileDiffResolver.setIncludedManifest(this._fileMapFilterer.getIncludedManifest());
                }
                this._fileMapFilterer.setDataFilesMap(this._patchedDataFiles);
                patchComponent.setFileMaps(this.getFilteredFileMaps(patchComponent, distPatched));
                fileDiffResolver.setPatchedFilteredArchives(this._fileMapFilterer.getFilteredArchives());
            }
            if (releaseComponent.getFileMaps().size() < patchComponent.getFileMaps().size()) {
                int newFileMaps = patchComponent.getFileMaps().size() - releaseComponent.getFileMaps().size();
                ArrayList<FileMap> releaseComponentFileMaps = new ArrayList<FileMap>();
                releaseComponentFileMaps.addAll(releaseComponent.getFileMaps());
                for (int i = 0; i < newFileMaps; ++i) {
                    FileMap singleFileMap = new FileMap();
                    singleFileMap.setExpanded(true);
                    releaseComponentFileMaps.add(singleFileMap);
                }
                releaseComponent.setFileMaps(releaseComponentFileMaps);
            }
            Iterator<FileMap> i = patchComponent.getFileMaps().iterator();
            Iterator<FileMap> j = releaseComponent.getFileMaps().iterator();
            while (i.hasNext() && j.hasNext()) {
                FileMap patchFileMap = i.next();
                FileMap releaseFileMap = j.next();
                File patchCarbDataFile = this._patchedDataFiles.get(patchFileMap.getSource());
                File releaseCarbDataFile = this._releaseDataFiles.get(releaseFileMap.getSource());
                fileDiffResolver.setPatchDataFile(patchCarbDataFile);
                fileDiffResolver.setReleaseDataFile(releaseCarbDataFile);
                Map<String, FileTarget> patchFileTargets = this.getFileTargets(patchComponent, patchFileMap, this._fileMapFilterer != null ? this._fileMapFilterer.getForcedFiles() : new ArrayList());
                Map<String, FileTarget> releaseFileTargets = this.getFileTargets(releaseComponent, releaseFileMap, this._fileMapFilterer != null ? this._fileMapFilterer.getForcedFiles() : new ArrayList());
                Collection<FileTarget> deltaFileTargets = fileDiffResolver.diffFiles(releaseFileTargets, patchFileTargets);
                if (deltaFileTargets == null || deltaFileTargets.isEmpty()) continue;
                FileMap deltaFileMap = new FileMap(patchFileMap.getDataHandler().copy());
                deltaFileMap.clear();
                deltaFileMap.setExpanded(false);
                deltaFileMap.setFileTargets(deltaFileTargets);
                this._deltaFileMaps.add(deltaFileMap);
                if (!fileDiffResolver.hasFilesToDelete()) continue;
                this._fileTargetsToDelete = fileDiffResolver.getFileTargetsToDelete();
            }
            if (this._deltaFileMaps == null || this._deltaFileMaps.isEmpty()) {
                return false;
            }
        }
        catch (Exception exception) {
            this._log.severe("Failed to diff on base carb " + releaseCarb + " and patched carb " + patchCarb);
            throw new CarbDiffException(exception);
        }
        return true;
    }

    private Map<String, FileTarget> getFileTargets(Component component, FileMap fileMap, List<String> forcedFiles) throws GdrException {
        HashMap<String, FileTarget> fileTargetMap = new HashMap<String, FileTarget>();
        List<FileTarget> fileTargets = new PackagerComponentTarget(component, fileMap, new ServiceHolder(), Mode.PACKAGE_SHIPHOME).getFileTargets();
        if (fileTargets != null && !fileTargets.isEmpty()) {
            for (FileTarget ft : fileTargets) {
                if (!forcedFiles.isEmpty() && forcedFiles.contains(ft.getDest())) {
                    ft.setForced(true);
                }
                fileTargetMap.put(ft.getDest(), ft);
            }
        }
        return fileTargetMap;
    }

    @Override
    public List<FileMap> getDeltaFileMaps() {
        return this._deltaFileMaps;
    }

    protected File getDestination() {
        return this._deltaCarbDestination;
    }

    protected String getPlatform() {
        return this._platform;
    }

    protected Strategy getStrategy() {
        return this._strategy;
    }

    protected boolean excludeGeneric() {
        return this._excludeGeneric;
    }

    public FileMapFilterer getFileMapFilterer() {
        return this._fileMapFilterer;
    }

    @Override
    public void setFileMapFilterer(FileMapFilterer fileMapFilterer) {
        this._fileMapFilterer = fileMapFilterer;
    }

    @Override
    public void setTextFileDiffFilter(TextFileDiffFilter textFileDiffFilter) {
        this._textFileDiffFilter = textFileDiffFilter;
    }

    @Override
    public void setDiffReport(DiffReport report) {
        this._report = report;
    }

    @Override
    public void setIncludeParentClass(boolean includeParentClass) {
        this._includeParentClass = includeParentClass;
    }

    @Override
    public List<FileTarget> getFileTargetsToDelete() {
        return this._fileTargetsToDelete;
    }

    @Override
    public boolean hasFilesToDelete() {
        return null != this._fileTargetsToDelete && !this._fileTargetsToDelete.isEmpty();
    }
}

