/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr.carbdiff;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.ArchiveIncludeExclude;
import com.oracle.cie.common.util.JarHelper;
import com.oracle.cie.common.util.JarUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.Wildcard;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.Directory;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.cpd.Mapping;
import com.oracle.cie.gdr.dao.pad.ArchiveFilter;
import com.oracle.cie.gdr.dao.pad.PatchArtifactDefinition;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.PatchArtifactDefinitionHelper;
import com.oracle.cie.gdr.helpers.PlatformInfoHelper;
import com.oracle.cie.gdr.platform.PlatformInfoHolder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CarbDiffUtils {
    private static Logger _logger = Logger.getLogger(CarbDiffUtils.class.getName());
    private static final String FS = "/";

    public static PatchArtifactDefinition getPatchArtifactDefinition(File carb) throws IOException, DataHandlerException {
        JarHelper carbHelper = new JarHelper(carb);
        String padEntry = null;
        for (String entry : carbHelper.getEntries()) {
            if (!entry.contains("patch-artifact-def")) continue;
            padEntry = entry;
            break;
        }
        InputStream is = carbHelper.getInputStream(padEntry);
        PatchArtifactDefinition pad = (PatchArtifactDefinition)PatchArtifactDefinitionHelper.getInstance().getRootWrapper(is);
        carbHelper.close();
        return pad;
    }

    public static Component getComponentFromCarb(File carb) throws IllegalArgumentException, IOException, DataHandlerException {
        JarHelper carbHelper = new JarHelper(carb);
        String compDefEntry = null;
        for (String entry : carbHelper.getEntries()) {
            if (!entry.contains("compDef.xml")) continue;
            compDefEntry = entry;
            break;
        }
        InputStream is = carbHelper.getInputStream(compDefEntry);
        Component component = (Component)ComponentHelper.getInstance().getRootWrapper(is);
        carbHelper.close();
        component.setArchiveLocation(carb);
        return component;
    }

    public static File getPatchDeployFromCarb(File carb) throws IllegalArgumentException, IOException, DataHandlerException {
        JarHelper carbHelper = new JarHelper(carb);
        String patchDeployEntry = null;
        for (String entry : carbHelper.getEntries()) {
            if (!entry.contains("patchDeploy.xml")) continue;
            patchDeployEntry = entry;
            break;
        }
        File patchDeploy = null;
        if (!StringUtil.isNullOrEmpty(patchDeployEntry)) {
            patchDeploy = JarUtils.extractIntoTempFile((JarHelper)carbHelper, patchDeployEntry);
        }
        carbHelper.close();
        return patchDeploy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isArchive(File file) {
        try (JarHelper jarHelper = null;){
            jarHelper = new JarHelper(file);
            Collection entries = jarHelper.getEntries();
            boolean bl = null != entries && !entries.isEmpty();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isArchive(File file, String entryName) throws IOException {
        JarHelper archiveHelper = null;
        ZipEntry jarEntry = null;
        ZipInputStream jarIs = null;
        try {
            archiveHelper = new JarHelper(file);
            for (String entry : archiveHelper.getEntries()) {
                if (!entry.contains(entryName)) continue;
                jarEntry = archiveHelper.getJarEntry(entry);
                break;
            }
            boolean bl = ((JarInputStream)(jarIs = new JarInputStream(new BufferedInputStream(archiveHelper.getInputStream(jarEntry.getName()))))).getNextJarEntry() != null;
            return bl;
        }
        finally {
            if (jarIs != null) {
                jarIs.close();
            }
            if (archiveHelper != null) {
                archiveHelper.close();
            }
        }
    }

    public static List<Mapping> getAllChildMappings(Mapping mapping) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        if (mapping instanceof Directory) {
            Directory directory = (Directory)mapping;
            mappings.addAll(directory.getDirectories());
            mappings.addAll(directory.getFiles());
        }
        return mappings;
    }

    public static boolean hasChanged(JarInputStream releaseIs, JarInputStream patchIs, JarEntry releaseEntry, JarEntry patchEntry) throws IOException {
        if (releaseEntry.getSize() != patchEntry.getSize()) {
            return true;
        }
        return CarbDiffUtils.hasDifferentBytes(CarbDiffUtils.getInnerJarStream(releaseIs, releaseEntry), CarbDiffUtils.getInnerJarStream(patchIs, patchEntry));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasChanged(File releaseCarb, File patchCarb, String entry) throws IOException {
        JarHelper releaseCarbHelper = new JarHelper(releaseCarb);
        JarHelper patchCarbHelper = new JarHelper(patchCarb);
        JarEntry releaseCarbEntry = CarbDiffUtils.getJarEntry(releaseCarbHelper, entry);
        JarEntry patchCarbEntry = CarbDiffUtils.getJarEntry(patchCarbHelper, entry);
        try {
            if (patchCarbEntry == null || releaseCarbEntry == null) {
                boolean bl = false;
                return bl;
            }
            if (releaseCarbEntry.getSize() != patchCarbEntry.getSize()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = CarbDiffUtils.hasDifferentBytes(releaseCarbHelper.getInputStream(releaseCarbEntry.getName()), patchCarbHelper.getInputStream(patchCarbEntry.getName()));
            return bl;
        }
        finally {
            releaseCarbHelper.close();
            patchCarbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarInputStream getInnerJarStream(JarInputStream jaris, JarEntry jarEntry) throws IOException {
        PipedInputStream pipedis = new PipedInputStream();
        PipedOutputStream pipedos = new PipedOutputStream(pipedis);
        JarInputStream innerJarStream = null;
        try {
            CarbDiffUtils.copyStream(jaris, pipedos, jarEntry);
            innerJarStream = new JarInputStream(pipedis);
        }
        finally {
            pipedos.flush();
            pipedos.close();
        }
        return innerJarStream;
    }

    public static void copyStream(InputStream in, OutputStream out, JarEntry entry) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        long size = entry.getSize();
        for (long count = 0L; -1 != (n = in.read(buffer)) && count < size; count += (long)n) {
            out.write(buffer, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasDifferentBytes(InputStream releaseIs, InputStream patchIs) throws IOException {
        BufferedInputStream bisReleaseEntry = null;
        BufferedInputStream bisPatchEntry = null;
        try {
            bisReleaseEntry = new BufferedInputStream(releaseIs);
            bisPatchEntry = new BufferedInputStream(patchIs);
            int baseEntryByte = bisReleaseEntry.read();
            int entryByte = bisPatchEntry.read();
            while (baseEntryByte == entryByte && baseEntryByte != -1 && entryByte != -1) {
                baseEntryByte = bisReleaseEntry.read();
                entryByte = bisPatchEntry.read();
            }
            if (baseEntryByte != entryByte) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (bisReleaseEntry != null) {
                bisReleaseEntry.close();
            }
            if (bisPatchEntry != null) {
                bisPatchEntry.close();
            }
        }
    }

    public static JarEntry getJarEntry(JarHelper carbHelper, String entryName) {
        ArrayList<JarEntry> foundEntries = new ArrayList<JarEntry>();
        for (Object entry : carbHelper.getEntries()) {
            if (!((String)entry).contains(entryName)) continue;
            if (((String)entry).equals(entryName)) {
                return carbHelper.getJarEntry((String)entry);
            }
            foundEntries.add(carbHelper.getJarEntry((String)entry));
        }
        Iterator iterator = foundEntries.iterator();
        if (iterator.hasNext()) {
            Object entry;
            entry = (JarEntry)iterator.next();
            _logger.finest("Entry " + entryName + " did not match any entries at " + carbHelper.getJar().getName() + ", but similar entry was found: " + entry);
            return entry;
        }
        return null;
    }

    public static List<File> getDataFiles(File location) throws IOException {
        File[] dataFiles = location.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return CarbDiffUtils.isArchive(file);
            }
        });
        if (dataFiles != null) {
            return Arrays.asList(dataFiles);
        }
        return new ArrayList<File>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJarEntryFound(File jar, String entry) throws IllegalArgumentException, IOException {
        try (JarHelper jarHelper = null;){
            jarHelper = new JarHelper(jar);
            JarEntry carbEntry = CarbDiffUtils.getJarEntry(jarHelper, entry);
            if (carbEntry == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public static com.oracle.cie.common.util.ArchiveFilter convert(File jar, File destination, ArchiveFilter include, ArchiveFilter exclude) {
        com.oracle.cie.common.util.ArchiveFilter archiveFilter = new com.oracle.cie.common.util.ArchiveFilter(jar, destination, CarbDiffUtils.convert(include), CarbDiffUtils.convert(exclude));
        return archiveFilter;
    }

    private static List<ArchiveIncludeExclude> convert(ArchiveFilter archiveFilter) {
        if (archiveFilter == null) {
            return null;
        }
        ArrayList<ArchiveIncludeExclude> includeExcludes = new ArrayList<ArchiveIncludeExclude>();
        includeExcludes.addAll(CarbDiffUtils.getFiles(archiveFilter.getFiles()));
        includeExcludes.addAll(CarbDiffUtils.getDirectories(archiveFilter.getDirectories()));
        return includeExcludes;
    }

    private static List<ArchiveIncludeExclude> getDirectories(List<com.oracle.cie.gdr.dao.pad.Directory> directories) {
        ArrayList<ArchiveIncludeExclude> includeExcludes = new ArrayList<ArchiveIncludeExclude>();
        if (directories != null) {
            for (com.oracle.cie.gdr.dao.pad.Directory dir : directories) {
                includeExcludes.addAll(CarbDiffUtils.getFiles(dir));
                includeExcludes.addAll(CarbDiffUtils.getDirectories(dir));
            }
        }
        return includeExcludes;
    }

    private static List<ArchiveIncludeExclude> getDirectories(com.oracle.cie.gdr.dao.pad.Directory dir) {
        List<ArchiveIncludeExclude> dirs = null;
        dirs = CarbDiffUtils.getDirectories(dir.getDirectories());
        for (ArchiveIncludeExclude ie : dirs) {
            CarbDiffUtils.mergeRegex(dir, ie);
        }
        return dirs;
    }

    private static List<ArchiveIncludeExclude> getFiles(com.oracle.cie.gdr.dao.pad.Directory dir) {
        List<ArchiveIncludeExclude> files = null;
        files = CarbDiffUtils.getFiles(dir.getFiles());
        for (ArchiveIncludeExclude ie : files) {
            CarbDiffUtils.mergeRegex(dir, ie);
        }
        return files;
    }

    private static void mergeRegex(com.oracle.cie.gdr.dao.pad.Directory dir, ArchiveIncludeExclude ie) {
        if (ie.getDest() != null) {
            if (dir.getDest() != null) {
                ie.setDest(dir.getDest() + FS + ie.getDest());
            } else if (dir.getRegex() != null) {
                ie.setDest(null);
                ie.setRegex(dir.getRegex() + FS + ie.getDest());
            } else if (dir.getWildcard() != null) {
                ie.setDest(null);
                ie.setRegex(new Wildcard(dir.getWildcard()).getWildcardRegex() + FS + ie.getDest());
            }
        }
        if (ie.getRegex() != null) {
            if (dir.getDest() != null) {
                ie.setDest(null);
                ie.setRegex(dir.getDest() + FS + ie.getRegex());
            } else if (dir.getRegex() != null) {
                ie.setRegex(dir.getRegex() + FS + ie.getRegex());
            } else if (dir.getWildcard() != null) {
                ie.setWildcard(null);
                ie.setRegex(new Wildcard(dir.getWildcard()).getWildcardRegex() + FS + ie.getRegex());
            }
        }
        if (ie.getWildcard() != null) {
            if (dir.getDest() != null) {
                ie.setDest(null);
                ie.setRegex(dir.getDest() + FS + new Wildcard(ie.getWildcard()).getWildcardRegex());
            } else if (dir.getRegex() != null) {
                ie.setRegex(dir.getRegex() + FS + new Wildcard(ie.getWildcard()).getWildcardRegex());
            } else if (dir.getWildcard() != null) {
                ie.setWildcard(null);
                ie.setRegex(new Wildcard(dir.getWildcard()).getWildcardRegex() + FS + new Wildcard(ie.getWildcard()).getWildcardRegex());
            }
        }
    }

    private static List<ArchiveIncludeExclude> getFiles(List<com.oracle.cie.gdr.dao.pad.File> files) {
        ArrayList<ArchiveIncludeExclude> includeExcludes = new ArrayList<ArchiveIncludeExclude>();
        ArchiveIncludeExclude includeExclude = null;
        if (files != null) {
            for (com.oracle.cie.gdr.dao.pad.File file : files) {
                includeExclude = new ArchiveIncludeExclude(file.getDest(), file.getRegex(), file.getWildcard());
                if (file.getArchiveFilter() != null) {
                    includeExclude.add(CarbDiffUtils.getFiles(file.getArchiveFilter().getFiles()));
                    includeExclude.add(CarbDiffUtils.getDirectories(file.getArchiveFilter().getDirectories()));
                }
                includeExcludes.add(includeExclude);
            }
        }
        return includeExcludes;
    }

    public static List<FileMap> filterFileMaps(List<FileMap> fileMaps, String platformAruId, boolean excludeGeneric) {
        _logger.info("Filtering file map content based on platform " + platformAruId + (excludeGeneric ? "excluding generic content." : ""));
        ArrayList<FileMap> filtered = new ArrayList<FileMap>();
        PlatformInfoHolder platformInfoHolder = null;
        for (FileMap fileMap : fileMaps) {
            if (Integer.valueOf(platformAruId) == 289) {
                _logger.finest("Including the following file map platform is generic." + (Object)((Object)fileMap));
                filtered.add(fileMap);
                continue;
            }
            if (fileMap.getPlatforms().isEmpty() && !excludeGeneric) {
                _logger.finest("Including the following file map platform is generic." + (Object)((Object)fileMap));
                filtered.add(fileMap);
                continue;
            }
            for (String platformName : fileMap.getPlatforms()) {
                platformInfoHolder = PlatformInfoHelper.getInstance().getPlatformInfoHolder(platformName);
                if (null == platformInfoHolder || !Integer.valueOf(platformAruId).equals(platformInfoHolder.getARUId()) && (platformInfoHolder.getId() != 2000 || excludeGeneric) && (platformInfoHolder.getId() != 289 || excludeGeneric)) continue;
                _logger.finest("Filtering the following file map: " + (Object)((Object)fileMap));
                filtered.add(fileMap);
            }
        }
        return filtered;
    }
}

