/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.gdr.services.RepositoryArtifact;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FileTarget
implements RepositoryArtifact {
    public static String COPY_AS_TEXT_MODIFIER = "text";
    public static String COPY_AS_ZERO_BYTE_MODIFIER = "zeroByte";
    public static String DELAYED_DEINSTALL_MODIFIER = "delayed-deinstall";
    public static String BOOTSTRAP_MODIFIER = "bootstrap";
    public static String STATUS_ADDED = "added";
    public static String STATUS_DELETED = "deleted";
    public static String STATUS_MOVED = "moved";
    public static String STATUS_REDUCED = "reduced";
    private String _dest;
    private String _source;
    private boolean _directory;
    private String _mode;
    private String _id;
    private Set<String> _modifiers;
    private boolean _symlink;
    private Map<String, FileTarget> _duplicateDests = new HashMap<String, FileTarget>();
    private String _artifact;
    private String _group;
    private String _version;
    private boolean _ignoreVersionKeywords;
    private String _baseVersion;
    private String _classifier;
    private String _type;
    private String _action;
    private long _size;
    private boolean _packed;
    private Boolean _patchable;
    private Boolean _forced;
    private String _status;
    private String _checksum;

    public FileTarget(String dest, String source) {
        this(dest, source, false, null, null);
    }

    public FileTarget(String dest, String source, boolean directory) {
        this(dest, source, directory, null, null);
    }

    public FileTarget(String dest, String source, boolean directory, String mode) {
        this(dest, source, directory, mode, null);
    }

    public FileTarget(String dest, String source, boolean directory, Set<String> modifiers) {
        this(dest, source, directory, null, modifiers);
    }

    public FileTarget(String dest, String source, Set<String> modifiers) {
        this(dest, source, false, null, modifiers);
    }

    public FileTarget(String dest, String source, String mode, Set<String> modifiers) {
        this(dest, source, mode, null, modifiers);
    }

    public FileTarget(String dest, String source, String mode, String id, Set<String> modifiers) {
        this(dest, source, false, mode, id, modifiers);
    }

    public FileTarget(String dest, String source, String mode, Set<String> modifiers, boolean symlink) {
        this(dest, source, false, mode, modifiers, symlink);
    }

    public FileTarget(String dest, String source, String mode, String id, Set<String> modifiers, boolean symlink) {
        this(dest, source, false, mode, id, modifiers, symlink);
    }

    public FileTarget(String dest, String source, boolean directory, String mode, Set<String> modifiers) {
        this(dest, source, directory, mode, null, modifiers);
    }

    public FileTarget(String dest, String source, boolean directory, String mode, String id, Set<String> modifiers) {
        this(dest, source, directory, mode, id, modifiers, false);
    }

    public FileTarget(String dest, String source, boolean directory, String mode, Set<String> modifiers, boolean symlink) {
        this(dest, source, directory, mode, null, modifiers, symlink);
    }

    public FileTarget(String dest, String source, boolean directory, String mode, String id, Set<String> modifiers, boolean symlink) {
        this(dest, source, directory, mode, id, modifiers, symlink, null, null, null, false, null, null, null);
    }

    public FileTarget(String dest, String source, boolean directory, String mode, String id, Set<String> modifiers, String group, String artifact, String version, boolean ignoreVersionKeywords, String baseVersion, String classifier, String type) {
        this(dest, source, directory, mode, id, modifiers, false, group, artifact, version, ignoreVersionKeywords, baseVersion, classifier, type);
    }

    public FileTarget(String dest, String source, String mode, String id, Set<String> modifiers, String group, String artifact, String version, boolean ignoreVersionKeywords, String baseVersion, String classifier, String type) {
        this(dest, source, false, mode, id, modifiers, group, artifact, version, ignoreVersionKeywords, baseVersion, classifier, type);
    }

    public FileTarget(String dest, String source, boolean directory, String mode, String id, Set<String> modifiers, boolean symlink, String group, String artifact, String version, boolean ignoreVersionKeywords, String baseVersion, String classifier, String type) {
        this(dest, source, directory, mode, id, modifiers, symlink, group, artifact, version, ignoreVersionKeywords, baseVersion, classifier, type, false);
    }

    public FileTarget(String dest, String source, boolean directory, String mode, String id, Set<String> modifiers, boolean symlink, String group, String artifact, String version, boolean ignoreVersionKeywords, String baseVersion, String classifier, String type, boolean packed) {
        this._dest = dest;
        this._source = source;
        this._directory = directory;
        this._symlink = symlink;
        this._mode = mode;
        this._id = id;
        this._modifiers = modifiers;
        this._group = group;
        this._artifact = artifact;
        this._version = version;
        this._ignoreVersionKeywords = ignoreVersionKeywords;
        this._baseVersion = baseVersion;
        this._classifier = classifier;
        this._type = type;
        this._packed = packed;
    }

    public String getDest() {
        return this._dest;
    }

    public void setDest(String dest) {
        this._dest = dest;
    }

    public String getSource() {
        return this._source;
    }

    public void setSource(String source) {
        this._source = source;
    }

    public boolean isDirectory() {
        return this._directory;
    }

    public boolean isFile() {
        return !this._directory;
    }

    public void setDirectory(boolean directory) {
        this._directory = directory;
    }

    public boolean isSymlink() {
        return this._symlink;
    }

    public void setSymlink(boolean symlink) {
        this._symlink = symlink;
    }

    public String getMode() {
        return this._mode;
    }

    public void setMode(String mode) {
        this._mode = mode;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public Set<String> getModifiers() {
        return this._modifiers;
    }

    public void setModifiers(Set<String> modifiers) {
        this._modifiers = modifiers;
    }

    public boolean containsModifier(String modifier) {
        Set<String> modifiers = this.getModifiers();
        if (modifiers != null && !modifiers.isEmpty()) {
            for (String mod : modifiers) {
                if (mod == null || !mod.equalsIgnoreCase(modifier)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCopyAsText() {
        return this.containsModifier(COPY_AS_TEXT_MODIFIER);
    }

    public boolean isCopyAsZeroByte() {
        return this.containsModifier(COPY_AS_ZERO_BYTE_MODIFIER);
    }

    public boolean isBootstrap() {
        return this.containsModifier(BOOTSTRAP_MODIFIER);
    }

    public Collection<String> getDuplicateDests() {
        return new HashSet<String>(this._duplicateDests.keySet());
    }

    public Map<String, FileTarget> getDuplicateDestsMap() {
        return this._duplicateDests;
    }

    public void addDuplicateDest(String dest, FileTarget fileTarget) {
        this._duplicateDests.put(dest, fileTarget);
    }

    public void setForced(Boolean forced) {
        this._forced = forced;
    }

    public Boolean isForced() {
        if (this._forced == null) {
            return false;
        }
        return this._forced;
    }

    public boolean hasDuplicateDests() {
        return this._duplicateDests != null && !this._duplicateDests.isEmpty();
    }

    public boolean isPacked() {
        return this._packed;
    }

    public void setPacked(boolean packed) {
        this._packed = packed;
    }

    public Boolean isPatchable() {
        if (this._patchable == null) {
            return true;
        }
        return this._patchable;
    }

    public void setPatchable(Boolean patchable) {
        this._patchable = patchable;
    }

    public String toString() {
        return this.getDest() + "<-" + this.getSource();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileTarget that = (FileTarget)o;
        if (this._directory != that._directory) {
            return false;
        }
        if (this._symlink != that._symlink) {
            return false;
        }
        if (this._dest != null ? !this._dest.equals(that._dest) : that._dest != null) {
            return false;
        }
        return !(this._source != null ? !this._source.equals(that._source) : that._source != null);
    }

    public int hashCode() {
        int result = this._dest != null ? this._dest.hashCode() : 0;
        result = 31 * result + (this._source != null ? this._source.hashCode() : 0);
        result = 31 * result + (this._directory ? 1 : 0);
        result = 31 * result + (this._symlink ? 1 : 0);
        return result;
    }

    @Override
    public String getGroup() {
        return this._group;
    }

    @Override
    public void setGroup(String group) {
        this._group = group;
    }

    @Override
    public String getArtifact() {
        return this._artifact;
    }

    @Override
    public void setArtifact(String artifact) {
        this._artifact = artifact;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(String version) {
        this._version = version;
    }

    @Override
    public boolean isIgnoreVersionKeywords() {
        return this._ignoreVersionKeywords;
    }

    @Override
    public void setIgnoreVersionKeywords(boolean ignoreVersionKeywords) {
        this._ignoreVersionKeywords = ignoreVersionKeywords;
    }

    @Override
    public String getBaseVersion() {
        return this._baseVersion;
    }

    @Override
    public void setBaseVersion(String version) {
        this._baseVersion = version;
    }

    @Override
    public String getClassifier() {
        return this._classifier;
    }

    @Override
    public void setClassifier(String classifier) {
        this._classifier = classifier;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public void setType(String type) {
        this._type = type;
    }

    public String getAction() {
        return this._action;
    }

    public void setAction(String action) {
        this._action = action;
    }

    public long getSize() {
        return this._size;
    }

    public void setSize(long size) {
        this._size = size;
    }

    public String getStatus() {
        return this._status;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public String getChecksum() {
        return this._checksum;
    }

    public void setChecksum(String checksum) {
        this._checksum = checksum;
    }
}

