/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.Version;
import com.oracle.cie.dependency.VersionHelper;
import com.oracle.cie.dependency.dao.VersionRange;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import java.util.List;
import java.util.Map;

public class FeatureCompatibility {
    private FeatureSet _srcFeature;
    private FeatureSet _destFeature;
    private Map<ComponentReference, List<ComponentReference>> _matchingComponents;
    private boolean _isCompatible;

    public FeatureCompatibility(FeatureSet srcFeature, FeatureSet destFeature, Mode mode) {
        if (srcFeature == null) {
            throw new NullPointerException("The source feature was null.");
        }
        if (destFeature == null) {
            throw new NullPointerException("The dest feature was null.");
        }
        if (mode == null) {
            throw new NullPointerException("The mode was null.");
        }
        this._srcFeature = srcFeature;
        this._destFeature = destFeature;
        this._matchingComponents = FeatureSetHelper.getInstance().getMatchingComponents(srcFeature, destFeature, mode);
        this._isCompatible = this.isCompatible(srcFeature, destFeature);
    }

    public FeatureSet getSrcFeature() {
        return this._srcFeature;
    }

    public FeatureSet getDestFeature() {
        return this._destFeature;
    }

    public Map<ComponentReference, List<ComponentReference>> getMatchingComponents() {
        return this._matchingComponents;
    }

    public boolean hasMatchingComponents() {
        return !this._matchingComponents.isEmpty();
    }

    public boolean isCompatible() {
        return this._isCompatible;
    }

    private boolean isCompatible(FeatureSet srcFeature, FeatureSet destFeature) {
        if (!this.hasMatchingComponents() || srcFeature.equals(destFeature)) {
            return true;
        }
        String destName = destFeature.getName();
        Version destVer = new Version(destFeature.getVersion());
        List<FeatureReference> srcCompat = srcFeature.getCompatibleFeatures();
        for (FeatureReference ref : srcCompat) {
            if (!destName.equals(ref.getName())) continue;
            String version = ref.getVersion();
            if (version != null && destVer.equals((Object)new Version(ref.getVersion()))) {
                return true;
            }
            List<VersionRange> ranges = ref.getVersionRanges();
            if (ranges == null || ranges.isEmpty() || !VersionHelper.isVersionWithinRanges((Version)destVer, ref.getVersionRanges())) continue;
            return true;
        }
        String srcName = srcFeature.getName();
        Version srcVer = new Version(srcFeature.getVersion());
        List<FeatureReference> destCompat = destFeature.getCompatibleFeatures();
        for (FeatureReference ref : destCompat) {
            if (!ref.isReciprocal() || !srcName.equals(ref.getName())) continue;
            String version = ref.getVersion();
            if (version != null && srcVer.equals((Object)new Version(version))) {
                return true;
            }
            List<VersionRange> ranges = ref.getVersionRanges();
            if (ranges == null || ranges.isEmpty() || !VersionHelper.isVersionWithinRanges((Version)srcVer, ranges)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeDetails) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSrcFeature().toString(includeDetails)).append("->").append(this.getDestFeature().toString(includeDetails));
        if (includeDetails) {
            Map<ComponentReference, List<ComponentReference>> matchingComponents = this.getMatchingComponents();
            sb.append(" (");
            if (matchingComponents != null) {
                boolean sep = false;
                for (Map.Entry<ComponentReference, List<ComponentReference>> entry : matchingComponents.entrySet()) {
                    if (sep) {
                        sb.append(", ");
                    } else {
                        sep = true;
                    }
                    sb.append((Object)entry.getKey()).append("->").append(entry.getValue());
                }
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

