/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.DistributionTarget;
import com.oracle.cie.gdr.FeatureLoader;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.PatchLoader;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dbd.Distribution;
import com.oracle.cie.gdr.dao.dbd.FeatureSetReference;
import com.oracle.cie.gdr.dao.dbd.InstallType;
import com.oracle.cie.gdr.dao.di.DistributionInfo;
import com.oracle.cie.gdr.dao.ftr.ComponentReference;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.helpers.DistributionHelper;
import com.oracle.cie.gdr.helpers.DistributionInfoHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.gdr.utils.OraparamException;
import com.oracle.cie.rest.Repository;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DistributionLoader {
    private static final Logger _log = Logger.getLogger(DistributionLoader.class.getName());
    protected MetaDataHome _metaDataHome;
    private Distribution _distribution;
    private DistributionInfo _distributionInfo;
    private DistributionTarget _distributionTarget;
    private FeatureLoader _featureLoader;
    private PatchLoader _patchLoader;

    DistributionLoader(MetaDataHome metaDataHome, String distributionName, String distributionVersion) throws GdrException, IOException, DataHandlerException {
        this(metaDataHome, DistributionHelper.getInstance(metaDataHome.getClassLoader()).getDistribution(metaDataHome, distributionName, distributionVersion));
    }

    DistributionLoader(MetaDataHome metaDataHome, Distribution distribution) throws GdrException, IOException, DataHandlerException {
        this._metaDataHome = metaDataHome;
        this.init(distribution);
    }

    protected void init(Distribution distribution) throws GdrException, IOException, DataHandlerException {
        if (this._metaDataHome == null) {
            GdrException ex = new GdrException("The meta-data home provided was null.");
            _log.throwing(DistributionLoader.class.getName(), "init", ex);
            throw ex;
        }
        this.loadMetaData(distribution);
    }

    public String getDistributionName() {
        return this._distribution.getName();
    }

    public String getDistributionVersion() {
        return this._distribution.getVersion();
    }

    public Distribution getDistribution() {
        return this._distribution;
    }

    public DistributionInfo getDistributionInfo() {
        return this._distributionInfo;
    }

    public DistributionTarget getDistributionTarget() {
        return this._distributionTarget;
    }

    public DirectoryMap getDirectoryMap() {
        return this.getDistributionTarget().getDirectoryMap();
    }

    public MetaDataHome getMetaDataHome() {
        return this._metaDataHome;
    }

    public FeatureLoader getFeatureLoader() {
        return this._featureLoader;
    }

    public PatchLoader getPatchLoader() {
        return this._patchLoader;
    }

    protected void loadMetaData(String distributionName, String distributionVersion) throws GdrException, IOException, DataHandlerException {
        this.loadMetaData(DistributionHelper.getInstance().getDistribution(this.getMetaDataHome().getGdrMetaDataHomePath(), distributionName, distributionVersion));
    }

    protected void loadMetaData(Distribution distribution) throws GdrException, IOException, DataHandlerException {
        this._distribution = distribution;
        if (this._distribution == null) {
            GdrException ex = new GdrException("The distribution definition failed to load properly.");
            _log.throwing(DistributionLoader.class.getName(), "loadMetaData", ex);
            throw ex;
        }
        this._distributionInfo = this.loadDistributionInfo();
        this._featureLoader = this.createFeatureLoader();
        this._distributionTarget = this.createDistributionTarget();
        this._patchLoader = this.createPatchLoader();
    }

    protected DistributionInfo loadDistributionInfo() throws GdrException, IOException, DataHandlerException {
        try {
            if (this.getMetaDataHome().isRepository()) {
                return DistributionHelper.getInstance(this.getMetaDataHome().getClassLoader()).getDistributionInfoFromRepository(this.getMetaDataHome().getRepositoryService(), this.getDistributionName(), this.getDistributionVersion());
            }
            return DistributionInfoHelper.getInstance((ClassLoader)this.getMetaDataHome().getClassLoader()).getDistributionInfo(this.getMetaDataHome().getGdrMetaDataHomePath(), this.getDistributionName(), this.getDistributionVersion());
        }
        catch (OraparamException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof FileNotFoundException) {
                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "Unable to load distribution info because the file could not be found.", e);
                }
            } else {
                throw e;
            }
            return null;
        }
    }

    protected FeatureLoader createFeatureLoader() throws GdrException, IOException, DataHandlerException {
        Set<FeatureSetReference> featureRefs = DistributionHelper.getInstance().getFeatureSetReferences(this.getDistribution());
        this._featureLoader = new FeatureLoader(this._metaDataHome, featureRefs);
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Loaded " + this._featureLoader.getFeatureSets().size() + " feature sets for distribution: " + this.getDistribution());
        }
        return this._featureLoader;
    }

    protected PatchLoader createPatchLoader() throws GdrException, IOException, DataHandlerException {
        Set<FeatureSet> features = this._featureLoader.getFeatureSets();
        ArrayList<ComponentReference> distributionComponents = new ArrayList<ComponentReference>();
        for (FeatureSet feature : features) {
            if (null == feature || feature.isExternal()) continue;
            distributionComponents.addAll(feature.getComponentReferences());
        }
        this._patchLoader = new PatchLoader(this._metaDataHome, distributionComponents);
        if (_log.isLoggable(Level.FINER)) {
            _log.finer("Loaded " + this._patchLoader.getPatches().size() + " patch for distribution: " + this.getDistribution());
        }
        return this._patchLoader;
    }

    protected DistributionTarget createDistributionTarget() throws GdrException, IOException, DataHandlerException {
        return new DistributionTarget(this.getDistribution(), this._featureLoader.getFeatureSets(), this.getMetaDataHome());
    }

    public Set<FeatureSet> getFeatureSets() {
        return this.getDistributionTarget().getFeatureSets();
    }

    public Set<FeatureSet> getInstalledFeatureSets() {
        return this.getDistributionTarget().getInstalledFeatureSets();
    }

    public Set<InstallType> getInstallTypes() {
        LinkedHashSet<InstallType> installTypes = new LinkedHashSet<InstallType>();
        List<InstallType> defTypes = this.getDistribution().getInstallType();
        if (defTypes == null || defTypes.isEmpty()) {
            InstallType defaultInstallType = DistributionHelper.getInstance().createDefaultInstallType();
            defaultInstallType.setFullFeatures(DistributionHelper.getInstance().getFeatureSetReferences(this.getDistribution(), true));
            installTypes.add(defaultInstallType);
        } else {
            installTypes.addAll(defTypes);
        }
        return installTypes;
    }

    public InstallType getDefaultInstallType() {
        Set<InstallType> installTypes = this.getInstallTypes();
        for (InstallType installType : installTypes) {
            if (!installType.isDefault()) continue;
            return installType;
        }
        return installTypes.iterator().next();
    }

    public InstallType getInstallType(String name) {
        if (!StringUtil.isNullOrEmpty((String)name, (boolean)true)) {
            Set<InstallType> installTypes = this.getInstallTypes();
            for (InstallType installType : installTypes) {
                if (!installType.getName().equals(name)) continue;
                return installType;
            }
        }
        return null;
    }

    public void saveDistribution(File dir) throws GdrException, DataHandlerException, IOException {
        this.saveDistribution(NioHelper.getInstance().getPath(dir));
    }

    public void saveDistribution(Path dir) throws GdrException, DataHandlerException, IOException {
        DistributionHelper.getInstance().saveDistribution(this.getDistribution(), dir);
        DistributionInfo distributionInfo = this.getDistributionInfo();
        if (distributionInfo != null) {
            Path infoDir = dir.resolve("info");
            DistributionInfoHelper.getInstance().saveDistributionInfo(distributionInfo, infoDir);
        }
    }

    public void saveDistribution(Repository repository) throws GdrException, DataHandlerException, IOException {
        DistributionHelper.getInstance().saveDistribution(this.getDistribution(), repository);
    }

    public void saveDistributionInfo(Repository repository) throws GdrException, DataHandlerException, IOException {
        DistributionInfo distributionInfo = this.getDistributionInfo();
        if (distributionInfo != null) {
            DistributionHelper.getInstance().saveDistributionInfo(distributionInfo, repository);
        } else {
            _log.warning("Distribution-info file not found.");
        }
    }

    public String toString() {
        return this.getDistributionTarget().toString();
    }
}

