/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.gdr.FileTarget;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.cpd.FileMap;
import com.oracle.cie.gdr.dao.cpd.Permission;
import com.oracle.cie.gdr.dao.dbd.Mapping;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ComponentTarget {
    private static final Logger _log = Logger.getLogger(ComponentTarget.class.getName());
    private Component _component;
    private FileMap _componentFileMap;
    private Mapping _locationMapping;
    private Path _sourceFile;
    private Path _archiveLocation;
    private ServiceHolder _servicesHolder;
    private List<FileTarget> _bootstrapFileTargets;

    public ComponentTarget(Component component, FileMap componentFileMap, ServiceHolder servicesHolder) {
        this(component, componentFileMap, servicesHolder, null);
    }

    public ComponentTarget(Component component, FileMap componentFileMap, ServiceHolder servicesHolder, Mapping locationMapping) {
        if (component == null) {
            NullPointerException ex = new NullPointerException("The component provided was null.");
            _log.throwing(ComponentTarget.class.getName(), "ComponentTarget", ex);
            throw ex;
        }
        if (componentFileMap == null) {
            NullPointerException ex = new NullPointerException("The file map provided was null.");
            _log.throwing(ComponentTarget.class.getName(), "ComponentTarget", ex);
            throw ex;
        }
        this._component = component;
        this._componentFileMap = componentFileMap;
        this._servicesHolder = new ServiceHolder(servicesHolder, component.getNamespace());
        this._locationMapping = locationMapping;
    }

    public Component getComponent() {
        return this._component;
    }

    public FileMap getComponentFileMap() {
        return this._componentFileMap;
    }

    public Set<String> getPlatforms() {
        return this._componentFileMap.getPlatforms();
    }

    public ServiceHolder getServicesHolder() {
        return this._servicesHolder;
    }

    public Set<String> getLocales() {
        return this._componentFileMap.getLocales();
    }

    public abstract List<FileTarget> getFileTargets() throws GdrException;

    public List<Permission> getGlobalPermissions() {
        return this.getComponent().getPermissions();
    }

    public String getLocation() {
        return this._locationMapping != null ? this._locationMapping.getDirectory() : null;
    }

    public String getLocationMode() {
        String mode = this._locationMapping != null ? this._locationMapping.getMode() : null;
        return StringUtil.isNullOrEmpty((String)mode) ? "750" : mode;
    }

    public String getDirectoryMapName() {
        return this._locationMapping != null ? this._locationMapping.getDirectoryMapName() : null;
    }

    public String getSymbol() {
        return this._componentFileMap.getSymbol();
    }

    public String getSource() {
        return this._componentFileMap.getSource();
    }

    public void setSource(String source) {
        this._componentFileMap.setSource(source);
    }

    public File getSourceFile() {
        Path sourceFilePath = this.getSourceFilePath();
        return sourceFilePath != null ? sourceFilePath.toFile() : null;
    }

    public Path getSourceFilePath() {
        if (this._sourceFile == null) {
            Path archiveLocation = this.getArchiveLocationPath();
            String source = this.getSource();
            if (archiveLocation != null && !StringUtil.isNullOrEmpty((String)source, (boolean)true)) {
                if (!this._component.isCarb()) {
                    this._sourceFile = archiveLocation.resolve("DataFiles" + File.separator + source);
                    if (!Files.exists(this._sourceFile, new LinkOption[0]) && Files.exists(archiveLocation.resolve("DataFilesExtracted" + File.separator + source), new LinkOption[0])) {
                        _log.fine("Deprecated datafiles format detected at component source file for " + this);
                    }
                } else {
                    this._sourceFile = archiveLocation;
                }
            } else if (_log.isLoggable(Level.FINE)) {
                _log.fine("Unable to determine component source file for " + this);
            }
        }
        return this._sourceFile;
    }

    public void setSourceFile(File sourceFile) {
        this.setSourceFile(NioHelper.getInstance().getPath(sourceFile));
    }

    public void setSourceFile(Path sourceFile) {
        this._sourceFile = sourceFile;
    }

    public String getSourceJarPath() {
        if (this._component.isCarb()) {
            return ComponentHelper.getInstance().getRepositoryComponentArchiveDataPath(this.getComponent().getName(), this.getComponent().getVersion()) + "/" + this.getSource();
        }
        return null;
    }

    public File getArchiveLocation() {
        return this.getArchiveLocation(true);
    }

    public Path getArchiveLocationPath() {
        return this.getArchiveLocationPath(true);
    }

    public File getArchiveLocation(boolean useComponentValueAsFallback) {
        Path archiveLocationPath = this.getArchiveLocationPath(true);
        return archiveLocationPath != null ? archiveLocationPath.toFile() : null;
    }

    public Path getArchiveLocationPath(boolean useComponentValueAsFallback) {
        if (useComponentValueAsFallback) {
            return this._archiveLocation != null ? this._archiveLocation : this.getComponent().getArchiveLocationPath();
        }
        return this._archiveLocation;
    }

    public void setArchiveLocation(File archiveLocation) {
        this.setArchiveLocation(NioHelper.getInstance().getPath(archiveLocation));
    }

    public void setArchiveLocation(Path archiveLocation) {
        this._archiveLocation = archiveLocation;
    }

    public String getReferenceQualifier() {
        return this.getSource() + "+" + this.getLocation();
    }

    public long getSize() {
        return ComponentHelper.getInstance().getFileGroupSize(this.getComponentFileMap()) + ComponentHelper.getInstance().getLibrariesSize(this.getComponent());
    }

    public FileTarget locateFileTarget(String path, Mode mode) throws GdrException {
        List<FileTarget> fileTargets;
        if (!StringUtil.isNullOrEmpty((String)path, (boolean)true) && (fileTargets = this.getFileTargets()) != null && !fileTargets.isEmpty()) {
            if ((path = path.replace("\\", "/")).startsWith("/")) {
                path = path.substring(1);
            }
            if (!(StringUtil.isNullOrEmpty((String)this.getLocation()) || mode != null && mode.isPackagingMode())) {
                path = this.getLocation() + "/" + path;
            }
            for (FileTarget target : fileTargets) {
                if (!path.equals(target.getDest())) continue;
                return target;
            }
        }
        return null;
    }

    public FileTarget locateFileTarget(String path) throws GdrException {
        List<FileTarget> fileTargets;
        if (!StringUtil.isNullOrEmpty((String)path, (boolean)true) && (fileTargets = this.getFileTargets()) != null && !fileTargets.isEmpty()) {
            if ((path = path.replace("\\", "/")).startsWith("/")) {
                path = path.substring(1);
            }
            if (!StringUtil.isNullOrEmpty((String)this.getLocation()) && !path.startsWith(this.getLocation())) {
                path = this.getLocation() + "/" + path;
            }
            for (FileTarget target : fileTargets) {
                if (!path.equals(target.getDest())) continue;
                return target;
            }
        }
        return null;
    }

    public boolean isBootstrap() {
        return this.getComponentFileMap().isBootstrap();
    }

    public boolean hasBootstrapFileTargets() throws GdrException {
        List<FileTarget> bootstrapFileTargets = this.getBootstrapFileTargets();
        return bootstrapFileTargets != null && !bootstrapFileTargets.isEmpty();
    }

    public List<FileTarget> getBootstrapFileTargets() throws GdrException {
        if (this._bootstrapFileTargets == null) {
            this._bootstrapFileTargets = new ArrayList<FileTarget>();
            List<FileTarget> fileTargets = this.getFileTargets();
            if (fileTargets != null && !fileTargets.isEmpty()) {
                for (FileTarget fileTarget : fileTargets) {
                    if (!fileTarget.isBootstrap()) continue;
                    this._bootstrapFileTargets.add(fileTarget);
                }
            }
        }
        return this._bootstrapFileTargets;
    }

    public String toString() {
        String s = this.getComponent() + " <" + this.getSymbol() + "> <" + this.getSource() + ">";
        String location = this.getLocation();
        if (location != null) {
            s = s + " [" + location + "]";
        }
        return s;
    }
}

