/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.gdr;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.gdr.MetaDataHome;
import com.oracle.cie.gdr.Mode;
import com.oracle.cie.gdr.dao.cmn.Reference;
import com.oracle.cie.gdr.dao.cpd.Component;
import com.oracle.cie.gdr.dao.dbd.DirectoryMap;
import com.oracle.cie.gdr.dao.dei.DeInstallInfo;
import com.oracle.cie.gdr.dao.ftr.FeatureSet;
import com.oracle.cie.gdr.dao.lbm.LabelMap;
import com.oracle.cie.gdr.dao.nfo.InstallerDistributionInfo;
import com.oracle.cie.gdr.helpers.ComponentHelper;
import com.oracle.cie.gdr.helpers.FeatureSetHelper;
import com.oracle.cie.gdr.nio.NioHelper;
import com.oracle.cie.gdr.services.ServiceHolder;
import com.oracle.cie.gdr.utils.GdrException;
import com.oracle.cie.rest.Repository;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ComponentLoader {
    private static final Logger _log = Logger.getLogger(ComponentLoader.class.getName());
    private MetaDataHome _metaDataHome;
    protected ServiceHolder _serviceHolder;
    private Mode _mode;
    protected DirectoryMap _directoryMap;
    private LabelMap _labelMap;
    private InstallerDistributionInfo _distributionInfo;
    private DeInstallInfo _deInstallInfo;
    protected Map<FeatureSet, Collection<Component>> _components;
    protected Map<Reference, Component> _previouslyLoadedComponents;

    public ComponentLoader(MetaDataHome metaDataHome, ServiceHolder serviceHolder, Mode mode, Set<FeatureSet> featureSets, DirectoryMap directoryMap, LabelMap labelMap) throws GdrException, IOException, DataHandlerException {
        this.init(metaDataHome, serviceHolder, mode, featureSets, directoryMap, labelMap, null, null, null);
    }

    public ComponentLoader(MetaDataHome metaDataHome, ServiceHolder serviceHolder, Mode mode, Set<FeatureSet> featureSets, DirectoryMap directoryMap) throws GdrException, IOException, DataHandlerException {
        this.init(metaDataHome, serviceHolder, mode, featureSets, directoryMap, null, null, null, null);
    }

    public ComponentLoader(MetaDataHome metaDataHome, ServiceHolder serviceHolder, Mode mode, Set<FeatureSet> featureSets, DirectoryMap directoryMap, InstallerDistributionInfo distributionInfo, LabelMap labelMap) throws GdrException, IOException, DataHandlerException {
        this(metaDataHome, serviceHolder, mode, featureSets, directoryMap, distributionInfo, labelMap, null);
    }

    public ComponentLoader(MetaDataHome metaDataHome, ServiceHolder serviceHolder, Mode mode, Set<FeatureSet> featureSets, DirectoryMap directoryMap, InstallerDistributionInfo distributionInfo, LabelMap labelMap, Map<Reference, Component> previouslyLoadedComponents) throws GdrException, IOException, DataHandlerException {
        this.init(metaDataHome, serviceHolder, mode, featureSets, directoryMap, labelMap, distributionInfo, null, null, previouslyLoadedComponents);
    }

    public ComponentLoader(MetaDataHome metaDataHome, ServiceHolder serviceHolder, Mode mode, Set<FeatureSet> featureSets, DirectoryMap directoryMap, InstallerDistributionInfo distributionInfo, LabelMap labelMap, Set<Reference> componentFilter, Map<Reference, Component> previouslyLoadedComponents) throws GdrException, IOException, DataHandlerException {
        this.init(metaDataHome, serviceHolder, mode, featureSets, directoryMap, labelMap, distributionInfo, null, componentFilter, previouslyLoadedComponents);
    }

    public ComponentLoader(MetaDataHome metaDataHome, ServiceHolder serviceHolder, Mode mode, Set<FeatureSet> featureSets, DirectoryMap directoryMap, DeInstallInfo deInstallInfo) throws GdrException, IOException, DataHandlerException {
        this.init(metaDataHome, serviceHolder, mode, featureSets, directoryMap, null, null, deInstallInfo, null);
    }

    public ComponentLoader(MetaDataHome metaDataHome, ServiceHolder serviceHolder, Mode mode, Set<FeatureSet> featureSets, DirectoryMap directoryMap, DeInstallInfo deInstallInfo, Set<Reference> componentFilter) throws GdrException, IOException, DataHandlerException {
        this.init(metaDataHome, serviceHolder, mode, featureSets, directoryMap, null, null, deInstallInfo, componentFilter);
    }

    public ComponentLoader(MetaDataHome metaDataHome, ServiceHolder serviceHolder, Mode mode, FeatureSet featureSet, DirectoryMap directoryMap, DeInstallInfo deInstallInfo, Set<Reference> componentFilter) throws GdrException, IOException, DataHandlerException {
        LinkedHashSet<FeatureSet> featureSets = new LinkedHashSet<FeatureSet>();
        featureSets.add(featureSet);
        this.init(metaDataHome, serviceHolder, mode, featureSets, directoryMap, null, null, deInstallInfo, componentFilter);
    }

    public MetaDataHome getMetaDataHome() {
        return this._metaDataHome;
    }

    public ServiceHolder getServiceHolder() {
        return this._serviceHolder;
    }

    public Mode getMode() {
        return this._mode;
    }

    public DirectoryMap getDirectoryMap() {
        return this._directoryMap;
    }

    public LabelMap getLabelMap() {
        return this._labelMap;
    }

    public InstallerDistributionInfo getDistributionInfo() {
        return this._distributionInfo;
    }

    public DeInstallInfo getDeInstallInfo() {
        return this._deInstallInfo;
    }

    protected void init(MetaDataHome metaDataHome, ServiceHolder serviceHolder, Mode mode, Set<FeatureSet> featureSets, DirectoryMap directoryMap, LabelMap labelMap, InstallerDistributionInfo distributionInfo, DeInstallInfo deInstallInfo, Set<Reference> componentFilter) throws GdrException, IOException, DataHandlerException {
        this.init(metaDataHome, serviceHolder, mode, featureSets, directoryMap, labelMap, distributionInfo, deInstallInfo, componentFilter, null);
    }

    protected void init(MetaDataHome metaDataHome, ServiceHolder serviceHolder, Mode mode, Set<FeatureSet> featureSets, DirectoryMap directoryMap, LabelMap labelMap, InstallerDistributionInfo distributionInfo, DeInstallInfo deInstallInfo, Set<Reference> componentFilter, Map<Reference, Component> previouslyLoadedComponents) throws GdrException, IOException, DataHandlerException {
        if (metaDataHome == null) {
            GdrException ex = new GdrException("The meta-data home provided was null.");
            _log.throwing(ComponentLoader.class.getName(), "init", (Throwable)ex);
            throw ex;
        }
        this._metaDataHome = metaDataHome;
        if (serviceHolder == null) {
            GdrException ex = new GdrException("The service holder provided was null.");
            _log.throwing(ComponentLoader.class.getName(), "init", (Throwable)ex);
            throw ex;
        }
        this._serviceHolder = serviceHolder;
        if (mode == null) {
            GdrException ex = new GdrException("The mode provided was null.");
            _log.throwing(ComponentLoader.class.getName(), "init", (Throwable)ex);
            throw ex;
        }
        this._mode = mode;
        if (featureSets == null || featureSets.isEmpty()) {
            GdrException ex = new GdrException("The feature sets provided were null or empty.");
            _log.throwing(ComponentLoader.class.getName(), "init", (Throwable)ex);
            throw ex;
        }
        if (directoryMap == null && !this.getMode().isPackagingMode() && !this.getMode().isQueryInstallMode()) {
            GdrException ex = new GdrException("The directory map provided was null and is required for " + (Object)((Object)this.getMode()) + " mode.");
            _log.throwing(ComponentLoader.class.getName(), "init", (Throwable)ex);
            throw ex;
        }
        this._directoryMap = directoryMap;
        if (labelMap == null && this.getMode().isPackagingMode() && !this.getMetaDataHome().isShiphome() && !this.getMetaDataHome().isRepository()) {
            GdrException ex = new GdrException("The label map was null and is required for " + (Object)((Object)this.getMode()) + " mode.");
            _log.throwing(ComponentLoader.class.getName(), "init", (Throwable)ex);
            throw ex;
        }
        this._labelMap = labelMap;
        this._distributionInfo = distributionInfo;
        this._deInstallInfo = deInstallInfo;
        this._previouslyLoadedComponents = previouslyLoadedComponents;
        this.loadFeatures(featureSets, componentFilter);
    }

    public void loadFeature(FeatureSet featureSet, Set<Reference> componentFilter) throws IOException, DataHandlerException, GdrException {
        LinkedHashSet<FeatureSet> featureSets = new LinkedHashSet<FeatureSet>();
        featureSets.add(featureSet);
        this.loadFeatures(featureSets, componentFilter);
    }

    public void loadFeatures(Set<FeatureSet> featureSets, Set<Reference> componentFilter) throws GdrException, IOException, DataHandlerException {
        if (this._components == null) {
            this._components = new LinkedHashMap<FeatureSet, Collection<Component>>();
        }
        Map<FeatureSet, Collection<Component>> componentsMap = this.buildComponentsMap(featureSets, componentFilter);
        ComponentHelper.getInstance(this.getMetaDataHome().getClassLoader()).initComponentVariables(this.getComponents(componentsMap), this.getServiceHolder().getVariableResolverService());
        if (componentsMap != null && !componentsMap.isEmpty()) {
            for (FeatureSet feature : componentsMap.keySet()) {
                Collection<Component> components = componentsMap.get(feature);
                if (this._components.containsKey(feature)) {
                    Collection<Component> currentComponents = this._components.get(feature);
                    for (Component component : components) {
                        if (currentComponents.contains(component)) continue;
                        currentComponents.add(component);
                    }
                    continue;
                }
                this._components.put(feature, components);
            }
        }
    }

    protected Map<FeatureSet, Collection<Component>> buildComponentsMap(Set<FeatureSet> featureSets, Set<Reference> componentsFilter) throws IOException, DataHandlerException, GdrException {
        if (this.getMode().isPackagingMode()) {
            return FeatureSetHelper.getInstance(this.getMetaDataHome().getClassLoader()).getPackagerComponentMap(this.getMode(), featureSets, this.getLabelMap(), this.getDirectoryMap(), this.getDistributionInfo(), this.getServiceHolder(), this.getMetaDataHome(), componentsFilter);
        }
        if (this.getMode().isInstallMode()) {
            return FeatureSetHelper.getInstance(this.getMetaDataHome().getClassLoader()).getInstallerComponentMap(this.getMode(), featureSets, this.getLabelMap(), this.getDirectoryMap(), this.getDistributionInfo(), this.getServiceHolder(), this.getMetaDataHome(), componentsFilter, this.getPreviouslyLoadedComponents());
        }
        if (this.getMode().isDeInstallMode()) {
            return FeatureSetHelper.getInstance(this.getMetaDataHome().getClassLoader()).getDeInstallerComponentMap(featureSets, this.getDirectoryMap(), this.getServiceHolder(), this.getDeInstallInfo(), this.getMetaDataHome(), componentsFilter);
        }
        GdrException ex = new GdrException("Unknown mode encountered: " + (Object)((Object)this.getMode()));
        _log.throwing(ComponentLoader.class.getName(), "buildComponentsMap", (Throwable)ex);
        throw ex;
    }

    public Set<Component> getComponents() {
        return this.getComponents(this.getComponentsMap());
    }

    protected Set<Component> getComponents(Map<FeatureSet, Collection<Component>> componentsMap) {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        for (Collection<Component> comps : componentsMap.values()) {
            components.addAll(comps);
        }
        return components;
    }

    public Set<Component> getComponents(FeatureSet feature) {
        LinkedHashSet<Component> components = new LinkedHashSet<Component>();
        Map<FeatureSet, Collection<Component>> componentsMap = this.getComponentsMap();
        Collection<Component> allComps = componentsMap.get(feature);
        if (allComps != null) {
            components.addAll(allComps);
        }
        return components;
    }

    public Component getComponent(String name, String version) {
        if (name != null && version != null) {
            for (Component comp : this.getComponents()) {
                if (!name.equals(comp.getName()) || !version.equals(comp.getVersion())) continue;
                return comp;
            }
        }
        return null;
    }

    public Map<FeatureSet, Collection<Component>> getComponentsMap() {
        return this._components;
    }

    public Map<Reference, Component> getPreviouslyLoadedComponents() {
        return this._previouslyLoadedComponents;
    }

    public void saveComponents(File dir) throws GdrException, IOException, DataHandlerException {
        this.saveComponents(NioHelper.getInstance().getPath(dir));
    }

    public void saveComponents(Path dir) throws GdrException, IOException, DataHandlerException {
        this.saveComponents(dir, false);
    }

    public void saveComponents(File dir, boolean clearSourceFields) throws GdrException, IOException, DataHandlerException {
        this.saveComponents(NioHelper.getInstance().getPath(dir), clearSourceFields);
    }

    public void saveComponents(Path dir, boolean clearSourceFields) throws GdrException, IOException, DataHandlerException {
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
            if (!Files.exists(dir, new LinkOption[0])) {
                GdrException ex = new GdrException("Directory specified did not exist and could not be created: " + dir);
                _log.throwing(ComponentLoader.class.getName(), "saveComponents", (Throwable)ex);
                throw ex;
            }
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            GdrException ex = new GdrException("Directory specified was not a directory: " + dir);
            _log.throwing(ComponentLoader.class.getName(), "saveComponents", (Throwable)ex);
            throw ex;
        }
        ComponentHelper.getInstance().saveComponentsInShipHomeStructure(dir, clearSourceFields, this.getComponents());
    }

    public void saveComponents(Repository repository) throws GdrException, IOException, DataHandlerException {
        ComponentHelper.getInstance().saveComponentsInRepositoryStructure(repository, this.getComponents());
    }
}

