/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao.tree;

import com.oracle.cie.common.dao.CachingDataHandler;
import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandler;
import com.oracle.cie.common.dao.tree.TreeDataHandlerSpiImpl;
import com.oracle.cie.common.tree.BasicTree;
import com.oracle.cie.common.tree.Tree;
import com.oracle.cie.common.tree.XMLTreeData;
import com.oracle.cie.common.tree.XMLTreeWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;

public class TreeDataHandler
extends CachingDataHandler {
    private Tree _tree;
    private String _element;
    private String _type;
    private String _namespace;
    private ClassLoader _classloader;
    private String[] _complexNames;
    private Map<String, QName> _complexTypes;
    private String[] _simpleNames;
    private String[] _attributeNames;
    private Map<String, String> _defaultAttribVals;
    private int cachedHash;
    private String _encoding;

    public TreeDataHandler(Tree tree, String element, String type, String namespace, ClassLoader classloader) {
        this._tree = tree;
        this._element = element;
        this._type = type != null ? type : TreeDataHandlerSpiImpl.getTypeName(element, namespace, classloader);
        this._namespace = namespace;
        this._classloader = classloader;
        TreeDataHandlerSpiImpl.populateTypeInfo(this, this._namespace, this._classloader);
    }

    @Override
    public String getElement() {
        return this._element;
    }

    @Override
    public String getType() {
        return this._type;
    }

    @Override
    public String getNamespace() {
        return this._namespace;
    }

    @Override
    public Object getSimpleContent() {
        XMLTreeData data = (XMLTreeData)this._tree.getData();
        return data.getText();
    }

    void setAttributeNames(String[] attributeNames) {
        this._attributeNames = attributeNames;
    }

    void setComplexNames(String[] complexNames) {
        this._complexNames = complexNames;
    }

    void setComplexTypes(Map<String, QName> complexTypes) {
        this._complexTypes = complexTypes;
    }

    void setSimpleNames(String[] simpleNames) {
        this._simpleNames = simpleNames;
    }

    void setDefaultAttributeValues(Map<String, String> defaultAttribVals) {
        this._defaultAttribVals = defaultAttribVals;
    }

    @Override
    public Object getAttributeValueInternal(String name) {
        XMLTreeData data = (XMLTreeData)this._tree.getData();
        Properties attribs = data.getAttributes();
        String value = null;
        if (attribs.containsKey(name)) {
            value = data.getAttribute(name);
        } else if (this._defaultAttribVals != null && this._defaultAttribVals.containsKey(name)) {
            value = this._defaultAttribVals.get(name);
        }
        if (value != null) {
            if ("true".equals(value)) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            return value;
        }
        return null;
    }

    @Override
    public void setAttributeValueInternal(String name, Object value) {
        if (value != null) {
            ((XMLTreeData)this._tree.getData()).setAttribute(name, value.toString());
        } else {
            ((XMLTreeData)this._tree.getData()).removeAttribute(name);
        }
    }

    @Override
    public Object getSimpleValueInternal(String name) {
        List<Tree> children = this._tree.getChildTreesWithId(name);
        if (children != null && children.size() > 0) {
            if (children.size() == 1) {
                return ((XMLTreeData)children.get(0).getData()).getText();
            }
            String[] strArray = new String[children.size()];
            for (int x = 0; x < children.size(); ++x) {
                strArray[x] = ((XMLTreeData)children.get(x).getData()).getText();
            }
            return strArray;
        }
        return null;
    }

    @Override
    public void setSimpleValueInternal(String name, Object value) {
        this.removeChildren(name);
        if (value != null) {
            Object[] array = !value.getClass().isArray() ? new Object[]{value} : (Object[])value;
            for (Object obj : array) {
                BasicTree tree = new BasicTree(name, new XMLTreeData());
                ((XMLTreeData)tree.getData()).setText(obj.toString());
                this._tree.addChild(tree);
            }
        }
    }

    @Override
    public IDataHandler[] getComplexValueInternal(String name) {
        List<Tree> children = this._tree.getChildTreesWithId(name);
        IDataHandler[] dataHandlers = new IDataHandler[children.size()];
        for (int x = 0; x < children.size(); ++x) {
            dataHandlers[x] = this.createTreeDataHandler(children.get(x), name);
        }
        return dataHandlers;
    }

    private TreeDataHandler createTreeDataHandler(Tree tree, String elementName) {
        QName qname;
        String typeName = null;
        String namespace = this.getNamespace();
        QName qName = qname = this._complexTypes != null ? this._complexTypes.get(elementName) : null;
        if (qname != null) {
            typeName = qname.getLocalPart();
            namespace = qname.getNamespaceURI();
        }
        return new TreeDataHandler(tree, elementName, typeName, namespace, this._classloader);
    }

    @Override
    public void setComplexValueInternal(String name, IDataHandler[] values) {
        this.removeChildren(name);
        if (values != null) {
            for (IDataHandler value : values) {
                Tree valueTree = (Tree)value.getObject();
                if (!name.equals(valueTree.getId())) {
                    valueTree.setId(name);
                }
                this._tree.addChild(valueTree);
            }
        }
    }

    @Override
    public void setComplexValueInternal(String name, IDataHandler value) {
        this.setComplexValue(name, new IDataHandler[]{value});
    }

    private void removeChildren(String name) {
        List<Tree> children = this._tree.getChildTreesWithId(name);
        for (Tree child : children) {
            this._tree.removeChild(child);
        }
    }

    @Override
    public IDataHandler createComplexValue(String name) {
        BasicTree bt = new BasicTree(name, new XMLTreeData());
        return this.createTreeDataHandler(bt, name);
    }

    @Override
    public IDataHandler addComplexValueInternal(String name) {
        BasicTree bt = new BasicTree(name, new XMLTreeData());
        this._tree.addChild(bt);
        return this.createTreeDataHandler(bt, name);
    }

    @Override
    public void addComplexValueInternal(String name, IDataHandler dataHandler) {
        this._tree.addChild((Tree)dataHandler.getObject());
    }

    @Override
    public String[] getAttributeNames() {
        if (this._attributeNames == null) {
            Enumeration<?> e = ((XMLTreeData)this._tree.getData()).getAttributes().propertyNames();
            ArrayList<String> list = new ArrayList<String>();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (s.startsWith("xmlns")) continue;
                list.add(s);
            }
            this._attributeNames = list.toArray(new String[list.size()]);
        }
        return this._attributeNames;
    }

    @Override
    public boolean hasAttributeName(String name) {
        String[] attributeNames;
        for (String attributeName : attributeNames = this.getAttributeNames()) {
            if (!attributeName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Class getAttributeType(String name) {
        return String.class;
    }

    @Override
    public String[] getSimpleNames() {
        if (this._simpleNames == null) {
            LinkedHashSet<String> childIds = new LinkedHashSet<String>();
            for (int x = 0; x < this._tree.getChildCount(); ++x) {
                Tree child = this._tree.getChild(x);
                if (!((XMLTreeData)child.getData()).hasText()) continue;
                childIds.add(child.getId());
            }
            this._simpleNames = childIds.toArray(new String[childIds.size()]);
        }
        return this._simpleNames;
    }

    @Override
    public boolean hasSimpleName(String name) {
        String[] simpleNames;
        for (String simpleName : simpleNames = this.getSimpleNames()) {
            if (!simpleName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Class getSimpleType(String name) {
        return String.class;
    }

    @Override
    public String[] getComplexNames() {
        if (this._complexNames == null) {
            LinkedHashSet<String> childIds = new LinkedHashSet<String>();
            for (int x = 0; x < this._tree.getChildCount(); ++x) {
                Tree child = this._tree.getChild(x);
                if (((XMLTreeData)child.getData()).hasText()) continue;
                childIds.add(child.getId());
            }
            this._complexNames = childIds.toArray(new String[childIds.size()]);
        }
        return this._complexNames;
    }

    @Override
    public boolean hasComplexName(String name) {
        String[] complexNames;
        for (String complexName : complexNames = this.getComplexNames()) {
            if (!complexName.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getObject() {
        return this._tree;
    }

    @Override
    public void save(File file) throws DataHandlerException {
        try {
            this.save(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new DataHandlerException(e);
        }
    }

    @Override
    public void save(OutputStream os) throws DataHandlerException {
        if (Boolean.getBoolean("TreeDataHandler.save.enabled")) {
            try {
                XMLTreeWriter.write(this._tree, os);
            }
            catch (IOException e) {
                throw new DataHandlerException(e);
            }
        } else {
            throw new DataHandlerException("Saving not permitted using TreeDataHandler by default.");
        }
    }

    @Override
    public void save(StringBuffer sb) {
        sb.append(XMLTreeWriter.asString(this._tree));
    }

    @Override
    public void save(XMLStreamWriter writer) throws DataHandlerException {
        throw new DataHandlerException("The ability to save to a XmlStreamWriter is currently not supported.");
    }

    @Override
    public IDataHandler copy() {
        try {
            return new TreeDataHandler((Tree)this._tree.clone(), this.getElement(), this.getType(), this.getNamespace(), this._classloader);
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public String[] getComments() {
        List<Object> comments = new ArrayList();
        if (this._tree != null) {
            comments = ((XMLTreeData)this._tree.getData()).getComments();
        }
        return comments.toArray(new String[comments.size()]);
    }

    @Override
    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public String toString() {
        return this._tree == null ? "" : XMLTreeWriter.asString(this._tree);
    }

    public int hashCode() {
        int hash = this.cachedHash;
        if (hash == 0) {
            this.getElement().hashCode();
            for (String attribute : this.getAttributeNames()) {
                if (this.getAttributeValue(attribute) == null) continue;
                hash += attribute.hashCode();
                hash += this.getAttributeValue(attribute).hashCode();
            }
            for (String value : this.getSimpleNames()) {
                Object simpleVal = this.getSimpleValue(value);
                if (simpleVal == null) continue;
                hash += value.hashCode();
                if (simpleVal instanceof String[]) {
                    String[] simpleValues;
                    for (String val : simpleValues = (String[])simpleVal) {
                        hash += val.hashCode();
                    }
                    continue;
                }
                hash += simpleVal.hashCode();
            }
            this.cachedHash = hash;
        }
        return hash;
    }

    public boolean equals(TreeDataHandler that) {
        boolean result = this.getElement().equals(that.getElement());
        result = result && this.getAttributeNames().length == that.getAttributeNames().length;
        for (String attribute : this.getAttributeNames()) {
            result = result && this.getAttributeValue(attribute).equals(that.getAttributeValue(attribute));
        }
        result = result && this.getSimpleNames().length == that.getSimpleNames().length;
        for (String simpleVal : this.getSimpleNames()) {
            result = result && this.getSimpleValue(simpleVal).equals(that.getSimpleValue(simpleVal));
        }
        return result;
    }
}

