/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao;

import com.oracle.cie.common.dao.DataHandlerException;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XmlString;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaInfoLoader {
    private Map<QName, XSComplexType> _types = new HashMap<QName, XSComplexType>();
    private Map<String, Map<String, XSComplexType>> _elements = new HashMap<String, Map<String, XSComplexType>>();
    private ClassLoader _classLoader;

    public SchemaInfoLoader(Collection<String> schemaLocations, ClassLoader classLoader) throws DataHandlerException {
        this._classLoader = classLoader == null ? SchemaInfoLoader.class.getClassLoader() : classLoader;
        this.addSchemaLocations(schemaLocations);
    }

    public void addSchemaLocations(Collection<String> schemaLocations) throws DataHandlerException {
        this.loadTypeInfo(new ArrayList<String>(schemaLocations));
    }

    private void loadTypeInfo(final List<String> schemaLocations) throws DataHandlerException {
        if (schemaLocations != null && !schemaLocations.isEmpty()) {
            XSSchemaSet schemaSet;
            XSOMParser parser = new XSOMParser(SAXParserFactory.newInstance());
            parser.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    exception.printStackTrace();
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    exception.printStackTrace();
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    exception.printStackTrace();
                }
            });
            parser.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId != null) {
                        String schemaName = systemId;
                        int index = schemaName.replaceAll("\\\\", "/").lastIndexOf("/");
                        if (index > -1 && schemaName.length() > index + 1) {
                            schemaName = schemaName.substring(index + 1);
                        }
                        for (String schemaLocation : schemaLocations) {
                            if (!schemaLocation.endsWith(schemaName)) continue;
                            schemaLocations.remove(schemaLocation);
                            InputStream is = SchemaInfoLoader.this._classLoader.getResourceAsStream(schemaLocation);
                            return new InputSource(is);
                        }
                    }
                    return null;
                }
            });
            while (!schemaLocations.isEmpty()) {
                InputStream is = this._classLoader.getResourceAsStream(schemaLocations.remove(0));
                if (is == null) continue;
                try {
                    InputSource inputSource = new InputSource(is);
                    inputSource.setSystemId(new File(System.getProperty("user.dir")).toURI().toString());
                    parser.parse(inputSource);
                }
                catch (Exception e) {
                    throw new DataHandlerException(e);
                }
            }
            try {
                schemaSet = parser.getResult();
            }
            catch (SAXException e) {
                throw new DataHandlerException(e);
            }
            if (schemaSet != null) {
                this.loadTypeInfo(schemaSet);
            }
        }
    }

    private void loadTypeInfo(XSSchemaSet schemaSet) {
        Iterator elements;
        if (schemaSet != null && (elements = schemaSet.iterateElementDecls()) != null) {
            while (elements.hasNext()) {
                this.loadTypeInfo(schemaSet, (XSElementDecl)elements.next());
            }
        }
    }

    private void loadTypeInfo(XSSchemaSet schemaSet, XSElementDecl element) {
        if (element != null && schemaSet != null) {
            XSType type = element.getType();
            String namespace = type.getTargetNamespace();
            if (namespace == null) {
                namespace = "";
            }
            if (type.isComplexType()) {
                XSComplexType complexType = type.asComplexType();
                this._types.put(new QName(namespace, type.getName()), complexType);
                Map<String, XSComplexType> typeMap = this._elements.get(namespace);
                String name = element.getName();
                if (typeMap == null || !typeMap.containsKey(name)) {
                    if (typeMap == null) {
                        typeMap = new HashMap<String, XSComplexType>();
                        this._elements.put(namespace, typeMap);
                    }
                    typeMap.put(name, complexType);
                    XSParticle[] children = this.getChildren(complexType);
                    if (children != null && children.length > 0) {
                        for (XSParticle p : children) {
                            XSTerm pterm = p.getTerm();
                            if (!pterm.isElementDecl()) continue;
                            this.loadTypeInfo(schemaSet, pterm.asElementDecl());
                        }
                    }
                }
            }
        }
    }

    private XSParticle[] getChildren(XSComplexType complexType) {
        XSTerm term;
        XSParticle particle;
        XSContentType content = complexType.getContentType();
        if (content != null && (particle = content.asParticle()) != null && (term = particle.getTerm()).isModelGroup()) {
            return term.asModelGroup().getChildren();
        }
        return null;
    }

    private XSComplexType getType(String elementName, String typeName, String namespace) {
        if (namespace == null) {
            namespace = "";
        }
        XSComplexType complexType = null;
        if (typeName != null) {
            QName qname = new QName(namespace, typeName);
            complexType = this._types.get(qname);
        }
        if (complexType == null) {
            Map<String, XSComplexType> typeMap = this._elements.get(namespace);
            complexType = typeMap != null ? typeMap.get(elementName) : null;
        }
        return complexType;
    }

    public String getTypeName(String elementName, String namespace) {
        XSComplexType complexType = this.getType(elementName, null, namespace);
        return complexType != null ? complexType.getName() : null;
    }

    private Collection<? extends XSAttributeUse> getAttributes(String elementName, String typeName, String namespace) {
        XSComplexType complexType = this.getType(elementName, typeName, namespace);
        return complexType != null ? complexType.getAttributeUses() : null;
    }

    public String[] getAttributeNames(String elementName, String typeName, String namespace) {
        Collection<? extends XSAttributeUse> attribs = this.getAttributes(elementName, typeName, namespace);
        if (attribs != null) {
            ArrayList<String> attribNames = new ArrayList<String>();
            for (XSAttributeUse xSAttributeUse : attribs) {
                attribNames.add(xSAttributeUse.getDecl().getName());
            }
            return attribNames.toArray(new String[attribNames.size()]);
        }
        return null;
    }

    public String[] getSimpleElementNames(String elementName, String typeName, String namespace) {
        XSParticle[] children;
        XSComplexType complexType = this.getType(elementName, typeName, namespace);
        if (complexType != null && (children = this.getChildren(complexType)) != null && children.length > 0) {
            ArrayList<String> simpleNames = new ArrayList<String>();
            for (XSParticle p : children) {
                XSElementDecl element;
                XSType xstype;
                XSTerm pterm = p.getTerm();
                if (!pterm.isElementDecl() || (xstype = (element = pterm.asElementDecl()).getType()) == null || !xstype.isSimpleType()) continue;
                simpleNames.add(element.getName());
            }
            return simpleNames.toArray(new String[simpleNames.size()]);
        }
        return null;
    }

    public String[] getComplexElementNames(String elementName, String typeName, String namespace) {
        XSParticle[] children;
        XSComplexType complexType = this.getType(elementName, typeName, namespace);
        if (complexType != null && (children = this.getChildren(complexType)) != null && children.length > 0) {
            ArrayList<String> complexNames = new ArrayList<String>();
            for (XSParticle p : children) {
                XSElementDecl element;
                XSType xstype;
                XSTerm pterm = p.getTerm();
                if (!pterm.isElementDecl() || (xstype = (element = pterm.asElementDecl()).getType()) == null || !xstype.isComplexType()) continue;
                complexNames.add(element.getName());
            }
            return complexNames.toArray(new String[complexNames.size()]);
        }
        return null;
    }

    public Map<String, QName> getComplexTypeNames(String elementName, String typeName, String namespace) {
        XSParticle[] children;
        XSComplexType complexType = this.getType(elementName, typeName, namespace);
        if (complexType != null && (children = this.getChildren(complexType)) != null && children.length > 0) {
            HashMap<String, QName> complexTypes = new HashMap<String, QName>();
            for (XSParticle p : children) {
                XSElementDecl element;
                XSType xstype;
                XSTerm pterm = p.getTerm();
                if (!pterm.isElementDecl() || (xstype = (element = pterm.asElementDecl()).getType()) == null || !xstype.isComplexType()) continue;
                complexTypes.put(element.getName(), new QName(xstype.getTargetNamespace(), xstype.getName()));
            }
            return complexTypes;
        }
        return null;
    }

    public Map<String, String> getDefaultAttributeValues(String elementName, String typeName, String namespace) {
        Collection<? extends XSAttributeUse> attribs = this.getAttributes(elementName, typeName, namespace);
        if (attribs != null) {
            HashMap<String, String> attribVals = new HashMap<String, String>();
            for (XSAttributeUse xSAttributeUse : attribs) {
                XSAttributeDecl attribDecl = xSAttributeUse.getDecl();
                XmlString defaultVal = attribDecl.getDefaultValue();
                if (defaultVal == null) continue;
                attribVals.put(attribDecl.getName(), defaultVal.toString());
            }
            return attribVals;
        }
        return null;
    }
}

