/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.dao;

import com.oracle.cie.common.dao.DataHandlerException;
import com.oracle.cie.common.dao.IDataHandler;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.xml.transform.sax.SAXSource;

public abstract class DataHandlerSpi {
    public static DataHandlerSpi getDataHandlerProvider() throws DataHandlerConfigurationException {
        return DataHandlerSpi.getDataHandlerProvider(null);
    }

    public static DataHandlerSpi getDataHandlerProvider(ClassLoader classLoader) throws DataHandlerConfigurationException {
        DataHandlerSpi spi = DataHandlerSpi.getDataHandlerProvider(classLoader, System.getProperty(DataHandlerSpi.class.getName()));
        if (spi == null) {
            Iterator<DataHandlerSpi> it = ServiceLoader.load(DataHandlerSpi.class, classLoader == null ? DataHandlerSpi.class.getClassLoader() : classLoader).iterator();
            if (it.hasNext()) {
                spi = it.next();
            }
            if (spi == null) {
                throw new DataHandlerConfigurationException("Unable to locate DataHandlerSpi implementation.");
            }
        }
        return spi;
    }

    public static DataHandlerSpi getDataHandlerProvider(ClassLoader classLoader, String providerClassName) throws DataHandlerConfigurationException {
        if (providerClassName != null && !"".equals(providerClassName)) {
            try {
                Class<?> providerClass = classLoader == null ? DataHandlerSpi.class.getClassLoader().loadClass(providerClassName) : classLoader.loadClass(providerClassName);
                return (DataHandlerSpi)providerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new DataHandlerConfigurationException("Unable to locate DataHandlerSpi implementation " + providerClassName, e);
            }
            catch (IllegalAccessException e) {
                throw new DataHandlerConfigurationException("Unable to locate DataHandlerSpi implementation " + providerClassName, e);
            }
            catch (InstantiationException e) {
                throw new DataHandlerConfigurationException("Unable to locate DataHandlerSpi implementation " + providerClassName, e);
            }
        }
        return null;
    }

    public IDataHandler create(String namespace, String id) {
        return this.create(namespace, id, (ClassLoader)null);
    }

    public abstract IDataHandler create(String var1, String var2, ClassLoader var3);

    public IDataHandler create(String namespace, String id, File file) throws DataHandlerException {
        return this.create(namespace, id, file, null);
    }

    public abstract IDataHandler create(String var1, String var2, File var3, ClassLoader var4) throws DataHandlerException;

    public IDataHandler create(String namespace, String id, InputStream is) throws DataHandlerException {
        return this.create(namespace, id, is, null);
    }

    public abstract IDataHandler create(String var1, String var2, InputStream var3, ClassLoader var4) throws DataHandlerException;

    public IDataHandler create(String namespace, String id, String s) throws DataHandlerException {
        return this.create(namespace, id, s, null);
    }

    public abstract IDataHandler create(String var1, String var2, String var3, ClassLoader var4) throws DataHandlerException;

    public IDataHandler create(String namespace, String id, URL url) throws DataHandlerException {
        return this.create(namespace, id, url, null);
    }

    public abstract IDataHandler create(String var1, String var2, URL var3, ClassLoader var4) throws DataHandlerException;

    public abstract IDataHandler create(String var1, String var2, SAXSource var3, ClassLoader var4) throws DataHandlerException;

    public IDataHandler createFromJson(String namespace, String id, File file, ClassLoader classloader) throws DataHandlerException {
        throw new DataHandlerException("Creating from JSON not supported by this handler.");
    }

    public IDataHandler createFromJson(String namespace, String id, InputStream is, ClassLoader classloader) throws DataHandlerException {
        throw new DataHandlerException("Creating from JSON not supported by this handler.");
    }

    static class DataHandlerConfigurationException
    extends RuntimeException {
        DataHandlerConfigurationException(String msg, Exception x) {
            super(msg, x);
        }

        public DataHandlerConfigurationException(String message) {
            super(message);
        }
    }
}

