/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.dsig.XSManifest;
import oracle.security.xmlsec.dsig.XSObject;
import oracle.security.xmlsec.dsig.XSReference;
import oracle.security.xmlsec.dsig.XSSigProperties;
import oracle.security.xmlsec.dsig.XSSigProperty;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.dsig.XSSignatureValue;
import oracle.security.xmlsec.dsig.XSSignedInfo;
import oracle.security.xmlsec.enc.OriginatorKeyInfo;
import oracle.security.xmlsec.enc.RecipientKeyInfo;
import oracle.security.xmlsec.enc.XECipherData;
import oracle.security.xmlsec.enc.XECipherReference;
import oracle.security.xmlsec.enc.XEDataReference;
import oracle.security.xmlsec.enc.XEEncryptedData;
import oracle.security.xmlsec.enc.XEEncryptedKey;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XEEncryptionProperties;
import oracle.security.xmlsec.enc.XEEncryptionProperty;
import oracle.security.xmlsec.enc.XEKeyReference;
import oracle.security.xmlsec.enc.XEReferenceList;
import oracle.security.xmlsec.keys.AgreementMethod;
import oracle.security.xmlsec.keys.ConcatKDFParams;
import oracle.security.xmlsec.keys.DHKeyValue;
import oracle.security.xmlsec.keys.DSAKeyValue;
import oracle.security.xmlsec.keys.DerivedKey;
import oracle.security.xmlsec.keys.ECDSAKeyValue;
import oracle.security.xmlsec.keys.ECKeyValue;
import oracle.security.xmlsec.keys.KeyDerivationMethod;
import oracle.security.xmlsec.keys.KeyName;
import oracle.security.xmlsec.keys.KeyValue;
import oracle.security.xmlsec.keys.MgmtData;
import oracle.security.xmlsec.keys.PBKDF2params;
import oracle.security.xmlsec.keys.PGPData;
import oracle.security.xmlsec.keys.RSAKeyValue;
import oracle.security.xmlsec.keys.RetrievalMethod;
import oracle.security.xmlsec.keys.SPKIData;
import oracle.security.xmlsec.keys.X509Data;
import oracle.security.xmlsec.util.XMLElement;

public class TagManager {
    private HashMap<String, HashMap<String, Class<? extends XMLElement>>> nsMap = new HashMap();
    private static TagManager tagMgr;

    public TagManager() {
        this(true);
    }

    public TagManager(boolean defaultMappings) {
        if (defaultMappings) {
            this.mapXMLDSig();
            this.mapXMLEnc();
        }
    }

    public static synchronized void setTagManager(TagManager tagMgr) {
        TagManager.tagMgr = tagMgr;
    }

    public static TagManager getTagManager() {
        if (tagMgr != null) {
            return tagMgr;
        }
        return TagManager.createTagManager();
    }

    private static synchronized TagManager createTagManager() {
        if (tagMgr == null) {
            tagMgr = new TagManager(true);
        }
        return tagMgr;
    }

    public HashMap<String, Class<? extends XMLElement>> mapNamespace(String ns, HashMap<String, Class<? extends XMLElement>> tagMap) {
        return this.nsMap.put(ns, tagMap);
    }

    public Hashtable<String, Class<? extends XMLElement>> mapNamespace(String ns, Hashtable<String, Class<? extends XMLElement>> tagMap) {
        HashMap<String, Class<? extends XMLElement>> h = this.nsMap.put(ns, new HashMap<String, Class<? extends XMLElement>>(tagMap));
        if (h == null) {
            return null;
        }
        return new Hashtable<String, Class<? extends XMLElement>>(h);
    }

    public HashMap<String, Class<? extends XMLElement>> getTagHashMap(String ns) {
        return ns != null ? this.nsMap.get(ns) : null;
    }

    public Hashtable<String, Class<? extends XMLElement>> getTagMap(String ns) {
        if (ns == null) {
            return null;
        }
        HashMap<String, Class<? extends XMLElement>> h = this.nsMap.get(ns);
        if (h == null) {
            return null;
        }
        return new Hashtable<String, Class<? extends XMLElement>>(h);
    }

    public Class mapTag(String ns, String tag, Class c) {
        HashMap<String, Class<? extends XMLElement>> oldTagMap = this.getTagHashMap(ns);
        Class<? extends XMLElement> oldClass = oldTagMap != null ? oldTagMap.get(tag) : null;
        HashMap<String, Class<? extends XMLElement>> newTagMap = oldTagMap != null ? oldTagMap : new HashMap<String, Class<? extends XMLElement>>();
        newTagMap.put(tag, c);
        if (newTagMap != oldTagMap) {
            this.mapNamespace(ns, newTagMap);
        }
        return oldClass;
    }

    public Class<? extends XMLElement> getClassForTag(String ns, String tag) {
        HashMap<String, Class<? extends XMLElement>> tagMap = this.getTagHashMap(ns);
        if (tagMap != null) {
            return tagMap.get(tag);
        }
        Iterator<String> i = this.nsMap.keySet().iterator();
        while (i.hasNext()) {
            Class<? extends XMLElement> c;
            tagMap = this.nsMap.get(i.next());
            if (tagMap == null || (c = tagMap.get(tag)) == null) continue;
            return c;
        }
        return null;
    }

    public void mapXMLDSig() {
        HashMap<String, Class<? extends XMLElement>> dsigMap = new HashMap<String, Class<? extends XMLElement>>();
        dsigMap.put("Signature", XSSignature.class);
        dsigMap.put("SignedInfo", XSSignedInfo.class);
        dsigMap.put("SignatureValue", XSSignatureValue.class);
        dsigMap.put("KeyInfo", XSKeyInfo.class);
        dsigMap.put("Object", XSObject.class);
        dsigMap.put("CanonicalizationMethod", XSAlgorithmIdentifier.class);
        dsigMap.put("SignatureMethod", XSAlgorithmIdentifier.class);
        dsigMap.put("Reference", XSReference.class);
        dsigMap.put("DigestMethod", XSAlgorithmIdentifier.class);
        dsigMap.put("Transform", XSAlgorithmIdentifier.class);
        dsigMap.put("Manifest", XSManifest.class);
        dsigMap.put("SignatureProperties", XSSigProperties.class);
        dsigMap.put("SignatureProperty", XSSigProperty.class);
        dsigMap.put("KeyName", KeyName.class);
        dsigMap.put("KeyValue", KeyValue.class);
        dsigMap.put("RetrievalMethod", RetrievalMethod.class);
        dsigMap.put("X509Data", X509Data.class);
        dsigMap.put("PGPData", PGPData.class);
        dsigMap.put("SPKIData", SPKIData.class);
        dsigMap.put("MgmtData", MgmtData.class);
        dsigMap.put("DSAKeyValue", DSAKeyValue.class);
        dsigMap.put("RSAKeyValue", RSAKeyValue.class);
        this.mapNamespace("http://www.w3.org/2000/09/xmldsig#", dsigMap);
        dsigMap = new HashMap();
        dsigMap.put("ECDSAKeyValue", ECDSAKeyValue.class);
        this.mapNamespace("http://www.w3.org/2001/04/xmldsig-more#", dsigMap);
        dsigMap = new HashMap();
        dsigMap.put("ECKeyValue", ECKeyValue.class);
        this.mapNamespace("http://www.w3.org/2009/xmldsig11#", dsigMap);
    }

    public void mapXMLEnc() {
        HashMap<String, Class<? extends XMLElement>> encMap = new HashMap<String, Class<? extends XMLElement>>();
        encMap.put("CipherData", XECipherData.class);
        encMap.put("CipherReference", XECipherReference.class);
        encMap.put("DataReference", XEDataReference.class);
        encMap.put("EncryptedData", XEEncryptedData.class);
        encMap.put("EncryptedKey", XEEncryptedKey.class);
        encMap.put("EncryptionProperty", XEEncryptionProperty.class);
        encMap.put("EncryptionProperties", XEEncryptionProperties.class);
        encMap.put("EncryptionMethod", XEEncryptionMethod.class);
        encMap.put("KeyReference", XEKeyReference.class);
        encMap.put("OriginatorKeyInfo", OriginatorKeyInfo.class);
        encMap.put("RecipientKeyInfo", RecipientKeyInfo.class);
        encMap.put("ReferenceList", XEReferenceList.class);
        encMap.put("AgreementMethod", AgreementMethod.class);
        encMap.put("DHKeyValue", DHKeyValue.class);
        this.mapNamespace("http://www.w3.org/2001/04/xmlenc#", encMap);
        encMap = new HashMap();
        encMap.put("ConcatKDFParams", ConcatKDFParams.class);
        encMap.put("PBKDF2-params", PBKDF2params.class);
        encMap.put("DerivedKey", DerivedKey.class);
        encMap.put("KeyDerivationMethod", KeyDerivationMethod.class);
        encMap.put("MGF", XSAlgorithmIdentifier.class);
        encMap.put("PRF", XSAlgorithmIdentifier.class);
        this.mapNamespace("http://www.w3.org/2009/xmlenc11#", encMap);
    }
}

