/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.xmlsec.dsig.ObjectReference;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.enc.XEException;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLContainer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPMessageUtils {
    private static Method setDataHandler;
    private static Method getDataHandler;
    private static Class classOracleSOAPElement;

    public static Element addChildElementWithBinaryContent(Element parent, String localName, String prefix, String uri, byte[] value, boolean useLineBreaks) throws DOMException {
        Element docElem;
        Document owner = parent.getOwnerDocument();
        Element childElem = null;
        if (parent.getNamespaceURI().equals(uri)) {
            prefix = parent.getPrefix();
        }
        if (prefix.equals("")) {
            prefix = null;
        }
        if ((docElem = owner.getDocumentElement()) instanceof SOAPEnvelope && docElem.getClass().getName().startsWith("oracle.j2ee.ws.saaj")) {
            SOAPEnvelope soapEnv = (SOAPEnvelope)docElem;
            try {
                childElem = soapEnv.getBody().addChildElement(localName, prefix, uri);
                if (classOracleSOAPElement == null) {
                    classOracleSOAPElement = Class.forName("oracle.webservices.soap.OracleSOAPElement");
                    setDataHandler = classOracleSOAPElement.getDeclaredMethod("setDataHandler", DataHandler.class);
                    getDataHandler = classOracleSOAPElement.getDeclaredMethod("getDataHandler", new Class[0]);
                }
                ByteArrayDataSource ds = new ByteArrayDataSource(value, "application/octet-stream");
                DataHandler dh = new DataHandler((DataSource)ds);
                setDataHandler.invoke((Object)childElem, dh);
                childElem.removeAttributeNS("http://www.w3.org/2005/05/xmlmime", "contentType");
                childElem.removeAttributeNS("http://www.w3.org/2000/xmlns/", "xmime");
            }
            catch (SOAPException ex) {
                DOMException ex1 = new DOMException(15, "Can't call SOAPElement.addChildElement");
                ex1.initCause(ex);
                throw ex1;
            }
            catch (ClassNotFoundException ex) {
                DOMException ex1 = new DOMException(15, "Can't find OracleSOAPElement");
                ex1.initCause(ex);
                throw ex1;
            }
            catch (NoSuchMethodException ex) {
                DOMException ex1 = new DOMException(15, "Can't find setDataHandler");
                ex1.initCause(ex);
                throw ex1;
            }
            catch (InvocationTargetException ex) {
                DOMException ex1 = new DOMException(15, "Can't invoke setDataHandler");
                ex1.initCause(ex);
                throw ex1;
            }
            catch (IllegalAccessException ex) {
                DOMException ex1 = new DOMException(15, "Can't invoke setDataHandler");
                ex1.initCause(ex);
                throw ex1;
            }
        }
        if (childElem == null) {
            childElem = owner.createElementNS(uri, prefix == null ? localName : prefix + ":" + localName);
            childElem.appendChild(owner.createTextNode(Base64.toBase64(value, useLineBreaks)));
        }
        parent.appendChild(childElem);
        return childElem;
    }

    private static boolean checkXOPChildElement(Element elem) {
        Node node;
        String localname_xop = "Include";
        String namespace = "http://www.w3.org/2004/08/xop/include";
        return elem.hasChildNodes() && (node = elem.getFirstChild()).getNodeType() == 1 && "Include".equals(node.getLocalName()) && "http://www.w3.org/2004/08/xop/include".equals(node.getNamespaceURI());
    }

    public static InputStream getBinaryContentForChildElement(Element elem) {
        if (!elem.getClass().getName().startsWith("oracle.j2ee.ws.saaj") && !SOAPMessageUtils.checkXOPChildElement(elem)) {
            return null;
        }
        if (elem.getClass().getName().startsWith("oracle.j2ee.ws.saaj")) {
            if (elem.getFirstChild() == null || !elem.getFirstChild().getClass().getName().equals("oracle.j2ee.ws.saaj.soap.BinaryTextImpl")) {
                return null;
            }
            try {
                if (classOracleSOAPElement == null) {
                    classOracleSOAPElement = Class.forName("oracle.webservices.soap.OracleSOAPElement");
                    setDataHandler = classOracleSOAPElement.getDeclaredMethod("setDataHandler", DataHandler.class);
                    getDataHandler = classOracleSOAPElement.getDeclaredMethod("getDataHandler", new Class[0]);
                }
                DataHandler dh = (DataHandler)getDataHandler.invoke((Object)elem, new Object[0]);
                return dh.getInputStream();
            }
            catch (IOException ex) {
                DOMException ex1 = new DOMException(15, "Can't call getDataHandler");
                ex1.initCause(ex);
                throw ex1;
            }
            catch (ClassNotFoundException ex) {
                DOMException ex1 = new DOMException(15, "Can't find OracleSOAPElement");
                ex1.initCause(ex);
                throw ex1;
            }
            catch (NoSuchMethodException ex) {
                DOMException ex1 = new DOMException(15, "Can't find getDataHandler");
                ex1.initCause(ex);
                throw ex1;
            }
            catch (InvocationTargetException ex) {
                DOMException ex1 = new DOMException(15, "Can't invoke getDataHandler");
                ex1.initCause(ex);
                throw ex1;
            }
            catch (IllegalAccessException ex) {
                DOMException ex1 = new DOMException(15, "Can't invoke getDataHandler");
                ex1.initCause(ex);
                throw ex1;
            }
        }
        Element e = (Element)elem.getFirstChild();
        try {
            XMLContainer xmlContainer = ObjectReference.dereference(e.getAttribute("href"), elem.getOwnerDocument(), elem, null);
            return xmlContainer.getOctetStream();
        }
        catch (ReferenceException referenceException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static void writeTo(SOAPMessage msg, OutputStream out) throws IOException, SOAPException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        PrintStream osw = null;
        try {
            osw = new PrintStream(out, false, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Iterator it = msg.getMimeHeaders().getAllHeaders();
        while (it.hasNext()) {
            MimeHeader mh = (MimeHeader)it.next();
            osw.print(mh.getName());
            osw.print(':');
            osw.print(mh.getValue());
            osw.print("\r\n");
        }
        osw.print("\r\n");
        out.write(bos.toByteArray());
    }

    public static MimeHeaders readHeaders(InputStream is) throws IOException {
        ArrayList<String> headers = new ArrayList<String>();
        int c = is.read();
        while (c != 13) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while (c != 13) {
                bos.write(c);
                c = is.read();
            }
            is.read();
            String header = new String(bos.toByteArray(), "ASCII");
            if (header.startsWith(" ") && headers.size() > 0) {
                String lastHeader = (String)headers.get(headers.size() - 1);
                lastHeader = lastHeader + header;
                headers.set(headers.size() - 1, lastHeader);
            } else {
                headers.add(header);
            }
            c = is.read();
        }
        is.read();
        MimeHeaders mh = new MimeHeaders();
        for (int i = 0; i < headers.size(); ++i) {
            String header = (String)headers.get(i);
            int colonPos = header.indexOf(":");
            mh.addHeader(header.substring(0, colonPos).trim(), header.substring(colonPos + 1).trim());
        }
        return mh;
    }

    public static Node importSoapElementNode(Document doc, Node importNode) throws XEException {
        Node node = null;
        if (doc.getClass().toString().equals("class org.jboss.ws.core.soap.SOAPPartImpl")) {
            try {
                SOAPFactory soapFactory = SOAPFactory.newInstance();
                node = soapFactory.createElement((Element)importNode);
            }
            catch (Exception ex) {
                throw new XEException(ex);
            }
        } else {
            node = doc.importNode(importNode, true);
        }
        return node;
    }

    public static class ByteArrayDataSource
    implements DataSource {
        private byte[] content;
        private String mimeType;

        public ByteArrayDataSource(byte[] content, String mimeType) {
            this.content = content;
            this.mimeType = mimeType;
        }

        public String getContentType() {
            return this.mimeType;
        }

        public InputStream getInputStream() throws IOException {
            return new UnsyncByteArrayInputStream(this.content);
        }

        public String getName() {
            return null;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Can't get OutputStream");
        }
    }
}

