/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLNode;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class QNameNode
extends XMLNode {
    public QNameNode(Text node) throws DOMException {
        super(node);
        if (!QName.isValidQName(node.getNodeValue())) {
            throw new DOMException(12, "Invalid QName");
        }
    }

    public QNameNode(Document owner, String prefix, String localName) throws DOMException {
        this(owner.createTextNode(QName.makeQName(prefix, localName)));
        if (!QName.isValidQName(this.node.getNodeValue())) {
            throw new DOMException(12, "Invalid QName");
        }
    }

    public QNameNode(Document owner, String qname) throws DOMException {
        this(owner.createTextNode(qname));
        if (!QName.isValidQName(qname)) {
            throw new DOMException(12, "Invalid QName");
        }
    }

    public void setPrefixPart(String prefix) throws DOMException {
        String pref;
        int len;
        if (prefix == null) {
            prefix = "";
        }
        if ((len = (pref = QName.getPrefixPart(this.node.getNodeValue())).length()) > 0 && prefix.length() == 0) {
            ++len;
        }
        ((Text)this.node).replaceData(0, len, prefix);
    }

    public String getPrefixPart() {
        return QName.getPrefixPart(this.node.getNodeValue());
    }

    public void setLocalPart(String localName) throws DOMException {
        if (localName == null || localName.length() == 0) {
            throw new DOMException(12, "QName must have local part");
        }
        String qname = this.node.getNodeValue();
        String pref = QName.getPrefixPart(qname);
        String name = QName.getLocalPart(qname);
        int len = name.length();
        int off = pref.length();
        if (pref.length() > 0) {
            ++off;
        }
        ((Text)this.node).replaceData(off, len, localName);
    }

    public String getLocalPart() throws DOMException {
        return QName.getLocalPart(this.node.getNodeValue());
    }

    public String resolvePrefix() {
        String pref = QName.getPrefixPart(this.node.getNodeValue());
        if (pref.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        Node parent = this.node.getParentNode();
        Node context = parent != null ? parent : this.node;
        return XMLUtils.resolveNSPrefix(pref, context);
    }

    public QName toQName() {
        return new QName(this.getLocalPart(), this.resolvePrefix(), this.getPrefixPart());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof QNameNode)) {
            return false;
        }
        QNameNode qn = (QNameNode)obj;
        return this.equals(qn.getLocalPart(), this.getLocalPart()) && this.equals(qn.resolvePrefix(), this.resolvePrefix());
    }

    public int hashCode() {
        return (this.resolvePrefix() + ":" + this.getLocalPart()).hashCode();
    }

    private boolean equals(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }
}

