/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IDCache {
    private static final String USERDATA_KEY = "osdt.idCache";
    private static boolean cacheEnabled = System.getProperty("osdt.disable.idCaching") == null;
    private static final Pattern idPattern = Pattern.compile("id|ID|Id|AssertionID|RequestID|ResponseID");
    private static final Map idAttrMap = XMLUtils.getIdAttributesMap();

    public static boolean isIDCacheEnabled(Document doc) {
        if (cacheEnabled) {
            try {
                doc.getUserData(USERDATA_KEY);
                return true;
            }
            catch (Exception e) {
                cacheEnabled = false;
                return false;
            }
        }
        return cacheEnabled;
    }

    private static String getID(Element elem) {
        if (!elem.hasAttributes()) {
            return null;
        }
        NamedNodeMap attribs = elem.getAttributes();
        int size = attribs.getLength();
        for (int i = 0; i < size; ++i) {
            ArrayList idList;
            Attr attr = (Attr)attribs.item(i);
            String name = attr.getLocalName();
            if (name == null) {
                name = attr.getName();
            }
            if (!idPattern.matcher(name).matches()) continue;
            String elemNs = elem.getNamespaceURI();
            if (elemNs != null && (elemNs.equals("http://www.w3.org/2000/09/xmldsig#") || elemNs.equals("http://www.w3.org/2001/04/xmlenc#") ? name.equals("Id") : (elemNs.equals("http://www.w3.org/1999/xhtml") ? name.equals("id") : (idList = (ArrayList)idAttrMap.get(elemNs)) != null && idList.contains(name)))) {
                return attr.getValue();
            }
            String attrNs = attr.getNamespaceURI();
            if (attrNs == null) continue;
            if (attrNs.equals("http://schemas.xmlsoap.org/soap/security/2000-12") && name.equals("id")) {
                return attr.getValue();
            }
            if (attrNs.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd") && name.equals("Id")) {
                return attr.getValue();
            }
            if (attrNs.equals("http://www.w3.org/XML/1998/namespace") && name.equals("id")) {
                return attr.getValue();
            }
            ArrayList idList2 = (ArrayList)idAttrMap.get(attrNs);
            if (idList2 == null || !idList2.contains(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    private static void populateIdCache(Element elem, Map idCache) {
        String idValue = IDCache.getID(elem);
        if (idValue != null) {
            idCache.put(idValue, elem);
        }
        for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            IDCache.populateIdCache((Element)n, idCache);
        }
    }

    private static Map getIdCache(Document doc, boolean initializeIdCache) {
        LinkedHashMap idCache = (LinkedHashMap)doc.getUserData(USERDATA_KEY);
        if (idCache == null && initializeIdCache) {
            idCache = new LinkedHashMap();
            doc.setUserData(USERDATA_KEY, idCache, null);
            if (doc.getDocumentElement() != null) {
                IDCache.populateIdCache(doc.getDocumentElement(), idCache);
            }
        }
        return idCache;
    }

    public static Element getElementById(Document doc, String id) {
        if (!cacheEnabled) {
            return null;
        }
        Map idCache = IDCache.getIdCache(doc, true);
        Element elem = (Element)idCache.get(id);
        if (elem != null && IDCache.verifyCachedElement(doc, elem, id)) {
            return elem;
        }
        idCache.clear();
        IDCache.populateIdCache(doc.getDocumentElement(), idCache);
        return (Element)idCache.get(id);
    }

    public static void addToIDCache(Element elem) {
        if (!IDCache.isIDCacheEnabled(elem.getOwnerDocument())) {
            return;
        }
        Map idCache = IDCache.getIdCache(elem.getOwnerDocument(), false);
        if (idCache != null) {
            IDCache.populateIdCache(elem, idCache);
        }
    }

    public static void addToIDCache(Element elem, String id) {
        if (!IDCache.isIDCacheEnabled(elem.getOwnerDocument())) {
            return;
        }
        Map idCache = IDCache.getIdCache(elem.getOwnerDocument(), false);
        if (idCache != null) {
            idCache.put(id, elem);
        }
    }

    private static boolean verifyCachedElement(Document doc, Element elem, String id) {
        Node parent;
        if (elem.getOwnerDocument() != doc) {
            return false;
        }
        for (parent = elem.getParentNode(); parent != doc && parent != null; parent = parent.getParentNode()) {
        }
        if (parent == null) {
            return false;
        }
        return id.equals(IDCache.getID(elem));
    }
}

