/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;

public class Base64 {
    private boolean useLineBreaks;
    private static final String LF_ENCODING_SEPARATOR = "\n";
    private static final char[] base64chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] base64Vals = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    public Base64() {
        this(true);
    }

    public Base64(boolean useLineBreaks) {
        this.useLineBreaks = useLineBreaks;
    }

    public static String toBase64(byte[] data, boolean useLineBreaks) {
        String lineSeparator;
        String string = lineSeparator = useLineBreaks ? System.getProperty("line.separator") : "";
        if (lineSeparator == null) {
            lineSeparator = "";
        }
        return Base64.toBase64(data, lineSeparator);
    }

    public static String toBase64WithLFSeparator(byte[] data) {
        boolean useLineBreaks = true;
        if (null != System.getProperty("osdt.useLineBreaks")) {
            useLineBreaks = Boolean.parseBoolean(System.getProperty("osdt.useLineBreaks"));
        }
        if (useLineBreaks) {
            return Base64.toBase64(data, LF_ENCODING_SEPARATOR);
        }
        return Base64.toBase64(data, useLineBreaks);
    }

    private static String toBase64(byte[] data, String lineSeparator) {
        boolean useLineBreaks = !lineSeparator.isEmpty();
        int lineLength = 64;
        int outputLength = (data.length + 2) / 3 * 4;
        outputLength += (outputLength - 1) / lineLength * lineSeparator.length();
        char[] cbuf = new char[outputLength];
        int p = 0;
        int size = data.length;
        block13: for (int i = 0; i < size; i += 3) {
            if (i != 0 && i % 48 == 0 && useLineBreaks) {
                for (int j = 0; j < lineSeparator.length(); ++j) {
                    cbuf[p++] = lineSeparator.charAt(j);
                }
            }
            int rem = Math.min(data.length - i, 3);
            cbuf[p++] = Base64.toBase64((data[i] & 0xFC) >> 2);
            switch (rem) {
                case 2: 
                case 3: {
                    cbuf[p++] = Base64.toBase64(((data[i] & 3) << 4) + ((data[i + 1] & 0xF0) >> 4));
                    break;
                }
                case 1: {
                    cbuf[p++] = Base64.toBase64((data[i] & 3) << 4);
                }
            }
            switch (rem) {
                case 3: {
                    cbuf[p++] = Base64.toBase64(((data[i + 1] & 0xF) << 2) + ((data[i + 2] & 0xC0) >> 6));
                    break;
                }
                case 2: {
                    cbuf[p++] = Base64.toBase64((data[i + 1] & 0xF) << 2);
                    break;
                }
                case 1: {
                    cbuf[p++] = 61;
                }
            }
            switch (rem) {
                case 3: {
                    cbuf[p++] = Base64.toBase64(data[i + 2] & 0x3F);
                    continue block13;
                }
                case 1: 
                case 2: {
                    cbuf[p++] = 61;
                }
            }
        }
        return new String(cbuf, 0, p);
    }

    public static byte[] fromBase64(String s) {
        int outputLength = s.length() / 4 * 3;
        UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream(outputLength);
        char[] input = s.toCharArray();
        char[] buffer = new char[4];
        int offset = 0;
        while ((offset = Base64.fillBuffer(input, offset, input.length - offset, buffer)) != -1 && buffer[0] != '*') {
            int rem = buffer[2] == '=' ? 1 : (buffer[3] == '=' ? 2 : 3);
            int dech0 = Base64.fromBase64(buffer[0]);
            int dech1 = Base64.fromBase64(buffer[1]);
            int dech2 = 0;
            int dech3 = 0;
            switch (rem) {
                case 3: {
                    dech3 = Base64.fromBase64(buffer[3]);
                }
                case 2: {
                    dech2 = Base64.fromBase64(buffer[2]);
                }
            }
            try {
                bos.write((dech0 << 2) + ((dech1 & 0x30) >> 4));
                if (rem != 1) {
                    bos.write(((dech1 & 0xF) << 4) + ((dech2 & 0x3C) >> 2));
                }
                if (rem != 3) continue;
                bos.write(((dech2 & 3) << 6) + dech3);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.toString());
            }
        }
        return bos.toByteArray();
    }

    public void setUseLineBreaks(boolean useLineBreaks) {
        this.useLineBreaks = useLineBreaks;
    }

    public boolean getUseLineBreaks() {
        return this.useLineBreaks;
    }

    public String encode(byte[] data) {
        return Base64.toBase64(data, this.useLineBreaks);
    }

    public byte[] decode(String s) {
        return Base64.fromBase64(s);
    }

    private static final char toBase64(int x) {
        if (x < 26) {
            return (char)(65 + x);
        }
        if (x < 52) {
            return (char)(97 + x - 26);
        }
        if (x < 62) {
            return (char)(48 + x - 52);
        }
        if (x == 62) {
            return '+';
        }
        if (x == 63) {
            return '/';
        }
        throw new IllegalArgumentException();
    }

    private static final int fromBase64(char ch) {
        if (ch >= 'A' && ch <= 'Z') {
            return ch - 65;
        }
        if (ch >= 'a' && ch <= 'z') {
            return ch - 97 + 26;
        }
        if (ch >= '0' && ch <= '9') {
            return ch - 48 + 52;
        }
        if (ch == '+') {
            return 62;
        }
        if (ch == '/') {
            return 63;
        }
        throw new IllegalArgumentException();
    }

    private static final int fillBuffer(char[] s, int offset, int length, char[] buffer) {
        if (length == 0) {
            return -1;
        }
        buffer[3] = 42;
        buffer[2] = 42;
        buffer[1] = 42;
        buffer[0] = 42;
        int i = 0;
        int n = offset + length;
        while (offset < n && i < 4) {
            char c;
            if ((c = s[offset++]) == '\r' || c == '\n' || c == ' ' || c == '\t' || c == '\f' || c == '\u000b') continue;
            buffer[i++] = c;
        }
        return offset;
    }

    public static class EncodeOutputStream
    extends OutputStream {
        final Writer wr;
        final byte[] input = new byte[1026];
        int inputLength = 0;
        final char[] output = new char[(this.input.length + 2) / 3 * 4];
        int outputLength = 0;

        public EncodeOutputStream(Writer wr) {
            this.wr = wr;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return;
            }
            while (len > 0) {
                int toCopy = Math.min(this.input.length - this.inputLength, len);
                System.arraycopy(b, off, this.input, this.inputLength, toCopy);
                len -= toCopy;
                off += toCopy;
                this.inputLength += toCopy;
                if (this.input.length != this.inputLength) continue;
                this.convertBuffer();
                this.inputLength = 0;
            }
        }

        @Override
        public void close() throws IOException {
            this.convertBuffer();
        }

        private void convertBuffer() throws IOException {
            int i;
            int pad = 3 - this.inputLength % 3;
            if (pad == 3) {
                pad = 0;
            }
            for (int i2 = 0; i2 < pad; ++i2) {
                this.input[this.inputLength + i2] = 0;
            }
            int j = 0;
            for (i = 0; i < this.inputLength; i += 3) {
                this.output[j++] = base64chars[(this.input[i] & 0xFC) >> 2];
                this.output[j++] = base64chars[((this.input[i] & 3) << 4) + ((this.input[i + 1] & 0xF0) >> 4)];
                this.output[j++] = base64chars[((this.input[i + 1] & 0xF) << 2) + ((this.input[i + 2] & 0xC0) >> 6)];
                this.output[j++] = base64chars[this.input[i + 2] & 0x3F];
            }
            this.outputLength = j;
            for (i = 0; i < pad; ++i) {
                this.output[this.outputLength - i - 1] = 61;
            }
            this.wr.write(this.output, 0, this.outputLength);
        }

        @Override
        public void write(int b) throws IOException {
            byte[] bt = new byte[1];
            this.write(bt, 0, 1);
        }
    }

    public static class DecodeInputStream
    extends InputStream {
        final char[] buffer = new char[4];
        final Reader rw;
        final char[] input = new char[1368];
        int inputLength;
        final byte[] output = new byte[1026];
        int outputLength;
        int outputPos;
        boolean eof = false;
        boolean rwEof = false;

        public DecodeInputStream(Reader rw) {
            this.rw = rw;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b, 0, 1);
            return n == -1 ? -1 : b[0];
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            int n = 0;
            while (len > 0) {
                int toCopy = Math.min(len, this.outputLength - this.outputPos);
                System.arraycopy(this.output, this.outputPos, b, off, toCopy);
                len -= toCopy;
                off += toCopy;
                this.outputPos += toCopy;
                n += toCopy;
                if (this.outputPos == this.outputLength) {
                    this.outputPos = 0;
                    this.outputLength = 0;
                }
                if (len == 0 || this.rwEof) break;
                int n1 = this.rw.read(this.input, this.inputLength, this.input.length - this.inputLength);
                if (n1 == -1) {
                    if (this.inputLength != 0) {
                        throw new IllegalArgumentException("Trailing characters size =" + this.inputLength);
                    }
                    this.rwEof = true;
                    this.eof = true;
                    continue;
                }
                this.inputLength += n1;
                this.convertBuffer();
            }
            if (this.rwEof && n == 0) {
                n = -1;
            }
            return n;
        }

        private void convertBuffer() {
            int j;
            int old_i;
            int i = 0;
            while (true) {
                old_i = i;
                j = 0;
                block1: while (j < 4 && i < this.inputLength) {
                    while (i < this.inputLength) {
                        char c;
                        if ((c = this.input[i++]) == '\r' || c == '\n' || c == ' ' || c == '\t' || c == '\f' || c == '\u000b') continue;
                        this.buffer[j++] = c;
                        continue block1;
                    }
                }
                if (j != 4) break;
                int rem = 0;
                if (this.buffer[3] == '=') {
                    this.buffer[3] = 65;
                    rem = 1;
                    if (this.buffer[2] == '=') {
                        this.buffer[2] = 65;
                        rem = 2;
                    }
                    this.eof = true;
                }
                int dech0 = base64Vals[this.buffer[0]];
                int dech1 = base64Vals[this.buffer[1]];
                int dech2 = base64Vals[this.buffer[2]];
                int dech3 = base64Vals[this.buffer[3]];
                if (dech0 == -1 || dech1 == -1 || dech2 == -1 || dech3 == -1) {
                    throw new IllegalArgumentException("Illegal characters for base64 encoding" + this.buffer);
                }
                this.output[this.outputLength++] = (byte)((dech0 << 2) + ((dech1 & 0x30) >> 4));
                this.output[this.outputLength++] = (byte)(((dech1 & 0xF) << 4) + ((dech2 & 0x3C) >> 2));
                this.output[this.outputLength++] = (byte)(((dech2 & 3) << 6) + dech3);
                this.outputLength -= rem;
            }
            if (j == 0) {
                this.inputLength = 0;
            } else {
                System.arraycopy(this.input, old_i, this.input, 0, this.inputLength - old_i);
                this.inputLength -= old_i;
            }
        }
    }
}

