/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.transform;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.security.xmlsec.c14n.XMLC14N;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XSLTTransform
extends XSTransformer {
    private Node param;

    public XSLTTransform(XSAlgorithmIdentifier trans) {
        super(trans);
        if (!"http://www.w3.org/TR/1999/REC-xslt-19991116".equals(trans.getAlgorithm())) {
            throw new IllegalArgumentException("XSLT Transform required");
        }
        NodeList pList = trans.getParameters();
        if (pList.getLength() != 1) {
            throw new IllegalArgumentException("Illegal Transform parameter");
        }
        this.param = pList.item(0);
    }

    public byte[] applyXSLT(InputStream source) throws TransformerException {
        StreamSource styleSheet = new StreamSource(new ByteArrayInputStream(XMLUtils.toBytesXML(this.param, false, false)));
        Transformer t = XMLUtils.createTransformer(styleSheet);
        StreamSource src = new StreamSource(source);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult res = new StreamResult(bos);
        t.transform(src, res);
        return bos.toByteArray();
    }

    @Override
    public String getAlgorithmURI() {
        return "http://www.w3.org/TR/1999/REC-xslt-19991116";
    }

    @Override
    public XMLContainer transform(XMLContainer source) throws TransformationException {
        try {
            InputStream src = source.getOctetStream();
            if (src == null) {
                XMLC14N can = new XMLC14N();
                src = source.subTreeAvailable() ? new ByteArrayInputStream(can.canonicalize(source.getSubTree())) : (source.nodeSetAvailable() ? new ByteArrayInputStream(can.canonicalize(source.getNodeSet())) : new ByteArrayInputStream(new byte[0]));
            }
            byte[] res = this.applyXSLT(src);
            return new XMLContainer(res);
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
        catch (SAXException ex) {
            throw new TransformationException(ex);
        }
        catch (XPathException ex) {
            throw new TransformationException(ex);
        }
        catch (TransformerException ex) {
            throw new TransformationException(ex);
        }
    }
}

