/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Set;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.NodeToStreamTransform;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.NodeReader;
import oracle.security.xmlsec.util.NodeReaderException;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Base64Decoder
extends XSTransformer
implements NodeToStreamTransform {
    public Base64Decoder() {
    }

    public Base64Decoder(XSAlgorithmIdentifier trans) {
        super(trans);
        if (!"http://www.w3.org/2000/09/xmldsig#base64".equals(trans.getAlgorithm())) {
            throw new IllegalArgumentException("Base64 decode Transform required");
        }
        if (trans.getParameters().getLength() != 0) {
            throw new IllegalArgumentException("Illegal Transform parameter");
        }
    }

    @Override
    public String getAlgorithmURI() {
        return "http://www.w3.org/2000/09/xmldsig#base64";
    }

    @Override
    public XMLContainer transform(XMLContainer source) throws TransformationException {
        String b64Str = null;
        try {
            if (source.subTreeAvailable() || source.nodeSetAvailable()) {
                Set nodeSet = source.getNodeSet();
                if (nodeSet != null) {
                    StringBuffer textVal = new StringBuffer();
                    for (Node node : XMLUtils.toDocumentOrderList(nodeSet)) {
                        if (node.getNodeType() != 3) continue;
                        textVal.append(((Text)node).getData());
                    }
                    b64Str = textVal.toString();
                }
            } else {
                b64Str = new String(source.toByteArray());
            }
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
        catch (SAXException ex) {
            throw new TransformationException(ex);
        }
        catch (XPathException ex) {
            throw new TransformationException(ex);
        }
        byte[] result = null;
        if (b64Str != null) {
            result = Base64.fromBase64(b64Str);
        }
        if (result == null) {
            result = new byte[]{};
        }
        try {
            return new XMLContainer(result);
        }
        catch (IOException ex) {
            throw new TransformationException(ex);
        }
    }

    @Override
    public InputStream transformToStream(NodeReader source) throws IOException, TransformationException {
        final NodeReader nr = source;
        Reader rw = new Reader(){
            char[] txt = null;
            int txtOff;
            int txtLen;

            private void gotoNextTxtNode() throws IOException {
                int eventType;
                do {
                    try {
                        eventType = nr.next();
                    }
                    catch (NodeReaderException ex) {
                        throw new IOException(ex);
                    }
                } while (eventType != -1 && eventType != 4);
                if (eventType == -1) {
                    this.txt = null;
                    this.txtLen = 0;
                    this.txtOff = 0;
                } else {
                    this.txt = nr.getText();
                    this.txtLen = nr.getTextLength();
                    this.txtOff = nr.getTextStart();
                }
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public int read(char[] cbuf, int cbufOff, int cbufLen) throws IOException {
                int eventType = nr.getEventType();
                if (eventType == -1 && this.txtLen == 0) {
                    return -1;
                }
                int n = 0;
                while (cbufLen > 0) {
                    if (this.txt == null || this.txtLen == 0) {
                        this.gotoNextTxtNode();
                        if (this.txt == null) {
                            return n > 0 ? n : -1;
                        }
                    }
                    int n1 = Math.min(this.txtLen, cbufLen);
                    System.arraycopy(this.txt, this.txtOff, cbuf, cbufOff, n1);
                    this.txtOff += n1;
                    this.txtLen -= n1;
                    cbufOff += n1;
                    cbufLen -= n1;
                    n += n1;
                }
                return n;
            }
        };
        return new Base64.DecodeInputStream(rw);
    }
}

