/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.soap.v12;

import java.util.List;
import oracle.security.xmlsec.soap.v12.SOAPFaultCode;
import oracle.security.xmlsec.util.SOAPInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SOAPFault
extends XMLElement {
    private static final String[] nsURIs = new String[]{"http://www.w3.org/2003/05/soap-envelope", "http://www.w3.org/2003/05/soap-envelope", "http://www.w3.org/2003/05/soap-envelope", "http://www.w3.org/2003/05/soap-envelope", "http://www.w3.org/2003/05/soap-envelope"};
    private static final String[] localNames = new String[]{"Code", "Reason", "Node", "Role", "Detail"};

    public SOAPFault(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2003/05/soap-envelope", "Fault");
    }

    public SOAPFault(Element soapFault) throws DOMException {
        super(soapFault);
    }

    public SOAPFault(Element soapFault, String systemId) throws DOMException {
        super(soapFault, systemId);
    }

    public void setCode(SOAPFaultCode faultCode) throws DOMException {
        XMLUtils.removeChildren((Element)this.node, "http://www.w3.org/2003/05/soap-envelope", "Code");
        XMLUtils.insertChild(this, faultCode, nsURIs, localNames);
    }

    public SOAPFaultCode getCode() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Code");
        if (nodes.getLength() != 0) {
            return new SOAPFaultCode((Element)nodes.item(0), this.getSystemId());
        }
        return null;
    }

    public void addReasonText(String reasonText, String reasonLang) throws DOMException {
        Document doc = this.getOwnerDocument();
        Element reason = null;
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Reason");
        if (nodes.getLength() != 0) {
            reason = (Element)nodes.item(0);
        } else {
            reason = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Reason");
            XMLUtils.copyNSPrefix((Element)this.node, reason);
            XMLUtils.insertChild((Element)this.node, reason, nsURIs, localNames);
        }
        Element text = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Text");
        XMLUtils.copyNSPrefix(reason, text);
        reason.appendChild(text);
        text.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", reasonLang);
        text.appendChild(doc.createTextNode(reasonText));
    }

    public void setReason(List reasonText, List reasonLang) throws DOMException {
        Document doc = this.getOwnerDocument();
        XMLUtils.removeChildren((Element)this.node, "http://www.w3.org/2003/05/soap-envelope", "Reason");
        Element reason = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Reason");
        XMLUtils.copyNSPrefix((Element)this.node, reason);
        XMLUtils.insertChild((Element)this.node, reason, nsURIs, localNames);
        int len = reasonText.size();
        for (int i = 0; i < len; ++i) {
            Element text = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Text");
            XMLUtils.copyNSPrefix(reason, text);
            reason.appendChild(text);
            reason.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", (String)reasonLang.get(i));
            text.appendChild(doc.createTextNode((String)reasonText.get(i)));
        }
    }

    public NodeList getReasonTexts() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Reason");
        if (nodes.getLength() != 0) {
            Element reason = (Element)nodes.item(0);
            return XMLElement.getChildElementsByTagNameNS(reason, "http://www.w3.org/2003/05/soap-envelope", "Text");
        }
        return nodes;
    }

    public void setFaultNode(String nodeURI) throws DOMException {
        Document doc = this.getOwnerDocument();
        XMLUtils.removeChildren((Element)this.node, "http://www.w3.org/2003/05/soap-envelope", "Node");
        Element faultNode = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Node");
        XMLUtils.copyNSPrefix((Element)this.node, faultNode);
        XMLUtils.insertChild((Element)this.node, faultNode, nsURIs, localNames);
        faultNode.appendChild(doc.createTextNode(nodeURI));
    }

    public String getFaultNode() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Node");
        if (nodes.getLength() != 0) {
            return XMLUtils.collectText(nodes.item(0));
        }
        return null;
    }

    public void setRole(String roleURI) throws DOMException {
        Document doc = this.getOwnerDocument();
        XMLUtils.removeChildren((Element)this.node, "http://www.w3.org/2003/05/soap-envelope", "Role");
        Element role = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Role");
        XMLUtils.copyNSPrefix((Element)this.node, role);
        XMLUtils.insertChild((Element)this.node, role, nsURIs, localNames);
        role.appendChild(doc.createTextNode(roleURI));
    }

    public String getRole() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Role");
        if (nodes.getLength() != 0) {
            return XMLUtils.collectText(nodes.item(0));
        }
        return null;
    }

    public void addDetailEntry(Element detailEntry) throws DOMException {
        Document doc = this.getOwnerDocument();
        Element detail = null;
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Detail");
        if (nodes.getLength() != 0) {
            detail = (Element)nodes.item(0);
        } else {
            detail = doc.createElementNS("http://www.w3.org/2003/05/soap-envelope", "Detail");
            XMLUtils.copyNSPrefix((Element)this.node, detail);
            XMLUtils.insertChild((Element)this.node, detail, nsURIs, localNames);
        }
        detail.appendChild(detailEntry);
    }

    public Element getDetail() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Detail");
        if (nodes.getLength() != 0) {
            return (Element)nodes.item(0);
        }
        return null;
    }

    public NodeList getDetailEntries() {
        NodeList nodes = this.getChildElementsByTagNameNS("http://www.w3.org/2003/05/soap-envelope", "Detail");
        if (nodes.getLength() != 0) {
            Element detail = (Element)nodes.item(0);
            return XMLElement.getChildElementsByTagName(detail, "*");
        }
        return nodes;
    }

    static {
        SOAPInitializer.initialize();
    }
}

