/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys.retrieval;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.ext.SubjectAltNameExtension;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.KeyName;
import oracle.security.xmlsec.keys.X509Data;
import oracle.security.xmlsec.keys.retrieval.KeyRetrievalException;
import oracle.security.xmlsec.keys.retrieval.KeyRetriever;
import oracle.security.xmlsec.keys.retrieval.StorageAuthenticationException;
import oracle.security.xmlsec.keys.retrieval.StorageAuthenticator;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLUtils;

public class PKCS8KeyRetriever
extends KeyRetriever {
    private PrivateKeyPKCS8 pkcs8;
    private String keyName;

    public PKCS8KeyRetriever(InputStream p8Stream, String keyName) throws IOException {
        this(new PrivateKeyPKCS8(p8Stream), keyName);
    }

    public PKCS8KeyRetriever(PrivateKeyPKCS8 pkcs8, String keyName) throws IOException {
        this.pkcs8 = pkcs8;
        this.keyName = keyName;
    }

    @Override
    public java.security.PrivateKey retrievePrivateKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        this.doPasswordAuth();
        boolean matched = false;
        Object cert = null;
        String type = keyInfo.getType();
        if ("http://www.w3.org/2000/09/xmldsig-more#KeyName".equals(type)) {
            String name = ((KeyName)keyInfo).getName();
            if (name != null && name.equals(this.keyName)) {
                matched = true;
            }
        } else if ("http://www.w3.org/2000/09/xmldsig#X509Data".equals(type) && this.matchX509Data((X509Data)keyInfo)) {
            matched = true;
        }
        if (matched) {
            try {
                return CryptoUtils.toJCEPrivateKey((PrivateKey)this.pkcs8.getKey());
            }
            catch (IllegalStateException ex) {
                throw new StorageAuthenticationException(ex);
            }
        }
        return null;
    }

    private void doPasswordAuth() throws StorageAuthenticationException {
        try {
            this.pkcs8.getKey();
        }
        catch (IllegalStateException ex) {
            StorageAuthenticator auth = this.getAuthenticator();
            auth.getCredential();
            this.pkcs8.setPassword(auth.getPassword());
        }
    }

    private boolean matchX509Data(X509Data data) throws KeyRetrievalException {
        int k;
        Vector names = data.getSubjectNames();
        Vector isnos = data.getIssuerSerials();
        Vector skids = data.getSubjectKeyIDs();
        Vector certs = null;
        try {
            certs = data.getCertificates();
        }
        catch (IOException ex) {
            throw new KeyRetrievalException(ex);
        }
        int z = skids.size();
        for (k = 0; k < z; ++k) {
            byte[] skid = (byte[])skids.elementAt(k);
            if (skid == null || !Base64.toBase64(skid, false).equals(XMLUtils.stripWS(this.keyName))) continue;
            return true;
        }
        z = names.size();
        for (k = 0; k < z; ++k) {
            X500Principal name = (X500Principal)names.elementAt(k);
            if (name == null || !name.equals(this.keyName)) continue;
            return true;
        }
        z = certs.size();
        for (k = 0; k < z; ++k) {
            X509Certificate cert = (X509Certificate)certs.elementAt(k);
            byte[] skid = XMLUtils.getSKI(cert);
            if (skid != null && Base64.toBase64(skid, false).equals(XMLUtils.stripWS(this.keyName))) {
                return true;
            }
            X500Name subject = null;
            try {
                subject = new X500Name((InputStream)new UnsyncByteArrayInputStream(cert.getSubjectX500Principal().getEncoded()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (subject.toString().equals(this.keyName)) {
                return true;
            }
            ASN1Object cn = subject.getAttributeValue(PKIX.id_at_commonName);
            if (cn != null && cn instanceof ASN1String && ((ASN1String)cn).getValue().equals(this.keyName)) {
                return true;
            }
            ASN1Object email = subject.getAttributeValue(PKIX.emailAddress);
            if (email != null && email instanceof ASN1String && ((ASN1String)email).getValue().equals(this.keyName)) {
                return true;
            }
            SubjectAltNameExtension subjAlt = null;
            try {
                subjAlt = new SubjectAltNameExtension((InputStream)new UnsyncByteArrayInputStream(cert.getExtensionValue(PKIX.id_ce_subjectAltName.toString())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (subjAlt == null) continue;
            Enumeration e = subjAlt.subjectAltName();
            while (e.hasMoreElements()) {
                ASN1Object em;
                GeneralName gn = (GeneralName)e.nextElement();
                if (!GeneralName.Type.RFC822_NAME.equals(gn.getType()) || (em = gn.getValue()) == null || !(em instanceof ASN1String) || !((ASN1String)em).getValue().equals(this.keyName)) continue;
                return true;
            }
        }
        return false;
    }
}

