/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys.retrieval;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.X509Data;
import oracle.security.xmlsec.keys.retrieval.KeyRetrievalException;
import oracle.security.xmlsec.keys.retrieval.KeyRetriever;

public class KeyStoreKeyRetriever
extends KeyRetriever {
    private KeyStore ks;
    private char[] keyPassword;

    public KeyStoreKeyRetriever(KeyStore ks, char[] keyPassword) {
        this.ks = ks;
        this.keyPassword = keyPassword;
    }

    @Override
    protected X509Certificate retrieveCertificate(KeyInfoData keyInfo) throws KeyRetrievalException {
        try {
            if ("http://www.w3.org/2000/09/xmldsig#X509Data".equals(keyInfo.getType())) {
                X509Data data = (X509Data)keyInfo;
                Enumeration<String> aliases = this.ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)this.ks.getCertificate(alias);
                    if (!data.matches(cert)) continue;
                    return cert;
                }
            }
        }
        catch (KeyStoreException ex) {
            throw new KeyRetrievalException(ex);
        }
        return null;
    }

    @Override
    protected PrivateKey retrievePrivateKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        try {
            if ("http://www.w3.org/2000/09/xmldsig#X509Data".equals(keyInfo.getType())) {
                X509Data data = (X509Data)keyInfo;
                Enumeration<String> aliases = this.ks.aliases();
                while (aliases.hasMoreElements()) {
                    X509Certificate cert;
                    String alias = aliases.nextElement();
                    if (!this.ks.isKeyEntry(alias) || !data.matches(cert = (X509Certificate)this.ks.getCertificate(alias))) continue;
                    return (PrivateKey)this.ks.getKey(alias, this.keyPassword);
                }
            }
        }
        catch (KeyStoreException ex) {
            throw new KeyRetrievalException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new KeyRetrievalException(ex);
        }
        catch (UnrecoverableKeyException ex) {
            throw new KeyRetrievalException(ex);
        }
        return null;
    }

    @Override
    protected PublicKey retrievePublicKey(KeyInfoData keyInfo) throws KeyRetrievalException {
        X509Certificate cert = this.retrieveCertificate(keyInfo);
        return cert != null ? cert.getPublicKey() : null;
    }
}

