/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.security.xmlsec.dsig.ObjectReference;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.KeyUtils;
import oracle.security.xmlsec.keys.RawX509Cert;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RetrievalMethod
extends ObjectReference
implements KeyInfoData {
    public RetrievalMethod(Element element) throws DOMException {
        super(element);
    }

    public RetrievalMethod(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    RetrievalMethod(Document owner) throws DOMException {
        super(owner, "RetrievalMethod");
    }

    RetrievalMethod(Document owner, String uri, String type) throws DOMException {
        super(owner, "RetrievalMethod", uri);
        if (type != null) {
            this.setObjectType(type);
        }
    }

    public void setObjectType(String type) throws DOMException {
        this.setAttribute("Type", type);
    }

    public String getObjectType() {
        if (this.hasAttribute("Type")) {
            return this.getAttribute("Type");
        }
        return null;
    }

    public KeyInfoData getKeyInfoData() throws ReferenceException {
        String uri = this.getURI();
        if (uri == null) {
            return null;
        }
        XMLContainer result = (XMLContainer)this.dereference();
        String typeURI = this.getObjectType();
        if (!"http://www.w3.org/2000/09/xmldsig#rawX509Certificate".equals(typeURI)) {
            Node kiNode = null;
            if (result.subTreeAvailable() || result.octetsAvailable()) {
                block19: {
                    try {
                        kiNode = result.getSubTree();
                    }
                    catch (IOException ex) {
                        throw new ReferenceException(ex);
                    }
                    catch (SAXException ex) {
                        if (typeURI == null) break block19;
                        throw new ReferenceException(ex);
                    }
                }
                if (kiNode != null && kiNode.getNodeType() == 9) {
                    kiNode = ((Document)kiNode).getDocumentElement();
                }
            } else if (result.nodeSetAvailable()) {
                Set nodeSet = null;
                try {
                    nodeSet = result.getNodeSet();
                }
                catch (IOException ex) {
                    throw new ReferenceException(ex);
                }
                catch (SAXException ex) {
                    throw new ReferenceException(ex);
                }
                catch (XPathException ex) {
                    throw new ReferenceException(ex);
                }
                if (nodeSet != null) {
                    List list = XMLUtils.toDocumentOrderList(nodeSet);
                    Iterator it = list.iterator();
                    while (kiNode == null && it.hasNext()) {
                        Node node = (Node)it.next();
                        if (node.getNodeType() != 1) continue;
                        kiNode = node;
                    }
                }
            }
            if (kiNode != null) {
                return KeyUtils.createKeyInfoData((Element)kiNode, uri.length() == 0 || uri.startsWith("#") ? this.systemId : uri);
            }
        }
        if (result.octetsAvailable() || result.getSystemId() != null) {
            try {
                return new RawX509Cert(result.toByteArray());
            }
            catch (IOException ex) {
                throw new ReferenceException(ex);
            }
        }
        throw new ReferenceException("Bad or missing KeyInfo data");
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2000/09/xmldsig-more#RetrievalMethod";
    }
}

