/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.security.PublicKey;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.keys.KeyUtils;
import oracle.security.xmlsec.keys.KeyValueData;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyValue
extends XMLElement
implements KeyInfoData {
    public KeyValue(Element element) throws DOMException {
        super(element);
    }

    public KeyValue(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public KeyValue(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", "KeyValue");
    }

    public KeyValue(Document owner, XMLElement keyValueData) throws DOMException {
        this(owner);
        this.setKeyValueData(keyValueData);
    }

    public void setKeyValueData(XMLElement keyValueData) throws DOMException {
        NodeList nList = this.getChildElementsByTagName("*");
        for (int i = nList.getLength(); i > 0; --i) {
            this.removeChild(nList.item(i - 1));
        }
        this.appendChild(keyValueData);
    }

    public KeyValueData getKeyValueData() {
        NodeList nList = this.getChildElementsByTagName("*");
        if (nList.getLength() != 0) {
            return KeyUtils.createKeyValueData((Element)nList.item(0), this.systemId);
        }
        return null;
    }

    public PublicKey getPublicKey() {
        return this.getKeyValueData().getPublicKey();
    }

    @Override
    public String getType() {
        return this.getKeyValueData().getType();
    }
}

