/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyName
extends XMLElement
implements KeyInfoData {
    public KeyName(Element element) throws DOMException {
        super(element);
    }

    public KeyName(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    KeyName(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", "KeyName");
    }

    KeyName(Document owner, String name) throws DOMException {
        this(owner);
        this.setName(name);
    }

    public void setName(String name) throws DOMException {
        NodeList knList = this.getChildNodes();
        for (int i = knList.getLength(); i > 0; --i) {
            this.removeChild(knList.item(i - 1));
        }
        this.appendChild(this.getOwnerDocument().createTextNode(name));
    }

    public String getName() {
        String knString = XMLUtils.collectText(this.getNode());
        if (knString.length() != 0) {
            return knString;
        }
        return null;
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2000/09/xmldsig-more#KeyName";
    }
}

