/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.keys;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.enc.OriginatorKeyInfo;
import oracle.security.xmlsec.enc.XECipherException;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XESchemaException;
import oracle.security.xmlsec.keys.AgreementMethod;
import oracle.security.xmlsec.keys.DHKeyValue;
import oracle.security.xmlsec.keys.KeyValue;
import oracle.security.xmlsec.util.URIManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DHAgreementMethod
extends AgreementMethod {
    public DHAgreementMethod(Element element) throws DOMException {
        super(element);
    }

    public DHAgreementMethod(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public DHAgreementMethod(Document doc) throws DOMException {
        super(doc, "http://www.w3.org/2001/04/xmlenc#dh");
    }

    @Override
    public void setAlgorithm(String algURI) {
        if (!algURI.equals("http://www.w3.org/2001/04/xmlenc#dh")) {
            throw new IllegalArgumentException("Unknown Diffie-Hellman key agreement algorithm: " + algURI);
        }
        this.setAttribute("Algorithm", "http://www.w3.org/2001/04/xmlenc#dh");
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2001/04/xmlenc#dh";
    }

    @Override
    public byte[] generateKeyMaterial(XEEncryptionMethod encMtd, PrivateKey loKey, PublicKey opKey) throws XESchemaException, XECipherException {
        byte[] ZZ = null;
        try {
            KeyAgreement ka = KeyAgreement.getInstance("DiffieHellman");
            ka.init(loKey);
            ka.doPhase(opKey, true);
            byte[] t = ka.generateSecret();
            if (t[0] == 0) {
                ZZ = new byte[t.length - 1];
                System.arraycopy(t, 1, ZZ, 0, ZZ.length);
            } else {
                ZZ = t;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            IllegalArgumentException ex1 = new IllegalArgumentException("JCE provider doesn't support DH");
            ex1.initCause(ex);
            throw ex1;
        }
        catch (InvalidKeyException ex) {
            IllegalArgumentException ex1 = new IllegalArgumentException("Key is not a DiffieHellman key");
            ex1.initCause(ex);
            throw ex1;
        }
        int keySize = encMtd.keySize();
        XSAlgorithmIdentifier dAlgID = this.getDigestMethod();
        String digestMethod = null;
        if (dAlgID == null) {
            throw new XESchemaException("DigestMethod is not specified in this AgreementMethod element");
        }
        digestMethod = dAlgID.getAlgorithm();
        int keyLen = keySize / 8;
        byte[] km = new byte[keyLen];
        int counter = 1;
        String algURI = encMtd.getAlgorithm();
        byte[] nonce = this.getKANonce();
        try {
            MessageDigest md = MessageDigest.getInstance(URIManager.getURIManager().getJCEAlgorithm(digestMethod));
            int mdLen = md.getDigestLength();
            int i = 0;
            while (i < keyLen) {
                md.update(ZZ);
                md.update(Utils.toUTF8((String)Utils.toHexString((byte[])new byte[]{(byte)counter}).toUpperCase()));
                md.update(algURI.getBytes());
                if (nonce != null) {
                    md.update(nonce);
                }
                md.update(Utils.toUTF8((String)Integer.toString(keySize)));
                int tmLen = i < keyLen - mdLen ? mdLen : keyLen - i;
                System.arraycopy(md.digest(), 0, km, i, tmLen);
                i += mdLen;
                ++counter;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XECipherException(ex);
        }
        return km;
    }

    @Override
    public KeyPair setToDefaultParameters(KeyPair originatorKeyPair, PublicKey recipientKey, String keyDerivationAlgURI) throws XECipherException {
        if (originatorKeyPair == null) {
            try {
                KeyPairGenerator keygen = KeyPairGenerator.getInstance("DiffieHellman");
                keygen.initialize(((DHPublicKey)recipientKey).getParams());
                originatorKeyPair = keygen.generateKeyPair();
            }
            catch (NoSuchAlgorithmException ex) {
                throw new XECipherException(ex);
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new XECipherException(ex);
            }
        }
        this.setDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
        SecureRandom sr = new SecureRandom();
        byte[] nonce = new byte[16];
        sr.nextBytes(nonce);
        this.setKANonce(nonce);
        DHKeyValue kval = new DHKeyValue(this.getOwnerDocument(), (DHPublicKey)originatorKeyPair.getPublic());
        OriginatorKeyInfo kinfo = new OriginatorKeyInfo(this.getOwnerDocument());
        kinfo.addKeyInfoData(new KeyValue(this.getOwnerDocument(), kval));
        this.setOriginatorKeyInfo(kinfo);
        return originatorKeyPair;
    }
}

