/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.dsig;

import java.util.Vector;
import oracle.security.xmlsec.dsig.Referable;
import oracle.security.xmlsec.dsig.XSSigProperty;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XSSigProperties
extends XMLElement
implements Referable {
    public XSSigProperties(Element element) throws DOMException {
        super(element);
    }

    public XSSigProperties(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public XSSigProperties(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2000/09/xmldsig#", "SignatureProperties");
    }

    public XSSigProperties(Document owner, String id) throws DOMException {
        this(owner);
        if (id != null) {
            this.setId(id);
        }
    }

    public void addSigProperty(XSSigProperty sigProp) throws DOMException {
        this.appendChild(sigProp);
    }

    public Vector getSigProperties() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureProperty");
        Vector<XSSigProperty> list = new Vector<XSSigProperty>(nList.getLength());
        int n = nList.getLength();
        for (int i = 0; i < n; ++i) {
            list.addElement(new XSSigProperty((Element)nList.item(i), this.systemId));
        }
        return list;
    }

    @Override
    public void setId(String id) throws DOMException {
        this.setAttribute("Id", id);
    }

    @Override
    public String getId() {
        if (this.hasAttribute("Id")) {
            return this.getAttribute("Id");
        }
        return null;
    }

    @Override
    public String getType() {
        return "http://www.w3.org/2000/09/xmldsig#SignatureProperties";
    }
}

