/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.c14n;

import java.io.InputStream;
import java.util.Collection;
import oracle.security.xmlsec.c14n.C14NImpl;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.Canonicalizer;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLC14N
extends Canonicalizer {
    private C14NImpl c14nImpl;

    public XMLC14N() {
        this.c14nImpl = new C14NImpl(false);
    }

    XMLC14N(boolean withComments) {
        this.c14nImpl = new C14NImpl(withComments);
    }

    public XMLC14N(XSAlgorithmIdentifier c14nMethod) {
        super(c14nMethod);
        if (!"http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(c14nMethod.getAlgorithm())) {
            throw new IllegalArgumentException("Algorithm URI invalid for c14n");
        }
        if (c14nMethod.getParameters().getLength() != 0) {
            throw new IllegalArgumentException("Illegal CanonicalizationMethod parameter");
        }
        this.c14nImpl = new C14NImpl(false);
    }

    @Override
    public byte[] canonicalize(Node source) throws CanonicalizationException {
        return this.c14nImpl.canonicalize(source);
    }

    @Override
    public byte[] canonicalize(NodeList source) throws CanonicalizationException {
        return this.c14nImpl.canonicalize(source);
    }

    @Override
    public byte[] canonicalize(Collection source) throws CanonicalizationException {
        return this.c14nImpl.canonicalize(source);
    }

    @Override
    public byte[] canonicalize(InputStream source) throws CanonicalizationException {
        return this.c14nImpl.canonicalize(source);
    }

    @Override
    public byte[] canonicalize(InputStream source, String systemId) throws CanonicalizationException {
        return this.c14nImpl.canonicalize(source, systemId);
    }

    @Override
    public byte[] canonicalize(InputSource source) throws CanonicalizationException {
        return this.c14nImpl.canonicalize(source);
    }
}

