/*
 * Decompiled with CFR 0.152.
 */
package oracle.osysmodel.utils.validator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import model.BaseClass;
import model.SystemInstance;
import model.common.AbstractBaseTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator {
    private final Logger logger = Logger.getLogger(Validator.class.getName());
    private boolean isSuccessful;
    private final Map<AbstractBaseTarget, List<Method>> failedResultMap = new HashMap<AbstractBaseTarget, List<Method>>();
    private final SystemInstance si;

    public Validator(SystemInstance si) {
        if (si == null) {
            throw new NullPointerException("SystemInstance to validate is null");
        }
        this.si = si;
        this.isSuccessful = true;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public Map<AbstractBaseTarget, List<Method>> getFailedResultMap() {
        return this.failedResultMap;
    }

    private boolean validate(Map<Class<? extends AbstractBaseTarget>, List<Method>> validationFilter) {
        for (BaseClass sbc : this.si.getEntities()) {
            assert (sbc instanceof AbstractBaseTarget);
            AbstractBaseTarget entity = (AbstractBaseTarget)sbc;
            if (validationFilter.get(entity.getClass()) == null || validationFilter.get(entity.getClass()).size() == 0) {
                this.logger.log(Level.INFO, "Method Filter's for " + sbc.getClass() + " don't exist or is empty in the Validation Filter map. " + "This class will be ignored for validation");
                continue;
            }
            ArrayList<Method> failedMethods = new ArrayList<Method>();
            for (Method method : validationFilter.get(entity.getClass())) {
                Object ret = null;
                try {
                    ret = method.invoke((Object)sbc, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    this.logger.severe(e.getMessage());
                }
                catch (InvocationTargetException e) {
                    this.logger.severe(e.getMessage());
                }
                if (ret != null && (!(ret instanceof List) || !((List)ret).isEmpty())) continue;
                this.isSuccessful = false;
                failedMethods.add(method);
            }
            if (failedMethods.isEmpty()) continue;
            this.failedResultMap.put(entity, failedMethods);
        }
        return this.isSuccessful;
    }

    public boolean validate(List<AbstractBaseTarget> validationObjects) {
        HashMap<Class<? extends AbstractBaseTarget>, List<Method>> validationFilter = new HashMap<Class<? extends AbstractBaseTarget>, List<Method>>();
        for (AbstractBaseTarget entity : validationObjects) {
            validationFilter.put(entity.getClass(), entity.getRequestedGetters());
        }
        this.isSuccessful = this.validate(validationFilter);
        return this.isSuccessful;
    }
}

