/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.driver.sdk.productdriver.remote;

import com.oracle.helper.util.HelperUtility;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.OUIDriver;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;

public class RemoteNodes
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<String> remoteNodes;

    public RemoteNodes(ArrayList<String> remoteNodes) {
        this.remoteNodes = remoteNodes;
    }

    public static RemoteNodes getSerializedInstance(String crsHome) {
        RemoteNodes remoteNodes;
        String location = "";
        Logger logger = Logger.getLogger(RemoteNodes.class.getName());
        try {
            location = RemoteNodes.getSerializedLocation(crsHome);
            File f = new File(location);
            if (!f.exists()) {
                logger.fine("File with remote node list does not exist at location " + location);
                return null;
            }
            remoteNodes = (RemoteNodes)FileUtility.deserializeDataObj(location);
            logger.fine("List of remote nodes: " + remoteNodes.getRemoteNodes().toString());
        }
        catch (Exception e) {
            logger.fine("Failed to retrieve node list from local object " + location);
            return null;
        }
        return remoteNodes;
    }

    private static String getSerializedLocation(String crsHome) {
        return HelperUtility.detectOraBaseHome((String)crsHome) + ProductDriverConstants.CFGTOOLLOGS_OPATCHAUTODB + File.separator + "remoteNodes_" + OUIDriver.extractHostName(OsysUtility.getHostname());
    }

    public void saveDataObject(String crsHome) throws IOException {
        String location = RemoteNodes.getSerializedLocation(crsHome);
        Logger logger = Logger.getLogger(RemoteNodes.class.getName());
        logger.fine("Saving remote node list at location " + location);
        try {
            FileUtility.persistDataObj(location, this, true);
            logger.fine("List of remote nodes: " + this.getRemoteNodes().toString());
        }
        catch (IOException e) {
            logger.warning(e.toString());
            logger.warning("Failed to serialize remote node list.");
            throw e;
        }
    }

    public ArrayList<String> getRemoteNodes() {
        if (this.remoteNodes == null) {
            return new ArrayList<String>();
        }
        return this.remoteNodes;
    }
}

