/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbsysmodel.driver.sdk.productdriver;

import com.oracle.cie.common.util.FileUtils;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.credential.Credential;
import com.oracle.helper.util.HelperUtility;
import com.oracle.helper.util.WalletHelper;
import dbmodel.common.OUIComponent;
import dbmodel.common.OracleHome;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbsysmodel.driver.sdk.productdriver.ProductDriverException;
import oracle.dbsysmodel.driver.sdk.productdriver.constants.ProductDriverConstants;
import oracle.dbsysmodel.driver.sdk.productdriver.remote.HostData;
import oracle.dbsysmodel.driver.sdk.productdriver.remote.HostDataCollector;
import oracle.dbsysmodel.driver.sdk.util.FileUtility;
import oracle.dbsysmodel.driver.sdk.util.OsysUtility;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiClusterInstallInventory;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInstallInventoryReadException;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiNoSuchHomeException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiRemoteHome;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OUIDriver {
    private Logger logger = Logger.getLogger(OUIDriver.class.getName());
    private static OUIDriver ouiDriver = new OUIDriver();
    OiicStandardInventorySession osis = null;
    String OUI_DIR = "oui";
    String SYSTEM_PROPERTY_OUI_LOC = "oracle.installer.oui_loc";
    String SYSTEM_PROPERTY_STARTUP_LOC = "oracle.installer.startup_location";
    String LIB_DIR = "lib";
    String SYSTEM_PROPERTY_LIB_LOC = "oracle.installer.library_loc";

    public static int compareOPatchVersion(String s1, String s2) {
        OiiiVersion v1 = new OiiiVersion(s1);
        OiiiVersion v2 = new OiiiVersion(s2);
        if (v1.laterThan(v2)) {
            return 1;
        }
        if (v1.equals(v2)) {
            return 0;
        }
        return -1;
    }

    public static List<OracleHome> getLocalInfo(List<String> ohList) {
        Logger logger = Logger.getLogger(OUIDriver.class.getName());
        OUIDriver driver = new OUIDriver();
        OiicStandardInventorySession session = driver.initOUI();
        OiiiInstallAreaControl oiac = session.getInstallAreaControl();
        OiiiInstallInventory oii = oiac.getInstallInventory();
        ArrayList<OracleHome> homes = new ArrayList<OracleHome>();
        for (Object o : oii.getHomes()) {
            OiiiOracleHomeInfo homeinfo = (OiiiOracleHomeInfo)o;
            if (ohList != null && !OUIDriver.isSelectedForPatching(homeinfo, ohList)) continue;
            OracleHome oh = new OracleHome();
            oh.setId("ID_" + UUID.randomUUID().toString());
            if (OUIDriver.isWindows()) {
                oh.setPlatform("windows");
            } else {
                oh.setPlatform("linux");
            }
            oh.setType(oh.getClass().getName());
            oh.setDescription("A " + oh.getType());
            oh.setPath(new File(homeinfo.getLocation()).getAbsolutePath());
            oh.setInstalledSWComponents(new ArrayList());
            driver.writeHomeInfo(oh, homeinfo, oii);
            File inventoryFile = new File(oh.getPath(), "oraInst.loc");
            try {
                String invPtr = OUIDriver.readCentralInventoryLocation(inventoryFile);
                oh.setCentralInvPtr(invPtr);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to read central inventory file from " + inventoryFile.getPath(), e);
                continue;
            }
            try {
                String opatchVer = OUIDriver.checkOpatchVersion(oh.getPath());
                oh.setVersionOPatch(opatchVer);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to collect OPatch Version from " + oh.getPath(), e);
            }
            try {
                String oracleBase = OUIDriver.checkOracleBase(oh.getPath());
                oh.setOracleBaseLocation(oracleBase);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to get ORACLE_BASE for " + oh.getPath(), e);
                continue;
            }
            try {
                String owner = OUIDriver.checkFileOwner(new File(oh.getPath(), "oraInst.loc"));
                oh.setOwner(owner);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to get owner for " + oh.getPath(), e);
                continue;
            }
            homes.add(oh);
            logger.finest("Found Local Home:" + homeinfo.getLocation());
        }
        driver.endSession();
        return homes;
    }

    private static boolean isSelectedForPatching(OiiiOracleHomeInfo homeinfo, List<String> ohList) {
        for (String oh : ohList) {
            if (!FileUtils.getFile((String)homeinfo.getLocation()).equals(FileUtils.getFile((String)oh))) continue;
            return true;
        }
        return false;
    }

    public static List<OracleHome> getLocalInfo() {
        return OUIDriver.getLocalInfo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _checkOracleBase(String ohpath) {
        Logger logger = Logger.getLogger(OUIDriver.class.getName());
        File orabase = new File(ohpath + "/bin/orabase");
        if (!orabase.exists()) {
            logger.log(Level.FINE, ohpath + "/bin/orabase could not be found for OracleHome at " + ohpath);
            return null;
        }
        try {
            String s = null;
            Process p = Runtime.getRuntime().exec(new String[]{ohpath + "/bin/orabase"});
            try (BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                s = b.readLine();
                logger.fine(ohpath + " has ORACLE_BASE " + s);
            }
            return s;
        }
        catch (IOException e) {
            throw new ProductDriverException(e.getMessage(), e, ProductDriverException.Type.Unknown);
        }
    }

    public static String checkOracleBase(String ohPath) {
        Logger logger = Logger.getLogger(OUIDriver.class.getName());
        logger.entering(OUIDriver.class.getName(), "checkOracleBase");
        OiicStandardInventorySession session = new OiicStandardInventorySession("invcloner", "9.0.1.1");
        try {
            session.initSession(2);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not create an Inventory Session", e);
        }
        String oracleBase = null;
        try {
            OiiiInstallInventory inv = session.getInstallAreaControl().getInstallInventory();
            OiiiOracleHomeInfo homeInfo = inv.getHomeWithLocation(ohPath);
            oracleBase = homeInfo != null ? homeInfo.getAdditionalOracleHomeProperty("ORACLE_BASE") : OUIDriver._checkOracleBase(ohPath);
            session.endSession();
        }
        catch (Exception e) {
            session.endSession();
            logger.log(Level.WARNING, "Could not get ORACLE_BASE for " + ohPath + " via OUI API.");
            logger.fine("Exception due to " + e);
            logger.info("Going to attempt getting ORACLE_BASE using command for" + ohPath);
            oracleBase = OUIDriver._checkOracleBase(ohPath);
        }
        if (oracleBase != null) {
            logger.log(Level.FINE, "ORACLE_BASE for " + ohPath + " is " + oracleBase);
        } else {
            logger.log(Level.FINE, "ORACLE_BASE for " + ohPath + " is " + oracleBase);
        }
        logger.exiting(OUIDriver.class.getName(), "checkOracleBase");
        return oracleBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkOpatchVersion(String ohpath) {
        String string;
        Logger logger = Logger.getLogger(OUIDriver.class.getName());
        logger.entering(OUIDriver.class.getName(), "checkOpatchVersion");
        File opatch = new File(ohpath + "/OPatch/opatch");
        if (!opatch.exists()) {
            logger.log(Level.FINE, "OPatch/opatch could not be found for OracleHome at " + ohpath);
            return null;
        }
        String version = null;
        logger.log(Level.FINEST, "Executing OPatch/opatch version for OracleHome at " + ohpath);
        Process p = Runtime.getRuntime().exec(new String[]{ohpath + "/OPatch/opatch", "version"});
        BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String s = b.readLine();
            String prefix = "OPatch Version: ";
            while (s != null) {
                if (s.startsWith(prefix)) {
                    version = s.substring(prefix.length());
                    logger.fine(ohpath + " has OPatch Version " + version);
                    logger.exiting(OUIDriver.class.getName(), "checkOpatchVersion");
                    break;
                }
                s = b.readLine();
            }
            string = version;
        }
        catch (Throwable throwable) {
            try {
                b.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ProductDriverException(e.getMessage(), e, ProductDriverException.Type.Unknown);
            }
        }
        b.close();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readCentralInventoryLocation(File invPtr) {
        try (BufferedReader r = new BufferedReader(new FileReader(invPtr));){
            String line = r.readLine();
            String prefix = "inventory_loc=";
            while (line != null) {
                if (line.startsWith(prefix)) {
                    String string = line.substring(prefix.length());
                    return string;
                }
                line = r.readLine();
            }
            throw new ProductDriverException("Couldn't find inventory_loc in " + invPtr.getAbsolutePath(), ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        catch (IOException e) {
            throw new ProductDriverException(e.getMessage(), e, ProductDriverException.Type.Unknown);
        }
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("win");
    }

    private static String getCurrentRunningUser() {
        return System.getProperty("user.name");
    }

    @Deprecated
    public static String checkFileOwner(File f) {
        return FileUtility.checkFileOwner(f);
    }

    public static String checkFileGroup(File f) {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("aix")) {
            pb.command("/bin/ls", "-lXd", f.getAbsolutePath());
        } else {
            pb.command("/bin/ls", "-ld", f.getAbsolutePath());
        }
        try {
            Process p = pb.start();
            int ret = p.waitFor();
            if (ret != 0) {
                String prefix;
                String msg = new BufferedReader(new InputStreamReader(p.getErrorStream())).readLine();
                if (msg.startsWith(prefix = "/bin/ls:")) {
                    msg = msg.substring(prefix.length());
                }
                throw new ProductDriverException("Failed to check OH group:" + msg, ProductDriverException.Type.UnableToCollectKnownInformation);
            }
            String[] output = new BufferedReader(new InputStreamReader(p.getInputStream())).readLine().split("\\s+");
            if (output.length < 4) {
                throw new ProductDriverException("ls did not return the expected number of fields", ProductDriverException.Type.UnableToCollectKnownInformation);
            }
            return output[3];
        }
        catch (IOException e) {
            throw new ProductDriverException(e.getMessage(), e, ProductDriverException.Type.Unknown);
        }
        catch (InterruptedException e) {
            throw new ProductDriverException(e.getMessage(), e, ProductDriverException.Type.Unknown);
        }
    }

    private OUIDriver() {
    }

    public static OiicStandardInventorySession getStdInventorySession() {
        return ouiDriver.initOUI();
    }

    public static void endStdInventorySession() {
        ouiDriver.endSession();
    }

    OiicStandardInventorySession startSession() {
        OiicStandardInventorySession osis = new OiicStandardInventorySession("OUISM", "1.0");
        try {
            osis.initSession(0);
        }
        catch (OiitTargetLockNotAvailableException e) {
            throw new ProductDriverException(e, ProductDriverException.Type.ProductApiException);
        }
        catch (IOException e) {
            throw new ProductDriverException(e, ProductDriverException.Type.Unknown);
        }
        catch (OiiiInventoryDoesNotExistException e) {
            throw new ProductDriverException(e, ProductDriverException.Type.Unknown);
        }
        catch (Exception e) {
            this.logger.info("Hit the Exception : " + e.getMessage() + "\n" + e.toString() + "\n");
            e.printStackTrace();
            throw new ProductDriverException(e, ProductDriverException.Type.ProductApiException);
        }
        this.osis = osis;
        return osis;
    }

    void endSession() {
        this.osis.endSession();
        this.osis = null;
    }

    OiicStandardInventorySession initOUI() {
        String oh = System.getenv("ORACLE_HOME");
        if ((oh == null || oh.equals("")) && ((oh = System.getProperty("ORACLE_HOME")) == null || oh.equals(""))) {
            throw new ProductDriverException("Please set the ORACLE_HOME environment variable to the location of the Grid Infrastructure (GI) Home.");
        }
        StringBuffer ouiLocation = new StringBuffer(oh);
        ouiLocation.append(File.separator);
        ouiLocation.append(this.OUI_DIR);
        System.setProperty(this.SYSTEM_PROPERTY_OUI_LOC, ouiLocation.toString());
        System.setProperty(this.SYSTEM_PROPERTY_STARTUP_LOC, ouiLocation.toString());
        String sLibraryLoc = OiixPathOps.concatPath((String)ouiLocation.toString(), (String)this.LIB_DIR);
        String dirName = Platform.getCurrentPlatformDirectoryName();
        sLibraryLoc = OiixPathOps.concatPath((String)sLibraryLoc, (String)dirName);
        sLibraryLoc = OiixPathOps.getNativeForm((String)sLibraryLoc);
        HelperUtility.setSLibLocn((String)sLibraryLoc);
        return this.startSession();
    }

    void writeHomeInfo(OracleHome oh, OiiiOracleHomeInfo homeinfo, OiiiInstallInventory oii) {
        if (homeinfo == null) {
            this.logger.finest("No information for home at " + oh.getPath() + " in OUI inventory");
            return;
        }
        oh.setPlatform(homeinfo.getARUIDDescription());
        oh.setARUId(Integer.toString(homeinfo.getARUID()));
        oh.setDescription(homeinfo.getLocation());
        oh.setName(homeinfo.getUniqueName());
        oh.setHomeName(oh.getName());
        oh.setDisplayName(oh.getName());
        oh.setHomeGuid(homeinfo.getGUID());
        oh.setTopLevelOUI(new ArrayList());
        for (Object o : oii.getTopLevelComps(homeinfo.getIndex())) {
            OiiiCompInstallID e = (OiiiCompInstallID)o;
            OUIComponent comp = new OUIComponent();
            comp.setName(e.getName());
            comp.setId(UUID.randomUUID().toString());
            comp.setType(OUIComponent.class.getName());
            comp.setDescription(e.getName());
            comp.setDisplayName(e.getName());
            comp.setVersion(e.getVersion().getVerString());
            oh.getTopLevelOUI().add(comp);
            this.logger.finest("Added Component:" + comp.getName());
        }
        this.logger.finest("Added OUI Info to:" + oh.getName());
    }

    public static String getMaxMinVersion(List<String> minVersions) {
        String maxMinVersion = minVersions.get(0);
        for (String minVersion : minVersions) {
            OiiiVersion maxMinOiiiVersion;
            OiiiVersion minOiiiVersion = new OiiiVersion(minVersion);
            if (!minOiiiVersion.laterThan(maxMinOiiiVersion = new OiiiVersion(maxMinVersion))) continue;
            maxMinVersion = minVersion;
        }
        return maxMinVersion;
    }

    public static String getHomeIndex(String oracleHome) {
        String getHomeIndex = "";
        try {
            OiicStandardInventorySession iSession = new OiicStandardInventorySession("oplanInv", "1.0");
            iSession.initSession(0);
            OiiiInstallAreaControl iaCtrl = iSession.getInstallAreaControl();
            OiiiInstallInventory oiInv = iaCtrl.getInstallInventory();
            Vector homeList = oiInv.getHomes();
            int homeIndex = OiiiOracleHomeInfo.getOHIndex((Vector)homeList, (String)oracleHome);
            getHomeIndex = Integer.toString(homeIndex);
        }
        catch (Exception e) {
            getHomeIndex = "";
        }
        return getHomeIndex;
    }

    public static Object[] getTopLevelCompOfOracleHome(String oracleHome) {
        Object[] compInfo = null;
        try {
            OiicStandardInventorySession iSession = new OiicStandardInventorySession("oplanInv", "1.0");
            iSession.initSession(1);
            OiiiInstallAreaControl iaCtrl = iSession.getInstallAreaControl();
            OiiiInstallInventory oiInv = iaCtrl.getInstallInventory();
            Vector homeList = oiInv.getHomes();
            int homeIndex = OiiiOracleHomeInfo.getOHIndex((Vector)homeList, (String)oracleHome);
            Vector compList = oiInv.getTopLevelComps(homeIndex);
            for (Object obj : compList) {
                OiiiCompInstallID compInvEntry;
                if (!(obj instanceof OiiiCompInstallID) || (compInvEntry = (OiiiCompInstallID)obj) == null) continue;
                compInfo = new Object[]{compInvEntry.getName(), compInvEntry.getVersion()};
                break;
            }
        }
        catch (Exception e) {
            compInfo = null;
        }
        return compInfo;
    }

    public static HashMap<String, String> isHomeOnRemoteNode(String[] remoteNodeList, String candidateOH, Object compName, Object version) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            OiiiClusterInstallInventory clusterInv = new OiiiClusterInstallInventory(remoteNodeList);
            map.put("IS_CLUSTER_INV", "YES");
            for (int i = 0; i < remoteNodeList.length; ++i) {
                OiiiRemoteHome remoteHome = clusterInv.getRemoteHome(remoteNodeList[i], candidateOH);
                if (remoteHome != null) {
                    List allTopLevelComps = remoteHome.getTopLevelComps();
                    OiiiInstallCompInvEntry comp = (OiiiInstallCompInvEntry)allTopLevelComps.get(0);
                    OiiiVersion nodeHomeVersion = comp.getVersion();
                    OiiiCompInstallID cid = comp.getCompInstallID();
                    String nodeCompName = cid.getName();
                    String tempCompName = (String)compName;
                    OiiiVersion tempVersion = (OiiiVersion)version;
                    if (nodeHomeVersion.equals(tempVersion) && tempCompName.equalsIgnoreCase(nodeCompName)) continue;
                    map.put("IS_HOME_ON_REMOTE_NODE", "NO");
                } else {
                    map.put("IS_HOME_ON_REMOTE_NODE", "NO");
                }
                break;
            }
        }
        catch (Exception e) {
            map.put("IS_HOME_ON_REMOTE_NODE", "NO");
        }
        return map;
    }

    public static String[] fetchNodeNames(String homePath) {
        String[] nodes = new String[]{};
        OiicStandardInventorySession session = OUIDriver.getStdInventorySession();
        OiiiInstallAreaControl oiac = session.getInstallAreaControl();
        OiiiInstallInventory oii = oiac.getInstallInventory();
        block0: for (Object home : oii.getHomes()) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)home;
            if (null == homePath || !new File(homeInfo.getLocation()).equals(new File(homePath))) continue;
            Vector nodeList = homeInfo.getNodeList();
            if (nodeList.isEmpty()) break;
            nodes = new String[nodeList.size()];
            nodeList.toArray(nodes);
            String localNode = homeInfo.getLocalNode();
            if (localNode == null || localNode.equals("")) {
                localNode = OsysUtility.getHostname();
            }
            for (int i = 0; i < nodes.length; ++i) {
                if (!nodes[i].equals(localNode)) continue;
                if (i == 0) break block0;
                String tmp = nodes[0];
                nodes[0] = nodes[i];
                nodes[i] = tmp;
                break block0;
            }
        }
        if (nodes.length < 1) {
            nodes = new String[]{OsysUtility.getHostname()};
        }
        OUIDriver.endStdInventorySession();
        return nodes;
    }

    public static String[] fetchNodeNamesfor122(String homePath, String[] clusterNodes, String crshome, String walletLoc, char[] walletCharPwd) {
        return OUIDriver.fetchRemoteNodeData(homePath, clusterNodes, crshome, "get_all_homes", walletLoc, walletCharPwd);
    }

    public static String[] fetchRemoteNodeData(String homePath, String[] clusterNodes, String crshome, String action, String walletLoc, char[] walletCharPwd) {
        String[] nodes = new String[]{};
        if (null == crshome) {
            throw new ProductDriverException("Crs home must be provided, to identify the remote nodes of the home " + homePath, ProductDriverException.Type.Unknown);
        }
        if (null == clusterNodes || clusterNodes.length == 0) {
            throw new ProductDriverException("All nodes of the cluster must be provided, to identify the remote nodes of the home " + homePath, ProductDriverException.Type.Unknown);
        }
        HostData hostData = OUIDriver.fetchRemoteHostData(homePath, clusterNodes, crshome, action, walletLoc, walletCharPwd);
        List<Object> hostList = new ArrayList();
        if (null != hostData) {
            hostList = hostData.getNodeList();
        }
        if (null != hostList) {
            if (!StringUtil.isNullOrEmpty((String)action, (boolean)true) && action.equals("get_all_homes")) {
                hostList.add(OsysUtility.getHostname());
            }
            ArrayList<String> formattedHostList = new ArrayList<String>();
            for (String string : hostList) {
                formattedHostList.add(OUIDriver.extractHostName(string));
            }
            nodes = new String[formattedHostList.size()];
            formattedHostList.toArray(nodes);
        }
        return nodes;
    }

    public static HostData fetchRemoteHostData(String homePath, String[] clusterNodes, String crshome, String action, String walletLoc, char[] walletCharPwd) {
        String currentUser;
        HostData hostData = null;
        String homeOwner = FileUtility.checkFileOwner(new File(homePath, "oraInst.loc"));
        if (homeOwner.equalsIgnoreCase(currentUser = System.getProperty("user.name"))) {
            HostDataCollector driverHandler = new HostDataCollector();
            hostData = driverHandler.collectHostData(homePath, clusterNodes, crshome, action);
            if (hostData != null) {
                if (hostData.getResultID() == 2) {
                    OUIDriver.checkForException(hostData.getConnectionFailureMap());
                } else if (hostData.getResultID() == 3) {
                    OUIDriver.checkForException(hostData.getPrereqFailureMap());
                } else if (hostData.getResultID() == 1) {
                    OUIDriver.checkForException(hostData.getExceptionMap());
                }
            }
        } else {
            if (!OUIDriver.isRemoteHostExecutorScriptInstalled(homePath)) {
                throw new ProductDriverException("Opatch is not installed properly in home " + homePath + " in current host", ProductDriverException.Type.WrongOpatchInstallation);
            }
            ArrayList<String> cmdArr = new ArrayList<String>();
            if (OsysUtility.isRootAccess()) {
                cmdArr.add(OsysUtility.getSuCommand());
                cmdArr.add(homeOwner);
                String os = System.getProperty("os.name").toLowerCase();
                if (!os.startsWith("sunos") && !os.startsWith("hp")) {
                    cmdArr.add("-m");
                } else if (os.startsWith("hp")) {
                    cmdArr.add("+m");
                }
                cmdArr.add("-c");
                cmdArr.add(OUIDriver.getRemoteCommand(homePath, crshome, clusterNodes, action));
            } else if (!homeOwner.equalsIgnoreCase(currentUser)) {
                String password = null;
                if (!StringUtil.isNullOrEmpty((String)walletLoc)) {
                    try {
                        Credential credential = WalletHelper.getCredentialForLocalHost((File)new File(walletLoc), (char[])walletCharPwd);
                        password = new String(credential.getPassword());
                    }
                    catch (OPatchAutoException e1) {
                        throw new ProductDriverException(e1.getMessage(), e1, ProductDriverException.Type.Unknown);
                    }
                }
                OsysUtility.cleanSudoSession();
                cmdArr.add(OsysUtility.which("bash"));
                cmdArr.add("-c");
                cmdArr.add("echo '" + new String(password) + "'" + " | " + OsysUtility.getSudoCmd() + " -S -u " + homeOwner + " " + OUIDriver.getRemoteCommand(homePath, crshome, clusterNodes, action));
            }
            OsysUtility.CommandExecutionResult executionResult = OsysUtility.executeCmd(cmdArr);
            if (executionResult.getReturnCode() != 0 && OUIDriver.isRetryRequired(executionResult)) {
                cmdArr.remove("+m");
                executionResult = OsysUtility.executeCmd(cmdArr);
            }
            try {
                if (executionResult.isOk()) {
                    hostData = (HostData)FileUtility.deserializeDataObj(OUIDriver.getSerializedObjLoc(homePath));
                } else {
                    OUIDriver.handleExceptions(homePath, executionResult);
                }
            }
            catch (ClassNotFoundException e) {
                throw new ProductDriverException(e.getMessage(), e, ProductDriverException.Type.Unknown);
            }
            catch (IOException e) {
                throw new ProductDriverException(e.getMessage(), e, ProductDriverException.Type.Unknown);
            }
        }
        return hostData;
    }

    private static boolean isRetryRequired(OsysUtility.CommandExecutionResult ret) {
        String errorMsg;
        boolean isRetry = false;
        String osName = System.getProperty("os.name").toLowerCase();
        String string = errorMsg = StringUtil.isNullOrEmpty((String)ret.getErrorMessage(), (boolean)true) ? ret.getOutputMessage() : ret.getErrorMessage();
        if (osName.equalsIgnoreCase("hp-ux") && !StringUtil.isNullOrEmpty((String)errorMsg, (boolean)true) && errorMsg.contains("+m")) {
            isRetry = true;
        }
        return isRetry;
    }

    private static void handleExceptions(String homePath, OsysUtility.CommandExecutionResult executionResult) throws IOException, ClassNotFoundException {
        if (executionResult.getReturnCode() == 2) {
            Reporting.report((String)"IOException during persisting of HostData object on localhost");
            throw new ProductDriverException("IOException during persisting of HostData", ProductDriverException.Type.Unknown);
        }
        if (executionResult.getReturnCode() == 7) {
            HostData hostData = (HostData)FileUtility.deserializeDataObj(OUIDriver.getSerializedObjLoc(homePath));
            if (hostData != null && hostData.getResultID() == 2) {
                OUIDriver.checkForException(hostData.getConnectionFailureMap());
            }
        } else if (executionResult.getReturnCode() == 8) {
            HostData hostData = (HostData)FileUtility.deserializeDataObj(OUIDriver.getSerializedObjLoc(homePath));
            if (hostData != null && hostData.getResultID() == 3) {
                OUIDriver.checkForException(hostData.getPrereqFailureMap());
            }
        } else if (executionResult.getReturnCode() == 5) {
            HostData hostData = (HostData)FileUtility.deserializeDataObj(OUIDriver.getSerializedObjLoc(homePath));
            if (hostData != null && hostData.getResultID() == 1) {
                OUIDriver.checkForException(hostData.getExceptionMap());
            }
        } else {
            Reporting.report((String)executionResult.getErrorMessage());
            throw new ProductDriverException("Unable to execute command : " + executionResult.getErrorMessage(), ProductDriverException.Type.Unknown);
        }
    }

    private static void checkForException(Map<String, Throwable> exceptionMap) {
        Iterator<Map.Entry<String, Throwable>> iterator;
        if (!exceptionMap.isEmpty() && (iterator = exceptionMap.entrySet().iterator()).hasNext()) {
            Map.Entry<String, Throwable> entry = iterator.next();
            Reporting.report((String)entry.getValue().getMessage());
            throw new ProductDriverException("Execution failed for host " + entry.getKey() + " due to : " + entry.getValue());
        }
    }

    private static boolean isRemoteHostExecutorScriptInstalled(String oracleHomePath) {
        File scriptFile = new File(oracleHomePath + ProductDriverConstants.OPATCHAUTO_BIN + "RemoteHostExecutor.pl");
        return scriptFile.exists();
    }

    public static String extractHostName(String nodeName) {
        String hostName = nodeName;
        if (nodeName.indexOf(".") != -1) {
            hostName = nodeName.substring(0, nodeName.indexOf("."));
        }
        return hostName;
    }

    private static String getRemoteCommand(String oracleHomePath, String giHome, String[] clusterNodes, String action) {
        StringBuilder perlPath = new StringBuilder();
        perlPath.append(oracleHomePath).append(File.separator).append(ProductDriverConstants.PERL_PATH);
        String objLoc = OUIDriver.getSerializedObjLoc(oracleHomePath);
        StringBuilder remoteCommand = new StringBuilder();
        remoteCommand.append((CharSequence)perlPath);
        remoteCommand.append(oracleHomePath);
        remoteCommand.append(ProductDriverConstants.OPATCHAUTO_BIN);
        remoteCommand.append("RemoteHostExecutor.pl ");
        remoteCommand.append(" -oh=").append(oracleHomePath);
        remoteCommand.append(" -GRID_HOME=").append(giHome);
        if (null != clusterNodes && clusterNodes.length > 0) {
            String clusterNodeSet = Arrays.toString(clusterNodes);
            clusterNodeSet = clusterNodeSet.substring(1, clusterNodeSet.length() - 1);
            clusterNodeSet = clusterNodeSet.replaceAll(" ", "");
            remoteCommand.append(" -CLUSTERNODES=").append(clusterNodeSet);
        }
        remoteCommand.append(" -OBJECTLOC=").append(objLoc);
        if (!StringUtil.isNullOrEmpty((String)action, (boolean)true)) {
            remoteCommand.append(" -CRS_ACTION=").append(action);
        }
        remoteCommand.append(" -JVM_HANDLER=oracle/dbsysmodel/driver/sdk/productdriver/remote/HostDataCollector ");
        return remoteCommand.toString();
    }

    private static String getSerializedObjLoc(String oracleHomePath) {
        String objLoc = HelperUtility.detectOraBaseHome((String)oracleHomePath) + ProductDriverConstants.CFGTOOLLOGS_OPATCHAUTODB + File.separator + "hostlist.obj";
        return objLoc;
    }

    public static boolean firstVersionLaterThanSecond(String firstVersion, String secondVersion) {
        OiiiVersion firstVer = new OiiiVersion(firstVersion);
        OiiiVersion secondVer = new OiiiVersion(secondVersion);
        return firstVer.laterThan(secondVer);
    }

    public static boolean areLocationsSame(String firstLocation, String secondLocation) {
        OiipgFileSystem oiiFS = new OiipgFileSystem();
        return oiiFS.areLocsSame(firstLocation, secondLocation);
    }

    public static Map<String, Long> getOracleHomeSize(Set<String> ohPath) {
        OiicStandardInventorySession session = OUIDriver.getStdInventorySession();
        HashMap<String, Long> oracleHomeSize = new HashMap<String, Long>();
        try {
            OiiiInstallAreaControl oiac = session.getInstallAreaControl();
            OiiiInstallInventory oii = oiac.getInstallInventory();
            for (String path : ohPath) {
                oracleHomeSize.put(path, oii.getTotalHomeSize(path));
            }
        }
        catch (OiiiInstallInventoryReadException e) {
            throw new ProductDriverException(e.getMessage(), e, ProductDriverException.Type.Unknown);
        }
        catch (OiiiNoSuchHomeException e) {
            throw new ProductDriverException(e.getMessage(), e, ProductDriverException.Type.Unknown);
        }
        return oracleHomeSize;
    }

    public static boolean isSpaceAvailable(long requiredSize, String homePath) {
        return OiipgFileSystem.isSpaceAvailable((long)requiredSize, (String)homePath);
    }

    public static ArrayList<String[]> getHomesList() {
        ArrayList<String[]> homes = new ArrayList<String[]>();
        OiicStandardInventorySession session = OUIDriver.getStdInventorySession();
        OiiiInstallAreaControl oiac = session.getInstallAreaControl();
        OiiiInstallInventory oii = oiac.getInstallInventory();
        for (Object home : oii.getHomes()) {
            String homePath;
            String[] returnHomeInfo = new String[2];
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)home;
            returnHomeInfo[0] = homePath = homeInfo.getLocation();
            returnHomeInfo[1] = homeInfo.isCRSHome() ? "IS_CRS_HOME" : "IS_NOT_CRS_HOME";
            homes.add(returnHomeInfo);
        }
        return homes;
    }

    public static String getOUIVersion() {
        String version = "n/a";
        try {
            OiiiVersion curVer = null;
            ResourceBundle oResBundle = ResourceBundle.getBundle("OUIVersion");
            curVer = new OiiiVersion(oResBundle.getString("INSTALLER_VERSION"));
            if (curVer != null) {
                version = curVer.getVerString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    public static String getEnv(String varName) {
        return OiixEnvironmentOps.getEnv((String)varName);
    }

    public static void setEnv(String varName, String varValue) {
        OiixEnvironmentOps.setEnv((String)varName, (String)varValue);
    }

    public static void setupEnvironment(String oracleHomePath, String invPtrStr) {
        StringBuffer ouiLocation = null;
        String cmdOuiLocation = System.getProperty("OPatch.OUI_LOCATION");
        if (cmdOuiLocation == null || cmdOuiLocation.trim().length() == 0) {
            ouiLocation = new StringBuffer(oracleHomePath);
            ouiLocation.append(File.separator);
            ouiLocation.append("oui");
        } else {
            ouiLocation = new StringBuffer(cmdOuiLocation);
        }
        System.setProperty("oracle.installer.oui_loc", ouiLocation.toString());
        System.setProperty("oracle.installer.startup_location", ouiLocation.toString());
        String sLibraryLoc = OiixPathOps.concatPath((String)ouiLocation.toString(), (String)"lib");
        String dirName = Platform.getCurrentPlatformDirectoryName();
        sLibraryLoc = OiixPathOps.concatPath((String)sLibraryLoc, (String)dirName);
        sLibraryLoc = OiixPathOps.getNativeForm((String)sLibraryLoc);
        HelperUtility.setSLibLocn((String)sLibraryLoc);
        if (invPtrStr != null && !invPtrStr.isEmpty()) {
            System.setProperty("oracle.installer.invPtrLoc", invPtrStr);
        }
    }

    public static class Platform {
        public static String getCurrentPlatformDirectoryName() {
            return OiixPlatform.getCurrentPlatformDirectoryName();
        }
    }
}

