/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.utils;

import java.io.FileNotFoundException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.DomainConfigInventory;
import oracle.glcm.opatch.common.api.DomainInventoryLoadingException;
import oracle.glcm.opatch.common.api.DomainInventoryUpdatingException;

public class CheckConfigPatchInventory {
    public static void main(String[] args) {
        LogManager.getLogManager().getLogger("").setLevel(Level.SEVERE);
        String domainHome = args[0];
        DomainConfigInventory dci = null;
        try {
            dci = BasePatchFactory.instance().getDomainConfigInventory(domainHome);
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: Domain home: " + domainHome + " not found.");
            return;
        }
        catch (DomainInventoryLoadingException e) {
            System.err.println("Error: Failed to load inventory from domain: " + domainHome);
            return;
        }
        catch (DomainInventoryUpdatingException e) {
            System.err.println("Error: Failed to load/update inventory from domain: " + domainHome);
            return;
        }
        List listPie = null;
        List listAie = null;
        try {
            listPie = dci.getPatchInventoryEntries();
            listAie = dci.getEntries();
        }
        catch (DomainInventoryLoadingException e) {
            System.err.println("Error: Failed to get items from inventory " + domainHome);
            return;
        }
        if (listPie.size() == 0) {
            System.out.println("No patches have been found in domain configuration inventory " + domainHome);
        } else {
            System.out.println("List of patches in domain configuration inventory " + domainHome + listPie.toString());
        }
        if (listAie.size() == 0) {
            System.out.println("No actions have been found in domain configuration inventory " + domainHome);
        } else {
            System.out.println("List of configured actions in domain configuration inventory " + domainHome + listAie.toString());
        }
    }
}

