/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.patchhash;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.impl.patchhash.HashComputeFunction;

public class InventoryAndActionOnly
extends HashComputeFunction {
    @Override
    protected byte[] getHashData(String patchLocation, List<Patch> subpatches) throws IOException {
        List<String> metaList = this.fileList(patchLocation, subpatches);
        Collections.sort(metaList);
        StringBuffer data = new StringBuffer();
        for (int j = 0; j < metaList.size(); ++j) {
            String tempContents = this.getContent(new FileInputStream(new File(metaList.get(j)))).toString();
            boolean newLine = tempContents.endsWith("\n");
            StringBuffer metaContents = this.getContentWithFilter(new FileInputStream(new File(metaList.get(j))), "unique_patch_id", newLine);
            data.append(metaContents);
        }
        return data.toString().getBytes();
    }

    private StringBuffer getContentWithFilter(InputStream is, String filterWord, boolean newLine) throws IOException {
        Scanner sc = new Scanner(is);
        sc.useDelimiter("\n");
        StringWriter sw = new StringWriter();
        String line = null;
        String tempLine = null;
        while (sc.hasNext()) {
            if (tempLine != null) {
                sw.write(line);
                sw.write(10);
            }
            if (!(line = sc.next()).contains(filterWord)) {
                tempLine = line;
                continue;
            }
            tempLine = null;
        }
        if (tempLine != null) {
            sw.write(tempLine);
            if (newLine) {
                sw.write(10);
            }
        }
        sw.close();
        sc.close();
        return sw.getBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getContent(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        StringWriter sw = new StringWriter();
        char[] buff = new char[1024];
        int len = 0;
        try {
            while ((len = isr.read(buff, 0, buff.length)) != -1) {
                sw.write(buff, 0, len);
            }
        }
        finally {
            sw.close();
            isr.close();
        }
        return sw.getBuffer();
    }
}

