/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.patchhash;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.impl.SingletonPatch;
import oracle.glcm.opatch.common.impl.patchhash.AllMetataData;
import oracle.glcm.opatch.common.impl.patchhash.IncludeAutomationXml;
import oracle.glcm.opatch.common.impl.patchhash.InventoryAndActionOnly;
import oracle.glcm.opatch.common.impl.patchhash.InventoryAndActionOnlyV2;

public abstract class HashComputeFunction {
    static Logger logger = Logger.getLogger(HashComputeFunction.class.getName());
    static String hashAlgorithm = "sha1";
    protected static HashMap<Integer, HashComputeFunction> hashFunctions = new HashMap();

    public static HashComputeFunction getHashFunction(String s) {
        return hashFunctions.get(new Integer(s));
    }

    protected byte[] getHashData(String patchLocation, List<Patch> subpatches) throws IOException {
        List<String> metaList = this.fileList(patchLocation, subpatches);
        Collections.sort(metaList);
        StringBuffer data = new StringBuffer();
        for (int j = 0; j < metaList.size(); ++j) {
            String[] filterWords = new String[]{"unique_patch_id", "fvalue"};
            StringBuffer metaContents = this.getContentWithFilter(new FileInputStream(new File(metaList.get(j))), filterWords);
            logger.info("File to be hashed:" + metaList.get(j));
            logger.info("Partial hashcode:" + metaContents.hashCode());
            data.append(metaContents);
        }
        return data.toString().getBytes();
    }

    protected List<String> fileList(String patchLocation, List<Patch> listSubPatch) {
        ArrayList<String> metaList = new ArrayList<String>();
        for (Patch p : listSubPatch) {
            List subsubpatches = p.getSubPatches();
            for (Patch p1 : subsubpatches) {
                SingletonPatch singleton = (SingletonPatch)p1;
                metaList.add(new File(singleton.getActionFile()).getAbsolutePath());
                metaList.add(new File(singleton.getInventoryFile()).getAbsolutePath());
            }
        }
        return metaList;
    }

    public String computeHash(String patchLocation, List<Patch> subpatches) throws NoSuchAlgorithmException, IOException {
        byte[] hashData = this.getHashData(patchLocation, subpatches);
        return this.computeHash(hashData);
    }

    private String computeHash(byte[] data) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(hashAlgorithm);
        byte[] hashbytes = null;
        hashbytes = data.length == 0 ? new byte[]{} : md.digest(data);
        String HEXES = "0123456789ABCDEF";
        StringBuilder hex = new StringBuilder(2 * hashbytes.length);
        for (int j = 0; j < hashbytes.length; ++j) {
            byte bit = hashbytes[j];
            hex.append(HEXES.charAt((bit & 0xF0) >> 4)).append(HEXES.charAt(bit & 0xF));
        }
        String valueComp = hex.toString();
        return valueComp.toLowerCase();
    }

    protected StringBuffer getContentWithFilter(InputStream is, String[] filterWords) throws IOException {
        Scanner sc = new Scanner(is);
        sc.useDelimiter("\n");
        StringWriter sw = new StringWriter();
        String line = null;
        String tempLine = null;
        while (sc.hasNext()) {
            if (tempLine != null) {
                sw.write(line);
                sw.write(10);
            }
            line = sc.next();
            line = line.replaceAll("[\r]", "");
            boolean isFilter = false;
            for (int i = 0; i < filterWords.length; ++i) {
                if (line.trim().length() != 0 && !line.contains(filterWords[i])) continue;
                isFilter = true;
                break;
            }
            if (!isFilter) {
                tempLine = line;
                continue;
            }
            tempLine = null;
        }
        if (tempLine != null) {
            sw.write(tempLine.trim());
        }
        sw.close();
        sc.close();
        StringBuffer result = sw.getBuffer();
        logger.info("Data size:" + result.length());
        return result;
    }

    static {
        hashFunctions.put(1, new InventoryAndActionOnly());
        hashFunctions.put(2, new IncludeAutomationXml());
        hashFunctions.put(3, new InventoryAndActionOnlyV2());
        hashFunctions.put(4, new AllMetataData());
    }
}

