/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.dao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.ContentType;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.impl.PatchInventoryImpl;
import oracle.glcm.opatch.common.utils.LocalUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PatchInventoryDAO {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static String filename = "inventory.xml";
    private static String VERSION = "version";
    private static String NUMBER = "number";
    private static String PATCH_LEVEL = "patch_level";
    private static String PATH = "path";
    private static String FILE_NAME = "file_name";
    private static String EXECUTABLES = "executables";
    private static String EXECUTABLE = "executable";
    private static String INSTANCE_SHUTDOWN = "instance_shutdown";
    private static String INSTANCE_SHUTDOWN_MESSAGE = "instance_shutdown_message";
    private static String RUN_AS_ROOT = "run_as_root";
    private static String SQL_MIGRATE = "sql_migrate";
    private static String WLS_PREREQ_ONEOFFS = "wls_prereq_oneoffs";
    private static String ONEOFF_ID = "oneoff_id";
    private static String PREREQ_ONEOFFS = "prereq_oneoffs";
    private static String PREREQ = "prereq";
    private static String COREQ_ONEOFFS = "coreq_oneoffs";
    private static String COREQ = "coreq";
    private static String OVERLAY_ONEOFFS = "overlay_oneoffs";
    private static String OVERLAY = "overlay";
    private static String SYSTEM_COMPONENT_LIST = "system_component_list";
    private static String SYSTEM_COMPONENT = "system_component";
    private static String SHUTDOWN = "shutdown";
    private static String PATCH_TYPE = "patch_type";
    private static String SUB_TYPE = "sub_type";
    private static String PATCH_LANGUAGE = "patch_language";
    private static String PRODUCT_FAMILY = "product_family";
    private static String SUB_PRODUCT = "sub_product";
    private static String PATCHING_MODEL = "patching_model";
    private static String AUTO = "auto";
    private static String EXIT_IF_PRESCRIPT_ERROR = "exit_if_prescript_error";
    private static String TRANSLATABLE = "translatable";
    private static String APPLICATION_SHUTDOWN_LIST = "application_shutdown_list";
    private static String APPLICATION = "application";
    private static String APPLICABLE_PRODUCT = "applicable_product";
    private static String PRODUCTS = "products";
    private static String PRODUCT = "product";
    private static String AUTOMATION_LIST = "automation_list";
    private static String AUTOMATION = "automation";
    private static String CONSTITUENT = "constituent";
    private static String ACTIVE = "active";
    private static String FMW_ROLLING = "fmw_rolling";
    private static String FMW_FEATURE_BEARING = "fmw_feature_bearing";
    private static String SQL_PATCH = "sql_patch";
    private static String SQL_PATCH_DATABASE_STARTUP_MODE = "sql_patch_database_startup_mode";
    private static String ONLINE_RAC_INSTALLABLE = "online_rac_installable";
    private static String OPACK_VERSION = "opack_version";
    private static String MIN_OPATCH_VERSION = "minimum_opatch_version";
    private static String UNIQUE_TAG = "unique_tag";
    private static String TAG = "tag";
    private static String BASE_BUGS = "base_bugs";
    private static String BUG = "bug";
    private static String DESCRIPTION = "description";
    private static String COMPONENTS = "required_components";
    private static String CCOMPONENTS = "atleast_one_components";
    private static String COMPONENT = "component";
    private static String COMPONENT_NAME = "internal_name";
    private static String OPT_REQ = "opt_req";
    private static String OS_PLATFORMS = "os_platforms";
    private static String PLATFORM = "platform";
    private static String NAME = "name";
    private static String ID = "id";
    private static String VALUE = "value";
    private static String CANNOT_AUTOROLLBACK = "cannot_autorollback";
    private static String NOT_ROLLBACKABLE = "not_rollbackable";
    private static String PATCH_ID = "patch_id";
    private static String REFERENCE_ID = "reference_id";
    private static String PATCH_UPI = "unique_patch_id";
    private static String TEMP_PATCH_UPI = "temp_unique_patch_id";
    private static String PATCH_DESCRIPTION = "patch_description";
    private static String BUNDLE_DESCRIPTION = "bundle_description";
    private static String DATE_OF_PATCH = "date_of_patch";
    private static String DELETE_OLD_DIRCTORY = "delete_old_directory";
    private static String APPLICATION_DIRS = "application_dirs";
    private static String APPLICATION_DIR = "application_dir";
    private static String PATCH_CHARA = "patch_characteristics";
    private static String CONTENT_TYPE = "content_type";
    private static String STRSUBSPFILE = "custom_stringsubs_property_file";
    private static String OJVM = "ojvm";
    private static String RHP = "rhp";
    private static String RRP_Rolling = "two_stage_rolling";
    private static String RU = "ru";
    private static String RU_VERSION = "ru_version";
    private static String REGRESSED_PATCH_ID = "regressed_patch_id";
    private Document doc = null;

    public PatchInventoryDAO(String inventoryLoc) throws PatchMetadataLoadingException {
        this.logger.info("Enter PatchInventoryDAO constructor (file)...");
        try {
            Path fXmlFile = NioServiceFactory.getNioService().getPath(inventoryLoc, new String[0]);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            try (InputStream inputStream = Files.newInputStream(fXmlFile, new OpenOption[0]);){
                this.doc = dBuilder.parse(inputStream);
            }
            this.doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException pe) {
            throw new PatchMetadataLoadingException("Failed to configure xml parser for inventory.xml", (Throwable)pe);
        }
        catch (IOException ioe) {
            throw new PatchMetadataLoadingException("Failed to read inventory.xml file", (Throwable)ioe);
        }
        catch (SAXException se) {
            throw new PatchMetadataLoadingException("Failed to parse inventory.xml file", (Throwable)se);
        }
        this.logger.info("Done PatchInventoryDAO constructor (file)...");
    }

    public PatchInventoryDAO(InputStream zis) throws PatchMetadataLoadingException {
        this.logger.info("Enter PatchInventoryDAO constructor (stream)...");
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setIgnoringComments(true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            this.doc = dBuilder.parse(zis);
            this.doc.getDocumentElement().normalize();
        }
        catch (ParserConfigurationException pe) {
            throw new PatchMetadataLoadingException("Failed to configure xml parser for inventory.xml stream", (Throwable)pe);
        }
        catch (IOException ioe) {
            throw new PatchMetadataLoadingException("Failed to read inventory.xml stream", (Throwable)ioe);
        }
        catch (SAXException se) {
            throw new PatchMetadataLoadingException("Failed to parse inventory.xml stream", (Throwable)se);
        }
        this.logger.info("Done PatchInventoryDAO constructor (stream)...");
    }

    public void save(String xmlFile) throws PatchMetadataWritingException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            try (OutputStream outputStream = Files.newOutputStream(NioServiceFactory.getNioService().getPath(xmlFile, new String[0]), new OpenOption[0]);){
                transformer.transform(new DOMSource(this.doc), new StreamResult(outputStream));
            }
        }
        catch (TransformerException te) {
            throw new PatchMetadataWritingException("Failed transformation while writing out inventory.xml file " + xmlFile, (Throwable)te);
        }
        catch (IOException fnfe) {
            throw new PatchMetadataWritingException("Failed to write to file inventory.xml file: " + xmlFile, (Throwable)fnfe);
        }
    }

    public String getOpackVersion() {
        return LocalUtils.getAttribute(this.doc, OPACK_VERSION, VERSION, filename);
    }

    public List<PatchInventory.Component> getComponents() {
        ArrayList<PatchInventory.Component> list = new ArrayList<PatchInventory.Component>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(COMPONENT_NAME, VERSION, PATCH_LEVEL, OPT_REQ));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, COMPONENTS, COMPONENT, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (ArrayList<String> aList : attributeValues) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.ComponentImpl elem = new PatchInventoryImpl.ComponentImpl(patchInventoryImpl, aList.get(0), aList.get(1), aList.get(2), aList.get(3));
            list.add(elem);
        }
        return list;
    }

    public List<List<PatchInventory.Component>> getAtLeastOneComponents() {
        boolean isRequired = false;
        ArrayList<List<PatchInventory.Component>> result = new ArrayList<List<PatchInventory.Component>>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(COMPONENT_NAME, VERSION, PATCH_LEVEL, OPT_REQ));
        List<List<ArrayList<String>>> attributeValues = LocalUtils.getAttributesMultiple(this.doc, CCOMPONENTS, COMPONENT, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (List<ArrayList<String>> aList : attributeValues) {
            ArrayList<PatchInventoryImpl.ComponentImpl> cl = new ArrayList<PatchInventoryImpl.ComponentImpl>();
            for (ArrayList<String> al : aList) {
                PatchInventoryImpl patchInventoryImpl = im;
                Objects.requireNonNull(patchInventoryImpl);
                PatchInventoryImpl.ComponentImpl elem = new PatchInventoryImpl.ComponentImpl(patchInventoryImpl, al.get(0), al.get(1), al.get(2), al.get(3));
                cl.add(elem);
            }
            result.add(cl);
        }
        return result;
    }

    public PatchInventory.ProductFamily getProductFamily() {
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(VALUE));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, PRODUCT_FAMILY, SUB_PRODUCT, attributeNames, filename);
        String value = LocalUtils.getAttribute(this.doc, PRODUCT_FAMILY, VALUE, filename);
        ArrayList<String> subProducts = new ArrayList<String>();
        for (ArrayList<String> aList : attributeValues) {
            subProducts.add(aList.get(0));
        }
        return new PatchInventoryImpl.ProductFamilyImpl(new PatchInventoryImpl(), value, subProducts);
    }

    public List<PatchInventory.OsPlatform> getOsPlatforms() {
        ArrayList<PatchInventory.OsPlatform> list = new ArrayList<PatchInventory.OsPlatform>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(NAME, ID));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, OS_PLATFORMS, PLATFORM, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (ArrayList<String> aList : attributeValues) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.OsPlatformImpl elem = new PatchInventoryImpl.OsPlatformImpl(patchInventoryImpl, aList.get(0), aList.get(1));
            list.add(elem);
        }
        return list;
    }

    public String getPatchId() {
        String id = LocalUtils.getAttribute(this.doc, PATCH_ID, NUMBER, filename);
        if (id == null) {
            id = LocalUtils.getAttribute(this.doc, REFERENCE_ID, NUMBER, filename);
        }
        if (id == null) {
            this.logger.severe("Patch ID or Reference_ID does not exist in patch inventory.xml");
        }
        return id;
    }

    public String getPatchUpid() {
        String upi = LocalUtils.getValue(this.doc, PATCH_UPI, filename);
        if (upi == null) {
            upi = LocalUtils.getValue(this.doc, TEMP_PATCH_UPI, filename);
        }
        if (upi == null) {
            this.logger.severe("UPI or Temp UPI does not exist in patch inventory.xml");
        }
        return upi;
    }

    public String getMinOpatchVersion() {
        return LocalUtils.getValue(this.doc, MIN_OPATCH_VERSION, filename);
    }

    public String getPatchDescription() {
        return LocalUtils.getValue(this.doc, PATCH_DESCRIPTION, filename);
    }

    public String getBundleDescription() {
        return LocalUtils.getValue(this.doc, BUNDLE_DESCRIPTION, filename);
    }

    public Boolean getCannotAutoRollback() {
        return LocalUtils.getBooleanValue(this.doc, CANNOT_AUTOROLLBACK, filename);
    }

    public Boolean getNotRollbackable() {
        return LocalUtils.getBooleanValue(this.doc, NOT_ROLLBACKABLE, filename);
    }

    public Boolean getOJVM() {
        return LocalUtils.getBooleanValue(this.doc, OJVM, filename);
    }

    public Boolean getRHP() {
        return LocalUtils.getBooleanValue(this.doc, RHP, filename);
    }

    public Boolean getRRPRolling() {
        return LocalUtils.getBooleanValue(this.doc, RRP_Rolling, filename);
    }

    public Boolean getRu() {
        return LocalUtils.getBooleanValue(this.doc, RU, filename);
    }

    public String getRuVersion() {
        return LocalUtils.getValue(this.doc, RU_VERSION, filename);
    }

    public String getRegressedPatchId() {
        return LocalUtils.getValue(this.doc, REGRESSED_PATCH_ID, filename);
    }

    public Calendar getDateOfPatch() {
        return LocalUtils.getDate(this.doc, DATE_OF_PATCH, filename);
    }

    public String getUniqueTag() {
        return LocalUtils.getAttribute(this.doc, UNIQUE_TAG, TAG, filename);
    }

    public List<PatchInventory.Bug> getBugs() {
        ArrayList<PatchInventory.Bug> result = new ArrayList<PatchInventory.Bug>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(NUMBER, DESCRIPTION));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, BASE_BUGS, BUG, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (ArrayList<String> aList : attributeValues) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.BugImpl elem = new PatchInventoryImpl.BugImpl(patchInventoryImpl, aList.get(0), aList.get(1));
            result.add(elem);
        }
        return result;
    }

    public List<PatchInventory.Executable> getExecutables() {
        ArrayList<PatchInventory.Executable> list = new ArrayList<PatchInventory.Executable>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(PATH));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, EXECUTABLES, EXECUTABLE, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (ArrayList<String> aList : attributeValues) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.ExecutableImpl elem = new PatchInventoryImpl.ExecutableImpl(patchInventoryImpl, aList.get(0));
            list.add(elem);
        }
        return list;
    }

    public PatchInventory.Fvalue getFvalue() {
        List<String> childs = Arrays.asList("min_opatch_version", "function");
        List<String> fvalueElements = LocalUtils.getValues(this.doc, "fvalue", childs, filename);
        String hash = LocalUtils.getAttribute(this.doc, "fvalue", "value", filename);
        return new PatchInventoryImpl.FvalueImpl(new PatchInventoryImpl(), fvalueElements.get(0), fvalueElements.get(1), hash);
    }

    public Boolean getInstanceShutdown() {
        return LocalUtils.getBooleanValue(this.doc, INSTANCE_SHUTDOWN, filename);
    }

    public String getInstanceShutdownMessage() {
        return LocalUtils.getValue(this.doc, INSTANCE_SHUTDOWN_MESSAGE, filename);
    }

    public Boolean getOnlineRacInstallable() {
        return LocalUtils.getBooleanValue(this.doc, ONLINE_RAC_INSTALLABLE, filename);
    }

    public Boolean getRunAsRoot() {
        return LocalUtils.getBooleanValue(this.doc, RUN_AS_ROOT, filename);
    }

    public Boolean getSqlMigrate() {
        return LocalUtils.getBooleanValue(this.doc, SQL_MIGRATE, filename);
    }

    public List<PatchInventory.Prereq> getWlsPrereqOneoffs() {
        ArrayList<PatchInventory.Prereq> list = new ArrayList<PatchInventory.Prereq>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(ONEOFF_ID, OPT_REQ));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, WLS_PREREQ_ONEOFFS, PREREQ, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (ArrayList<String> aList : attributeValues) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.PrereqImpl elem = new PatchInventoryImpl.PrereqImpl(patchInventoryImpl, aList.get(0), aList.get(1));
            list.add(elem);
        }
        return list;
    }

    public List<PatchInventory.Prereq> getPrereqOneoffs() {
        ArrayList<PatchInventory.Prereq> list = new ArrayList<PatchInventory.Prereq>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(ONEOFF_ID));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, PREREQ_ONEOFFS, PREREQ, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (ArrayList<String> aList : attributeValues) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.PrereqImpl elem = new PatchInventoryImpl.PrereqImpl(patchInventoryImpl, aList.get(0), null);
            list.add(elem);
        }
        return list;
    }

    public List<PatchInventory.Prereq> getCoreqOneoffs() {
        ArrayList<PatchInventory.Prereq> list = new ArrayList<PatchInventory.Prereq>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(ONEOFF_ID));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, COREQ_ONEOFFS, COREQ, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (ArrayList<String> aList : attributeValues) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.PrereqImpl elem = new PatchInventoryImpl.PrereqImpl(patchInventoryImpl, aList.get(0), null);
            list.add(elem);
        }
        return list;
    }

    public List<PatchInventory.Prereq> getOverlayOneoffs() {
        ArrayList<PatchInventory.Prereq> list = new ArrayList<PatchInventory.Prereq>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(ONEOFF_ID));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, OVERLAY_ONEOFFS, OVERLAY, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (ArrayList<String> aList : attributeValues) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.PrereqImpl elem = new PatchInventoryImpl.PrereqImpl(patchInventoryImpl, aList.get(0), null);
            list.add(elem);
        }
        return list;
    }

    public String getPatchType() {
        return LocalUtils.getAttribute(this.doc, PATCH_TYPE, VALUE, filename);
    }

    public PatchSubType getPatchSubType() {
        String subtype = LocalUtils.getAttribute(this.doc, PATCH_TYPE, SUB_TYPE, filename);
        if (subtype == null || subtype.equals("")) {
            subtype = "unknown";
        }
        return PatchSubType.fromValue((String)subtype);
    }

    public String getPatchLanguage() {
        return LocalUtils.getAttribute(this.doc, PATCH_LANGUAGE, VALUE, filename);
    }

    public String getPatchModel() {
        return LocalUtils.getAttribute(this.doc, PATCHING_MODEL, VALUE, filename);
    }

    public Boolean getAuto() {
        return LocalUtils.getBooleanValue(this.doc, AUTO, filename);
    }

    public Boolean getExitIfPrescriptError() {
        return LocalUtils.getBooleanValue(this.doc, EXIT_IF_PRESCRIPT_ERROR, filename);
    }

    public Boolean getTranslatable() {
        return LocalUtils.getBooleanValue(this.doc, TRANSLATABLE, filename);
    }

    public List<PatchInventory.Application> getApplicationShutdownList() {
        ArrayList<PatchInventory.Application> list = new ArrayList<PatchInventory.Application>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(NAME, VERSION));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, APPLICATION_SHUTDOWN_LIST, APPLICATION, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (ArrayList<String> aList : attributeValues) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.ApplicationImpl elem = new PatchInventoryImpl.ApplicationImpl(patchInventoryImpl, aList.get(0), aList.get(1));
            list.add(elem);
        }
        return list;
    }

    public String getApplicableProduct() {
        return LocalUtils.getAttribute(this.doc, APPLICABLE_PRODUCT, VALUE, filename);
    }

    public List<PatchInventory.Product> getProducts() {
        ArrayList<PatchInventory.Product> result = new ArrayList<PatchInventory.Product>();
        NodeList nList = this.doc.getElementsByTagName(PRODUCTS);
        if (nList.getLength() == 0) {
            this.logger.info(PRODUCTS + " does not exist in " + filename);
            return result;
        }
        Element products = (Element)nList.item(0);
        NodeList pList = products.getElementsByTagName(PRODUCT);
        for (int i = 0; i < pList.getLength(); ++i) {
            PatchInventoryImpl im;
            Element product = (Element)pList.item(i);
            NodeList nameList = product.getElementsByTagName(NAME);
            Element name = (Element)nameList.item(0);
            String name_value = name.getAttribute(VALUE);
            NodeList versionList = product.getElementsByTagName(VERSION);
            ArrayList<String> versions = new ArrayList<String>();
            for (int j = 0; j < versionList.getLength(); ++j) {
                Element version = (Element)versionList.item(j);
                String version_value = version.getAttribute(VALUE);
                versions.add(version_value);
            }
            PatchInventoryImpl patchInventoryImpl = im = new PatchInventoryImpl();
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.ProductImpl p = new PatchInventoryImpl.ProductImpl(patchInventoryImpl, name_value, versions);
            result.add(p);
        }
        return result;
    }

    public List<PatchInventory.Automation> getAutomations() {
        ArrayList<PatchInventory.Automation> list = new ArrayList<PatchInventory.Automation>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(FILE_NAME));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, AUTOMATION_LIST, AUTOMATION, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (ArrayList<String> aList : attributeValues) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.AutomationImpl elem = new PatchInventoryImpl.AutomationImpl(patchInventoryImpl, aList.get(0));
            list.add(elem);
        }
        return list;
    }

    public List<PatchInventory.SystemComponent> getSystemComponentList() {
        ArrayList<PatchInventory.SystemComponent> list = new ArrayList<PatchInventory.SystemComponent>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(NAME, SHUTDOWN, VERSION));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, SYSTEM_COMPONENT_LIST, SYSTEM_COMPONENT, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (ArrayList<String> aList : attributeValues) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.SystemComponentImpl elem = new PatchInventoryImpl.SystemComponentImpl(patchInventoryImpl, aList.get(0), aList.get(1), new Boolean(aList.get(2)));
            list.add(elem);
        }
        return list;
    }

    public String getConstituentPatchId() {
        return LocalUtils.getAttribute(this.doc, CONSTITUENT, ACTIVE, filename);
    }

    public Boolean getFMWRolling() {
        return LocalUtils.getBooleanValue(this.doc, FMW_ROLLING, filename);
    }

    public Boolean getFMWFeatureBearing() {
        return LocalUtils.getBooleanValue(this.doc, FMW_FEATURE_BEARING, filename);
    }

    public Boolean getSqlPatch() {
        return LocalUtils.getBooleanValue(this.doc, SQL_PATCH, filename);
    }

    public String getSqlPatchDatabaseStartupMode() {
        return LocalUtils.getValue(this.doc, SQL_PATCH_DATABASE_STARTUP_MODE, filename);
    }

    public Boolean getDeleteOldDirectory() {
        return LocalUtils.getBooleanValue(this.doc, DELETE_OLD_DIRCTORY, filename);
    }

    public List<PatchInventory.ApplicationDir> getAppDirs() {
        ArrayList<PatchInventory.ApplicationDir> list = new ArrayList<PatchInventory.ApplicationDir>();
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(PATH));
        List<ArrayList<String>> attributeValues = LocalUtils.getAttributes(this.doc, APPLICATION_DIRS, APPLICATION_DIR, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        for (ArrayList<String> aList : attributeValues) {
            PatchInventoryImpl patchInventoryImpl = im;
            Objects.requireNonNull(patchInventoryImpl);
            PatchInventoryImpl.ApplicationDirImpl elem = new PatchInventoryImpl.ApplicationDirImpl(patchInventoryImpl, aList.get(0));
            list.add(elem);
        }
        return list;
    }

    public PatchInventory.PatchCharacteristics getPatchChara() {
        ArrayList<String> attributeNames = new ArrayList<String>(Arrays.asList(VALUE));
        List<ArrayList<String>> contentTypeAttributeValues = LocalUtils.getAttributes(this.doc, PATCH_CHARA, CONTENT_TYPE, attributeNames, filename);
        PatchInventoryImpl im = new PatchInventoryImpl();
        PatchInventoryImpl.PatchCharacteristicsImpl patchChara = new PatchInventoryImpl.PatchCharacteristicsImpl(im);
        if (contentTypeAttributeValues.size() != 0) {
            String contentTypeValue = contentTypeAttributeValues.get(0).get(0);
            patchChara.setContentType(ContentType.fromValue((String)contentTypeValue));
        } else {
            patchChara.setContentType(ContentType.GENERIC);
        }
        return patchChara;
    }

    public Boolean getStrsubsPropertyFile() {
        return LocalUtils.getBooleanValue(this.doc, STRSUBSPFILE, filename);
    }
}

