/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.dao;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchMetadataWritingException;
import oracle.glcm.opatch.common.impl.PatchXMLValidationEventHandler;
import oracle.glcm.opatch.common.impl.pad.PatchConfigurationType;
import oracle.glcm.opatch.common.impl.pad.PatchDeploy;
import oracle.glcm.opatch.common.utils.SecureUnmarshaller;
import org.xml.sax.SAXException;

public class PatchDeployDAO {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static Class<PatchDeploy> PatchDeployClass = PatchDeploy.class;
    private static String PatchDeployPackage = PatchDeployClass.getPackage().getName();
    private static String patchDeployXSD = "/oracle/glcm/opatch/common/impl/pad/patchdeploy.xsd";
    String padLocation = null;
    private PatchDeploy patchDeployObj = null;
    private Marshaller marshaller = null;
    private Unmarshaller unmarshaller = null;
    private Schema schema = null;

    public PatchDeployDAO() throws PatchMetadataLoadingException {
        this((String)null);
    }

    public PatchDeployDAO(PatchDeploy patchDeployObj) throws PatchMetadataLoadingException {
        this.patchDeployObj = patchDeployObj;
    }

    public PatchDeployDAO(String padLocation) throws PatchMetadataLoadingException {
        this.logger.info("Enter PatchDeployDAO constructor...");
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)PatchDeployPackage);
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = PatchDeployClass.getResource(patchDeployXSD);
            this.schema = sf.newSchema(url);
            this.marshaller = jaxbContext.createMarshaller();
            this.marshaller.setSchema(this.schema);
            this.marshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.unmarshaller = jaxbContext.createUnmarshaller();
            this.unmarshaller.setSchema(this.schema);
            this.unmarshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
        }
        catch (JAXBException e) {
            throw new PatchMetadataLoadingException("Failed to initialize jaxb context for patch deploy", (Throwable)e);
        }
        catch (SAXException e) {
            throw new PatchMetadataLoadingException("Failed to initialize jaxb context for patch deploy", (Throwable)e);
        }
        if (padLocation == null) {
            this.patchDeployObj = new PatchDeploy();
            this.patchDeployObj.setPatchConfiguration(new PatchConfigurationType());
        } else {
            try (InputStream inputStream = Files.newInputStream(NioServiceFactory.getNioService().getPath(padLocation, new String[0]), new OpenOption[0]);){
                this.patchDeployObj = (PatchDeploy)SecureUnmarshaller.unmarshal(this.unmarshaller, inputStream);
            }
            catch (Exception je) {
                throw new PatchMetadataLoadingException("Failed to load or parse " + padLocation, (Throwable)je);
            }
        }
        this.logger.info("Done PatchDeployDAO creation.");
    }

    public boolean validate() {
        return this.patchDeployObj != null;
    }

    public PatchDeploy getPatchDeployObj() {
        return this.patchDeployObj;
    }

    public void savePatchDeployObj(String fileLoc) throws PatchMetadataWritingException {
        try (OutputStream outputStream = Files.newOutputStream(NioServiceFactory.getNioService().getPath(fileLoc, new String[0]), new OpenOption[0]);){
            this.marshaller.marshal((Object)this.patchDeployObj, outputStream);
        }
        catch (Exception je) {
            throw new PatchMetadataWritingException("Failed to write or parse the patch deploy artifact", (Throwable)je);
        }
    }

    public String convertToString() throws Exception {
        String xmlString = null;
        try (StringWriter stringWriter = new StringWriter();){
            this.marshaller.marshal((Object)this.patchDeployObj, (Writer)stringWriter);
            xmlString = stringWriter.toString();
        }
        return xmlString;
    }
}

