/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.dao;

import com.oracle.xmlns.cie.glcm.patch.mai.ArtifactRefType;
import com.oracle.xmlns.cie.glcm.patch.mai.MaintenanceAliasArtifactsMappingType;
import com.oracle.xmlns.cie.glcm.patch.mai.MaintenanceAliasInfo;
import com.oracle.xmlns.cie.glcm.patch.mai.MaintenanceAliasType;
import com.oracle.xmlns.cie.glcm.patch.mai.MaintenanceAliasesType;
import com.oracle.xmlns.cie.glcm.patch.mai.MappingType;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.impl.PatchXMLValidationEventHandler;
import oracle.glcm.opatch.common.utils.SecureUnmarshaller;

public class MaintenanceAliasInfoDAO {
    private final Logger _logger;
    private static Class<MaintenanceAliasInfo> maiClass = MaintenanceAliasInfo.class;
    private static final String maiXsdFile = "maintenance_alias_info.xsd";
    private MaintenanceAliasInfo maiObj;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;
    private Schema schema;
    private Path aliasInfoFile;

    public MaintenanceAliasInfoDAO(String fileDir, boolean load) throws MaintenanceAliasException {
        block13: {
            this._logger = Logger.getLogger(this.getClass().getName());
            this.maiObj = null;
            this.marshaller = null;
            this.unmarshaller = null;
            this.schema = null;
            this.aliasInfoFile = null;
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MaintenanceAliasInfo.class});
                SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                URL url = maiClass.getResource(maiXsdFile);
                this.schema = sf.newSchema(url);
                this.marshaller = jaxbContext.createMarshaller();
                this.marshaller.setSchema(this.schema);
                this.marshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
                this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                this.unmarshaller = jaxbContext.createUnmarshaller();
                this.unmarshaller.setSchema(this.schema);
                this.unmarshaller.setEventHandler((ValidationEventHandler)new PatchXMLValidationEventHandler());
            }
            catch (Exception e) {
                throw new MaintenanceAliasException("Failed to initialize jaxb context", (Throwable)e);
            }
            this.maiObj = new MaintenanceAliasInfo();
            if (fileDir == null || fileDir.trim().isEmpty()) {
                throw new MaintenanceAliasException("The XML file cannot be null or empty");
            }
            this.aliasInfoFile = NioServiceFactory.getNioService().getPath(fileDir, new String[0]);
            if (load) {
                if (!Files.exists(this.aliasInfoFile, new LinkOption[0]) || !Files.isRegularFile(this.aliasInfoFile, new LinkOption[0])) {
                    throw new MaintenanceAliasException("The XML " + this.aliasInfoFile.toString() + " is not a valid file.");
                }
                this._logger.finest("Unmarshal from file " + this.aliasInfoFile);
                try (InputStream inputStream = Files.newInputStream(this.aliasInfoFile, new OpenOption[0]);){
                    this.maiObj = (MaintenanceAliasInfo)SecureUnmarshaller.unmarshal(this.unmarshaller, inputStream);
                    break block13;
                }
                catch (Exception e) {
                    throw new MaintenanceAliasException((Throwable)e);
                }
            }
            this.saveToFile();
        }
    }

    public void setMaintenanceAliases(MaintenanceAliasesType aliasesObj) {
        this.maiObj.setMaintenanceAliases(aliasesObj);
    }

    public void setMaintenanceAliasArtifactsMapping(MaintenanceAliasArtifactsMappingType mappingsObj) {
        this.maiObj.setMaintenanceAliasArtifactsMapping(mappingsObj);
    }

    public void addMainenanceAlias(String productFamily, String key, String product, String bundleType, String version, String timestamp, String patchType, String patchLevel) {
        MaintenanceAliasesType aliasesObj = this.getMaintenanceAliases();
        if (aliasesObj == null) {
            aliasesObj = new MaintenanceAliasesType();
        }
        List aliases = aliasesObj.getMaintenanceAlias();
        MaintenanceAliasType alias = new MaintenanceAliasType();
        alias.setProductFamily(productFamily);
        alias.setMaintenanceAliasKey(key);
        alias.setProduct(product);
        alias.setBundleType(bundleType);
        alias.setVersion(version);
        alias.setTimestamp(timestamp);
        alias.setPatchType(patchType);
        alias.setPatchLevel(patchLevel);
        aliases.add(alias);
        this.maiObj.setMaintenanceAliases(aliasesObj);
    }

    public void addMapping(String key, List<ArtifactRefType> components, List<ArtifactRefType> featuresets, List<ArtifactRefType> distributions) {
        MaintenanceAliasArtifactsMappingType mappingsObj = this.maiObj.getMaintenanceAliasArtifactsMapping();
        if (mappingsObj == null) {
            mappingsObj = new MaintenanceAliasArtifactsMappingType();
        }
        List mappings = mappingsObj.getMapping();
        MappingType mapping = new MappingType();
        mapping.setMaintenanceAliasKey(key);
        this.addListToArtifact(mapping.getComponent(), components);
        this.addListToArtifact(mapping.getFeatureSet(), featuresets);
        this.addListToArtifact(mapping.getDistribution(), distributions);
        mappings.add(mapping);
        this.maiObj.setMaintenanceAliasArtifactsMapping(mappingsObj);
    }

    private void addListToArtifact(List<ArtifactRefType> artifactsTo, List<ArtifactRefType> artifactsFrom) {
        if (artifactsFrom != null) {
            for (ArtifactRefType artifact : artifactsFrom) {
                artifactsTo.add(artifact);
            }
        }
    }

    public MaintenanceAliasArtifactsMappingType getMaintenanceAliasArtifactsMapping() {
        return this.maiObj.getMaintenanceAliasArtifactsMapping();
    }

    public MaintenanceAliasesType getMaintenanceAliases() {
        return this.maiObj.getMaintenanceAliases();
    }

    public List<MaintenanceAliasType> getAliases() {
        if (this.getMaintenanceAliases() != null) {
            return this.getMaintenanceAliases().getMaintenanceAlias();
        }
        return new ArrayList<MaintenanceAliasType>();
    }

    public List<MappingType> getMappings() {
        if (this.getMaintenanceAliasArtifactsMapping() != null) {
            return this.getMaintenanceAliasArtifactsMapping().getMapping();
        }
        return new ArrayList<MappingType>();
    }

    public synchronized void saveToFile() throws MaintenanceAliasException {
        this.saveToFile(this.aliasInfoFile);
    }

    public synchronized void saveToFile(Path maFile) throws MaintenanceAliasException {
        this._logger.finest("Marshal to file " + maFile);
        try {
            Path parent = maFile.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            try (OutputStream outputStream = Files.newOutputStream(maFile, new OpenOption[0]);){
                this.marshaller.marshal((Object)this.maiObj, outputStream);
            }
        }
        catch (Exception e) {
            throw new MaintenanceAliasException((Throwable)e);
        }
    }
}

