/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl.alias.action;

import com.oracle.xmlns.cie.glcm.patch.mai.ArtifactRefType;
import com.oracle.xmlns.cie.glcm.patch.mai.MaintenanceAliasType;
import com.oracle.xmlns.cie.glcm.patch.mai.MappingType;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.alias.ArtifactReference;
import oracle.glcm.opatch.common.api.alias.MaintenanceAlias;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasBuilderFactory;
import oracle.glcm.opatch.common.api.alias.MaintenanceAliasException;
import oracle.glcm.opatch.common.api.alias.action.ActionType;
import oracle.glcm.opatch.common.api.alias.action.ArtifactReferenceAction;
import oracle.glcm.opatch.common.api.alias.action.MaintenanceAliasAction;
import oracle.glcm.opatch.common.api.alias.action.MaintenanceAliasActionBuilderFactory;
import oracle.glcm.opatch.common.api.alias.action.MaintenanceAliasActionHolder;
import oracle.glcm.opatch.common.api.alias.action.MappingAction;
import oracle.glcm.opatch.common.helpers.MaintenanceAliasInfoHelper;
import oracle.glcm.opatch.common.impl.alias.action.MaintenanceAliasActionBuilderFactoryImpl;
import oracle.glcm.opatch.common.impl.dao.MaintenanceAliasInfoDAO;

public class MaintenanceAliasActionService {
    private static volatile MaintenanceAliasActionService instance = null;
    private MaintenanceAliasActionBuilderFactory maintenanceAliasActionBuilderFactory = MaintenanceAliasActionBuilderFactoryImpl.getInstance();
    private MaintenanceAliasBuilderFactory maintenanceAliasBuilderFactory = MaintenanceAliasInfoHelper.getInstance().getMaintenanceAliasBuilderFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MaintenanceAliasActionService getInstance() throws MaintenanceAliasException {
        if (instance != null) return instance;
        Class<MaintenanceAliasActionService> clazz = MaintenanceAliasActionService.class;
        synchronized (MaintenanceAliasActionService.class) {
            if (instance != null) return instance;
            instance = new MaintenanceAliasActionService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private MaintenanceAliasActionService() throws MaintenanceAliasException {
    }

    public MaintenanceAliasActionHolder loadMaintenanceAliasAction(String xmlFilePath) throws MaintenanceAliasException {
        return this.loadMaintenanceAliasAction(NioServiceFactory.getNioService().getPath(xmlFilePath, new String[0]));
    }

    public MaintenanceAliasActionHolder loadMaintenanceAliasAction(Path xmlFile) throws MaintenanceAliasException {
        if (!(xmlFile != null && Files.exists(xmlFile, new LinkOption[0]) && Files.isRegularFile(xmlFile, new LinkOption[0]) && Files.isReadable(xmlFile))) {
            throw new MaintenanceAliasException("Can not load XML from an invalid file.");
        }
        MaintenanceAliasInfoDAO maintenanceAliasInfoDAO = new MaintenanceAliasInfoDAO(xmlFile.toString(), true);
        List maintenanceAliases = maintenanceAliasInfoDAO.getMaintenanceAliases().getMaintenanceAlias();
        HashSet<MaintenanceAliasAction> maintenanceAliasActions = new HashSet<MaintenanceAliasAction>();
        List mappings = maintenanceAliasInfoDAO.getMaintenanceAliasArtifactsMapping().getMapping();
        HashSet<MappingAction> mappingActions = new HashSet<MappingAction>();
        for (MaintenanceAliasType maintenanceAlias : maintenanceAliases) {
            MaintenanceAlias ma = this.maintenanceAliasBuilderFactory.getMaintenanceAliasBuilder(maintenanceAlias.getProductFamily(), maintenanceAlias.getMaintenanceAliasKey(), maintenanceAlias.getProduct(), maintenanceAlias.getBundleType(), maintenanceAlias.getVersion(), maintenanceAlias.getTimestamp(), maintenanceAlias.getPatchType(), null).setPatchLevel(maintenanceAlias.getPatchLevel()).build();
            ActionType action = this.toActionType(maintenanceAlias.getAction());
            MaintenanceAliasAction maintenanceAliasAction = this.maintenanceAliasActionBuilderFactory.getMaintenanceAliasActionBuilder(ma, action).build();
            maintenanceAliasActions.add(maintenanceAliasAction);
        }
        for (MappingType mapping : mappings) {
            ArtifactReferenceAction artifactReferenceAction;
            ActionType action;
            ArtifactReference artifactReference;
            String maintenanceAliasKey = mapping.getMaintenanceAliasKey();
            List components = mapping.getComponent();
            HashSet<ArtifactReferenceAction> componentActions = new HashSet<ArtifactReferenceAction>();
            List distributions = mapping.getDistribution();
            HashSet<ArtifactReferenceAction> distributionActions = new HashSet<ArtifactReferenceAction>();
            List featureSets = mapping.getFeatureSet();
            HashSet<ArtifactReferenceAction> featureSetActions = new HashSet<ArtifactReferenceAction>();
            for (ArtifactRefType component : components) {
                artifactReference = this.maintenanceAliasBuilderFactory.getComponentArtifactReferenceBuilder(component.getName(), component.getVersion()).build();
                action = this.toActionType(component.getAction());
                artifactReferenceAction = this.maintenanceAliasActionBuilderFactory.getArtifactReferenceActionBuilder(maintenanceAliasKey, artifactReference, action).build();
                componentActions.add(artifactReferenceAction);
            }
            for (ArtifactRefType distribution : distributions) {
                artifactReference = this.maintenanceAliasBuilderFactory.getDistributionArtifactReferenceBuilder(distribution.getName(), distribution.getVersion()).build();
                action = this.toActionType(distribution.getAction());
                artifactReferenceAction = this.maintenanceAliasActionBuilderFactory.getArtifactReferenceActionBuilder(maintenanceAliasKey, artifactReference, action).build();
                distributionActions.add(artifactReferenceAction);
            }
            for (ArtifactRefType featureSet : featureSets) {
                artifactReference = this.maintenanceAliasBuilderFactory.getFeatureSetArtifactReferenceBuilder(featureSet.getName(), featureSet.getVersion()).build();
                action = this.toActionType(featureSet.getAction());
                artifactReferenceAction = this.maintenanceAliasActionBuilderFactory.getArtifactReferenceActionBuilder(maintenanceAliasKey, artifactReference, action).build();
                featureSetActions.add(artifactReferenceAction);
            }
            MappingAction mappingAction = this.maintenanceAliasActionBuilderFactory.getMappingActionBuilder(maintenanceAliasKey, componentActions, distributionActions, featureSetActions).build();
            mappingActions.add(mappingAction);
        }
        return this.maintenanceAliasActionBuilderFactory.getMaintenanceAliasActionHolderBuilder(maintenanceAliasActions, mappingActions).build();
    }

    private ActionType toActionType(String action) throws MaintenanceAliasException {
        if (action != null && !action.isEmpty()) {
            if (action.equalsIgnoreCase("add")) {
                return ActionType.ADD;
            }
            if (action.equalsIgnoreCase("delete")) {
                return ActionType.DELETE;
            }
            if (action.equalsIgnoreCase("update")) {
                return ActionType.UPDATE;
            }
        }
        throw new MaintenanceAliasException("Failed to convert String to MaintenanceAliasAction.ActionType");
    }

    public Map<String, MappingAction> getMappingActionMap(MaintenanceAliasActionHolder maintenanceAliasActionHolder) throws MaintenanceAliasException {
        if (maintenanceAliasActionHolder == null) {
            throw new MaintenanceAliasException("Invalid parameters were given.");
        }
        Set mappingActions = maintenanceAliasActionHolder.getMappingActions();
        HashMap<String, MappingAction> mappingActionMap = new HashMap<String, MappingAction>();
        if (mappingActions != null && !mappingActions.isEmpty()) {
            for (MappingAction mappingAction : mappingActions) {
                mappingActionMap.put(mappingAction.getMaintenanceAliasKey(), mappingAction);
            }
        }
        return mappingActionMap;
    }
}

