/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.impl;

import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.Result;
import oracle.glcm.opatch.common.utils.LocalUtils;

public class ComponentCheckResultImpl
implements ComponentCheckResult {
    private PatchInventory.Component _component;
    private Result _result = Result.NOT_EVALUATED;
    private String _details;

    public ComponentCheckResultImpl(PatchInventory.Component component) {
        if (component == null) {
            throw new IllegalArgumentException("The component provided was null.");
        }
        this._component = component;
    }

    public PatchInventory.Component getComponent() {
        return this._component;
    }

    public Result getResult() {
        return this._result;
    }

    public void setResult(Result result) {
        this._result = result != null ? result : Result.NOT_EVALUATED;
    }

    public String getDetails() {
        return this._details;
    }

    public void setDetails(String details) {
        this._details = details;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Component ").append(this.getComponent().getName()).append(" ").append(this.getComponent().getVersion());
        if (!LocalUtils.isNullOrEmpty(this.getComponent().getPatchLevel(), true)) {
            sb.append(" (patch-level ").append(this.getComponent().getPatchLevel()).append(")");
        }
        sb.append(" Result: ").append(this.getResult());
        String details = this.getDetails();
        if (!LocalUtils.isNullOrEmpty(details, true)) {
            sb.append(" Details: ").append(details);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComponentCheckResultImpl)) {
            return false;
        }
        ComponentCheckResultImpl that = (ComponentCheckResultImpl)o;
        PatchInventory.Component thisComponent = this.getComponent();
        PatchInventory.Component thatComponent = that.getComponent();
        if (thisComponent.getName().equals(thatComponent.getName()) && thisComponent.getVersion().equals(thatComponent.getVersion())) {
            String thisPatchLevel = thisComponent.getPatchLevel();
            String thatPatchLevel = thatComponent.getPatchLevel();
            if (thisPatchLevel != null && thisPatchLevel.equals(thatPatchLevel) || thisPatchLevel == null && thatPatchLevel == null) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        String thisName = this.getComponent().getName();
        String thisVersion = this.getComponent().getVersion();
        String thisPatchLevel = this.getComponent().getPatchLevel();
        int result = thisName != null ? thisName.hashCode() : 0;
        result = 31 * result + (thisVersion != null ? thisVersion.hashCode() : 0);
        result = 31 * result + (thisPatchLevel != null ? thisPatchLevel.hashCode() : 0);
        return result;
    }
}

