/*
 * Decompiled with CFR 0.152.
 */
package oracle.glcm.opatch.common.helpers;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.glcm.opatch.common.api.BasePatchFactory;
import oracle.glcm.opatch.common.api.InvalidPatchMetadataException;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchDeployArtifact;
import oracle.glcm.opatch.common.api.PatchFactory;
import oracle.glcm.opatch.common.api.PatchMetadataLoadingException;
import oracle.glcm.opatch.common.api.PatchNotFoundException;
import oracle.glcm.opatch.common.api.PatchType;
import oracle.glcm.opatch.common.impl.Constants;
import oracle.glcm.opatch.common.impl.PatchDeployArtifactImpl;

public class PatchHelper {
    private static final Logger _logger = Logger.getLogger(PatchHelper.class.getName());
    public static final String ONEOFFS_PATH = "inventory" + Constants.PATH + "oneoffs";
    public static final String PATCH_CONFIG_INVENTORY_FILENAME = "patch_config_inventory.xml";
    public static final String DOMAIN_CONFIG_INVENTORY_DIR = "domain_config_inventory";
    private static Map<String, Patch> _patchesCache = new HashMap<String, Patch>();

    public static Patch getCachedPatch(String patchId) {
        return _patchesCache.get(patchId);
    }

    public static void cachePatch(Patch patch) {
        if (patch != null) {
            _patchesCache.putAll(PatchHelper.getAllPatches(patch));
        }
    }

    public static Map<String, Patch> getAllPatches(Patch patch) {
        return PatchHelper.getAllPatches(patch, (PatchType)null);
    }

    public static Map<String, Patch> getAllPatches(Patch patch, PatchType patchType) {
        LinkedHashMap<String, Patch> patches = new LinkedHashMap<String, Patch>();
        PatchHelper.getAllPatches(patch, patches);
        if (patchType != null && !patches.isEmpty()) {
            Iterator it = patches.entrySet().iterator();
            while (it.hasNext()) {
                if (((Patch)it.next().getValue()).getPatchType() == patchType) continue;
                it.remove();
            }
        }
        return patches;
    }

    private static void getAllPatches(Patch patch, Map<String, Patch> patches) {
        String patchId;
        if (patch != null && patches != null && !patches.containsKey(patchId = patch.getPatchId())) {
            patches.put(patchId, patch);
            List subPatches = patch.getSubPatches();
            if (subPatches != null) {
                for (Patch subPatch : subPatches) {
                    PatchHelper.getAllPatches(subPatch, patches);
                }
            }
        }
    }

    public static String getOneoffsDirectoryPath(String oracleHome) {
        return oracleHome + Constants.PATH + ONEOFFS_PATH;
    }

    public static List<Patch> getPatchesInOH(String oracleHome) throws PatchNotFoundException, InvalidPatchMetadataException, PatchMetadataLoadingException {
        return PatchHelper.getPatchesInOH(oracleHome, null);
    }

    public static List<Patch> getPatchesInOH(String oracleHome, List<String> inputPatches) throws PatchNotFoundException, InvalidPatchMetadataException, PatchMetadataLoadingException {
        ArrayList<Patch> patches = new ArrayList<Patch>();
        List<String> patchIds = PatchHelper.getPatchIDsInOH(oracleHome, inputPatches);
        if (!patchIds.isEmpty()) {
            PatchFactory patchFactory = BasePatchFactory.instance();
            for (String patchId : patchIds) {
                Patch patch = PatchHelper.getCachedPatch(patchId);
                if (patch == null) {
                    String absoluteLoc = PatchHelper.getOneoffsDirectoryPath(oracleHome) + Constants.PATH + patchId;
                    patch = patchFactory.createPatch(absoluteLoc);
                    PatchHelper.cachePatch(patch);
                }
                patches.add(patch);
            }
        }
        return patches;
    }

    public static List<String> getPatchIdsInOH(String oracleHome) throws PatchNotFoundException {
        return PatchHelper.getPatchIDsInOH(oracleHome, null);
    }

    public static List<String> getPatchIDsInOH(String oracleHome, List<String> inputPatches) throws PatchNotFoundException {
        if (oracleHome == null || oracleHome.isEmpty()) {
            throw new PatchNotFoundException("The oracle home value specified was null or empty.");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (inputPatches == null || !inputPatches.isEmpty()) {
            File oneoffsDir = new File(oracleHome, ONEOFFS_PATH);
            if (oneoffsDir.exists() && !oneoffsDir.isDirectory()) {
                throw new PatchNotFoundException("The oneoffs directory in oracle home was not a directory:" + oneoffsDir);
            }
            String[] oneoffsDirs = oneoffsDir.list();
            if (oneoffsDirs != null) {
                for (String patchId : oneoffsDirs) {
                    if (inputPatches != null && !inputPatches.contains(patchId)) continue;
                    result.add(patchId);
                }
            }
            if (inputPatches != null && result.size() != inputPatches.size()) {
                ArrayList<String> missing = new ArrayList<String>(inputPatches);
                missing.removeAll(result);
                throw new PatchNotFoundException("Patches " + missing + " do not exist in oracle home " + oracleHome);
            }
        }
        return result;
    }

    public static String getDomainConfigInventoryDirLocation(String domainDir) {
        return domainDir + File.separator + DOMAIN_CONFIG_INVENTORY_DIR;
    }

    public static String getPatchConfigInventoryFileLocation(String domainDir) {
        return PatchHelper.getDomainConfigInventoryDirLocation(domainDir) + File.separator + PATCH_CONFIG_INVENTORY_FILENAME;
    }

    public static String getPatchDeployLocation(String patchLocation) {
        return patchLocation + Constants.PATH + Constants.PATCH_DEPLOY_XML;
    }

    public static PatchDeployArtifact getPatchDeployArtifact(String patchLocation) throws PatchMetadataLoadingException {
        PatchDeployArtifactImpl pdi = null;
        String patchDeployFile = PatchHelper.getPatchDeployLocation(patchLocation);
        File pdfile = new File(patchDeployFile);
        if (pdfile.exists() && !pdfile.isDirectory()) {
            _logger.info("PatchDeployArtifactImpl is being created from " + patchDeployFile);
            pdi = new PatchDeployArtifactImpl(patchDeployFile);
            _logger.info("PatchDeployArtifactImpl has been created from " + patchDeployFile);
        } else {
            _logger.info("Patch Deploy artifact does not exist or was a directory.");
        }
        return pdi;
    }

    public static List<String> getPatchIds(List<Patch> patches) {
        ArrayList<String> patchIds = new ArrayList<String>();
        if (patches != null) {
            for (Patch patch : patches) {
                patchIds.add(patch.getPatchId());
            }
        }
        return patchIds;
    }
}

