/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xml.ws.trust.wssx;

import java.util.List;
import oracle.security.xml.Token;
import oracle.security.xml.ws.policy.bindings.AppliesTo;
import oracle.security.xml.ws.secconv.wssx.bindings.SecurityContextToken;
import oracle.security.xml.ws.secext10.bindings.SecurityTokenReference;
import oracle.security.xml.ws.trust.wssx.bindings.AllowPostdating;
import oracle.security.xml.ws.trust.wssx.bindings.BinarySecret;
import oracle.security.xml.ws.trust.wssx.bindings.BinarySecretTypeEnum;
import oracle.security.xml.ws.trust.wssx.bindings.CancelTarget;
import oracle.security.xml.ws.trust.wssx.bindings.Claims;
import oracle.security.xml.ws.trust.wssx.bindings.Entropy;
import oracle.security.xml.ws.trust.wssx.bindings.IssuedTokens;
import oracle.security.xml.ws.trust.wssx.bindings.Lifetime;
import oracle.security.xml.ws.trust.wssx.bindings.OnBehalfOf;
import oracle.security.xml.ws.trust.wssx.bindings.RenewTarget;
import oracle.security.xml.ws.trust.wssx.bindings.Renewing;
import oracle.security.xml.ws.trust.wssx.bindings.RequestSecurityToken;
import oracle.security.xml.ws.trust.wssx.bindings.RequestSecurityTokenResponse;
import oracle.security.xml.ws.trust.wssx.bindings.RequestSecurityTokenResponseCollection;
import oracle.security.xml.ws.trust.wssx.bindings.RequestTypeEnum;
import oracle.security.xml.ws.trust.wssx.bindings.RequestedAttachedReference;
import oracle.security.xml.ws.trust.wssx.bindings.RequestedProofToken;
import oracle.security.xml.ws.trust.wssx.bindings.RequestedSecurityToken;
import oracle.security.xml.ws.trust.wssx.bindings.RequestedTokenCancelled;
import oracle.security.xml.ws.trust.wssx.bindings.RequestedUnattachedReference;
import oracle.security.xml.ws.trust.wssx.bindings.SecondaryParameters;
import oracle.security.xml.ws.trust.wssx.bindings.Status;
import oracle.security.xml.ws.trust.wssx.bindings.StatusCodeEnum;
import oracle.security.xml.ws.trust.wssx.bindings.UseKey;
import oracle.security.xml.ws.trust.wssx.bindings.ValidateTarget;
import oracle.security.xml.ws.wsu10.bindings.AttributedDateTime;
import oracle.security.xml.xenc.bindings.EncryptedKey;

public class WSTrustElementFactory {
    public RequestSecurityToken createRSTForIssue(String tokenType, RequestTypeEnum requestType, String context, AppliesTo scopes, Claims claims, Entropy entropy, Lifetime lt) {
        RequestSecurityToken rst = new RequestSecurityToken();
        rst.setTokenType(tokenType);
        rst.setRequestType(requestType);
        rst.setContext(context);
        rst.setAppliesTo(scopes);
        rst.setClaims(claims);
        rst.setEntropy(entropy);
        rst.setLifetime(lt);
        return rst;
    }

    public RequestSecurityTokenResponse createRSTRForIssue(String tokenType, String context, RequestedSecurityToken token, AppliesTo scopes, RequestedAttachedReference attachedReference, RequestedUnattachedReference unattachedReference, RequestedProofToken proofToken, Entropy entropy, Lifetime lt) {
        RequestSecurityTokenResponse rstr = new RequestSecurityTokenResponse();
        rstr.setTokenType(tokenType);
        rstr.setContext(context);
        rstr.setRequestedSecurityToken(token);
        rstr.setAppliesTo(scopes);
        rstr.setRequestedAttachedReference(attachedReference);
        rstr.setRequestedUnattachedReference(unattachedReference);
        rstr.setRequestedProofToken(proofToken);
        rstr.setEntropy(entropy);
        rstr.setLifetime(lt);
        return rstr;
    }

    public RequestSecurityTokenResponseCollection createRSTRCollectionForIssue(String tokenType, String context, RequestedSecurityToken token, AppliesTo scopes, RequestedAttachedReference attached, RequestedUnattachedReference unattached, RequestedProofToken proofToken, Entropy entropy, Lifetime lt) {
        RequestSecurityTokenResponse rstr = new RequestSecurityTokenResponse();
        rstr.setTokenType(tokenType);
        rstr.setContext(context);
        rstr.setRequestedSecurityToken(token);
        rstr.setAppliesTo(scopes);
        rstr.setRequestedAttachedReference(attached);
        rstr.setRequestedUnattachedReference(unattached);
        rstr.setRequestedProofToken(proofToken);
        rstr.setEntropy(entropy);
        rstr.setLifetime(lt);
        RequestSecurityTokenResponseCollection rstrc = new RequestSecurityTokenResponseCollection();
        rstrc.getRequestSecurityTokenResponses().add(rstr);
        return rstrc;
    }

    public RequestSecurityTokenResponseCollection createRSTRCollectionForIssue(List<RequestSecurityTokenResponse> rstrs) {
        RequestSecurityTokenResponseCollection rstrc = new RequestSecurityTokenResponseCollection();
        rstrc.getRequestSecurityTokenResponses().addAll(rstrs);
        return rstrc;
    }

    public RequestSecurityTokenResponse createRSTRForRenew(String tokenType, String context, RequestedSecurityToken token, RequestedAttachedReference attachedReference, RequestedUnattachedReference unattachedReference, RequestedProofToken proofToken, Entropy entropy, Lifetime lt) {
        RequestSecurityTokenResponse rstr = new RequestSecurityTokenResponse();
        rstr.setTokenType(tokenType);
        rstr.setContext(context);
        rstr.setRequestedSecurityToken(token);
        rstr.setRequestedAttachedReference(attachedReference);
        rstr.setRequestedUnattachedReference(unattachedReference);
        rstr.setRequestedProofToken(proofToken);
        rstr.setEntropy(entropy);
        rstr.setLifetime(lt);
        return rstr;
    }

    public IssuedTokens createIssuedTokens(RequestSecurityTokenResponseCollection issuedTokens) {
        IssuedTokens issued = new IssuedTokens();
        issued.getRequestSecurityTokenResponses().addAll(issuedTokens.getRequestSecurityTokenResponses());
        return issued;
    }

    public Entropy createEntropy(BinarySecret secret) {
        Entropy ep = new Entropy();
        ep.setBinarySecret(secret);
        return ep;
    }

    public Entropy createEntropy(EncryptedKey key) {
        Entropy ep = new Entropy();
        ep.setEncryptedKey(key);
        return ep;
    }

    public BinarySecret createBinarySecret(byte[] rawValue, BinarySecretTypeEnum type) {
        BinarySecret bsecret = new BinarySecret();
        bsecret.setType(type);
        bsecret.setValue(rawValue);
        return bsecret;
    }

    public Claims createClaims(Claims claims) {
        Claims newClaims = new Claims();
        if (claims != null) {
            newClaims.setDialect(claims.getDialect());
            newClaims.getAnies().addAll(claims.getAnies());
            newClaims.getOtherAttributes().putAll(claims.getOtherAttributes());
        }
        return newClaims;
    }

    public Claims createClaims() {
        return new Claims();
    }

    public Status createStatus(StatusCodeEnum code, String reason) {
        Status st = new Status();
        st.setCode(code);
        st.setReason(reason);
        return st;
    }

    public Lifetime createLifetime(AttributedDateTime created, AttributedDateTime expires) {
        Lifetime lt = new Lifetime();
        lt.setCreated(created);
        lt.setExpires(expires);
        return lt;
    }

    public OnBehalfOf createOnBehalfOf(Token oboToken) {
        OnBehalfOf obo = new OnBehalfOf();
        obo.setToken(oboToken);
        return obo;
    }

    public RequestedSecurityToken createRequestedSecurityToken(Token token) {
        RequestedSecurityToken rt = new RequestedSecurityToken();
        rt.setToken(token);
        return rt;
    }

    public RequestedSecurityToken createRequestedSecurityToken() {
        return new RequestedSecurityToken();
    }

    public RequestedAttachedReference createRequestedAttachedReference(SecurityTokenReference str) {
        RequestedAttachedReference rar = new RequestedAttachedReference();
        rar.setToken(str);
        return rar;
    }

    public RequestedUnattachedReference createRequestedUnattachedReference(SecurityTokenReference str) {
        RequestedUnattachedReference rar = new RequestedUnattachedReference();
        rar.setToken(str);
        return rar;
    }

    public RequestedProofToken createRequestedProofToken() {
        return new RequestedProofToken();
    }

    public RequestSecurityToken createRSTForRenew(String tokenType, RequestTypeEnum requestType, String context, RenewTarget target, AllowPostdating apd, Renewing renewingInfo) {
        RequestSecurityToken rst = new RequestSecurityToken();
        rst.setTokenType(tokenType);
        rst.setRequestType(requestType);
        rst.setContext(context);
        rst.setRenewTarget(target);
        rst.setAllowPostdating(apd);
        rst.setRenewing(renewingInfo);
        return rst;
    }

    public RenewTarget createRenewTarget(SecurityTokenReference str) {
        RenewTarget rt = new RenewTarget();
        rt.setSTR(str);
        return rt;
    }

    public CancelTarget createCancelTarget(SecurityTokenReference str) {
        CancelTarget ct = new CancelTarget();
        ct.setSTR(str);
        return ct;
    }

    public ValidateTarget createValidateTarget(SecurityTokenReference str) {
        ValidateTarget vt = new ValidateTarget();
        vt.setSTR(str);
        return vt;
    }

    public UseKey createUseKey(Token token, String sig) {
        UseKey useKey = new UseKey();
        useKey.setToken(token);
        if (sig != null) {
            useKey.setSig(sig);
        }
        return useKey;
    }

    public RequestSecurityToken createRSTForCancel(RequestTypeEnum requestType, CancelTarget target) {
        RequestSecurityToken rst = new RequestSecurityToken();
        rst.setRequestType(requestType);
        rst.setCancelTarget(target);
        return rst;
    }

    public RequestSecurityTokenResponse createRSTRForCancel() {
        RequestSecurityTokenResponse rstr = new RequestSecurityTokenResponse();
        rstr.setRequestedTokenCancelled(new RequestedTokenCancelled());
        return rstr;
    }

    public RequestSecurityToken createRSTForValidate(String tokenType, RequestTypeEnum requestType) {
        RequestSecurityToken rst = new RequestSecurityToken();
        rst.setTokenType(tokenType);
        rst.setRequestType(requestType);
        return rst;
    }

    public RequestSecurityTokenResponse createRSTRForValidate(String tokenType, RequestedSecurityToken token, Status status) {
        RequestSecurityTokenResponse rstr = new RequestSecurityTokenResponse();
        rstr.setTokenType(tokenType);
        rstr.setRequestedSecurityToken(token);
        rstr.setStatus(status);
        return rstr;
    }

    public RequestSecurityToken createRST() {
        return new RequestSecurityToken();
    }

    public RequestSecurityTokenResponse createRSTR() {
        return new RequestSecurityTokenResponse();
    }

    public RequestSecurityTokenResponseCollection createRSTRC(List<RequestSecurityTokenResponse> rstrs) {
        RequestSecurityTokenResponseCollection rstrc = new RequestSecurityTokenResponseCollection();
        rstrc.getRequestSecurityTokenResponses().addAll(rstrs);
        return rstrc;
    }

    public SecurityContextToken createSecurityContextToken(String identifier, String instance, String wsuId) {
        SecurityContextToken sct = new SecurityContextToken();
        sct.setIdentifier(identifier);
        sct.setInstance(instance);
        sct.setId(wsuId);
        return sct;
    }

    public SecondaryParameters createSecondaryParameters() {
        return new SecondaryParameters();
    }
}

