/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.wrappers;

import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.InventoryFactory;
import com.oracle.cie.gdr.external.InventoryUtil;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.glcm.common.nio.FileSystemType;
import oracle.glcm.common.nio.NioService;
import oracle.glcm.common.nio.NioServiceFactory;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.PatchCheckResults;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.glcm.opatch.common.api.install.ComponentInfo;
import oracle.glcm.opatch.common.api.install.FileState;
import oracle.glcm.opatch.common.api.install.HomeOperationsFactory;
import oracle.glcm.opatch.common.api.install.InventoryComponentInfo;
import oracle.glcm.opatch.common.api.install.PatchInfo;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchObject;
import oracle.opatch.cup.CUPAdapter;
import oracle.opatch.wrappers.CommonWrapperProvider;

public class WrapperProvider1395Impl
extends CommonWrapperProvider {
    private NioService _nioService = NioServiceFactory.getNioService();

    @Override
    public boolean isRepoFileSystemSupported() {
        return true;
    }

    @Override
    public void configureRepoFileSystem() {
        this._nioService = NioServiceFactory.configureDefault((FileSystemType)FileSystemType.Cas);
    }

    @Override
    public void resetDefaultFileSystem() {
        NioServiceFactory.resetDefault();
    }

    @Override
    public void newFileSystem(Path fileSystemPath) throws IOException {
        this._nioService.newFileSystem(fileSystemPath);
    }

    @Override
    public void newFileSystem(Path fileSystemPath, Map<String, Object> env) throws IOException {
        this._nioService.newFileSystem(fileSystemPath, env);
    }

    @Override
    public URI getURI(String pathString) throws URISyntaxException {
        return this._nioService.getURI(pathString);
    }

    @Override
    public Path getPath(File file) {
        return this._nioService.getPath(file);
    }

    @Override
    public Path getPath(String first, String ... more) {
        return this._nioService.getPath(first, more);
    }

    @Override
    public Path getPath(URI uri) {
        return this._nioService.getPath(uri);
    }

    @Override
    public FileSystem getFileSystem(Path path) {
        return this._nioService.getFileSystem(path);
    }

    @Override
    public Path getInternalPath(Path path) {
        return this._nioService.getInternalPath(path);
    }

    @Override
    public URL getURL(Path path) throws MalformedURLException {
        return this._nioService.getURL(path);
    }

    @Override
    public PatchInfo getPatchInfo(PatchObject patchObject, boolean rollback, PatchCheckResults pcr, Map<FileState, List<Path>> affectedFilePaths) {
        PatchInfo patchInfoObj;
        Map mapResults1 = pcr.getComponentCheckResults();
        Map<ComponentInfo, ComponentCheckResult> mapResults = this.convertToComponentInfo(mapResults1);
        Map<String, ComponentCheckResult> tempMapResults = this.convertToInventoryComponentInfo(mapResults1);
        if (OPatchEnv.isCUP2Supported()) {
            PatchInfo.Builder builder = HomeOperationsFactory.getInstance().getPatchInfoBuilder();
            PatchInfo.Builder builder1 = builder.patchId(patchObject.getPatchID()).patchUpi(patchObject.getPatchUniqID()).patchSubType(PatchSubType.fromValue((String)patchObject.getPatchSubType())).patchComponents(mapResults).affectedPaths(affectedFilePaths).rollBack(rollback).bugList(Arrays.asList(patchObject.getBugsToFixAsString())).description(patchObject.getOneOffEntryObj().getPatchDesc()).preReqs(Arrays.asList(patchObject.getPrereqOneOffs())).languages(Arrays.asList(new Locale(patchObject.getPatchLanguage()))).supersededPatches(new ArrayList<String>(patchObject.getOneOffEntryObj().getSubsetPatchIDs()));
            CUPAdapter cupAdapter = new CUPAdapter(patchObject);
            patchInfoObj = cupAdapter.createPatchInfoObj(builder1, tempMapResults);
        } else {
            patchInfoObj = HomeOperationsFactory.getInstance().getPatchInfoWithPaths(patchObject.getPatchID(), patchObject.getPatchUniqID(), PatchSubType.fromValue((String)patchObject.getPatchSubType()), mapResults, affectedFilePaths, rollback, Arrays.asList(patchObject.getBugsToFixAsString()), patchObject.getOneOffEntryObj().getPatchDesc(), Arrays.asList(patchObject.getPrereqOneOffs()), Arrays.asList(new Locale(patchObject.getPatchLanguage())), new ArrayList<String>(patchObject.getOneOffEntryObj().getSubsetPatchIDs()));
        }
        return patchInfoObj;
    }

    @Override
    public InventoryUtil getInventoryUtil(Path homeDir) throws InventoryException {
        return InventoryFactory.getInventoryUtil((Path)homeDir);
    }

    @Override
    public InventoryUtil initInventoryUtil(Path homeDir) throws InventoryException {
        return new InventoryUtil(homeDir);
    }

    @Override
    public OracleHomeInventory getOracleHomeInventory(Path homeDir) throws InventoryException {
        return InventoryFactory.getOracleHomeInventory((Path)homeDir);
    }

    @Override
    public Map<FileState, List<Path>> getAffectedFiles(InventoryComponentInfo newInvComponentInfo) {
        return newInvComponentInfo.getAffectedFilePaths();
    }

    @Override
    public void addAffectedFile(InventoryComponentInfo inventoryComponentInfo, FileState fs, Path homeFile) {
        inventoryComponentInfo.addAffectedFile(fs, homeFile);
    }

    @Override
    public void addBackupFile(InventoryComponentInfo inventoryComponentInfo, Path homeFile, Path backupFile) {
        inventoryComponentInfo.addBackupFile(homeFile, homeFile);
    }
}

