/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.wrappers;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.glcm.opatch.common.api.ComponentCheckResult;
import oracle.glcm.opatch.common.api.PatchInventory;
import oracle.glcm.opatch.common.api.install.ComponentInfo;
import oracle.glcm.opatch.common.api.install.FileState;
import oracle.glcm.opatch.common.api.install.HomeOperationsFactory;
import oracle.opatch.wrappers.CommonApiWrapper;
import oracle.opatch.wrappers.NextGenApiWrapper;
import oracle.opatch.wrappers.NioServiceWrapper;
import oracle.opatch.wrappers.PatchComponentInfoWrapper;
import oracle.opatch.wrappers.PatchComponentInfoWrapperImpl;
import oracle.opatch.wrappers.WrapperProvider;

public abstract class CommonWrapperProvider
implements WrapperProvider,
NioServiceWrapper,
CommonApiWrapper,
NextGenApiWrapper {
    @Override
    public NioServiceWrapper getNioServiceWrapper() {
        return this;
    }

    @Override
    public CommonApiWrapper getCommonApiWrapper() {
        return this;
    }

    @Override
    public NextGenApiWrapper getNextGenApiWrapper() {
        return this;
    }

    @Override
    public PatchComponentInfoWrapper getPatchComponentInfoWrapper(ComponentInfo compInfo, Map<Path, Path> patchFiles) {
        return new PatchComponentInfoWrapperImpl(compInfo, patchFiles);
    }

    protected Map<FileState, List<File>> convertToFile(Map<FileState, List<Path>> affectedFilePaths) {
        HashMap<FileState, List<File>> converted = new HashMap<FileState, List<File>>();
        for (Map.Entry<FileState, List<Path>> entry : affectedFilePaths.entrySet()) {
            ArrayList<File> fileList = new ArrayList<File>();
            for (Path path : entry.getValue()) {
                fileList.add(path.toFile());
            }
            converted.put(entry.getKey(), fileList);
        }
        return converted;
    }

    protected Map<FileState, List<Path>> convertToPath(Map<FileState, List<File>> affectedFilePaths) {
        HashMap<FileState, List<Path>> converted = new HashMap<FileState, List<Path>>();
        for (Map.Entry<FileState, List<File>> entry : affectedFilePaths.entrySet()) {
            ArrayList<Path> fileList = new ArrayList<Path>();
            for (File path : entry.getValue()) {
                fileList.add(Paths.get(path.getAbsolutePath(), new String[0]));
            }
            converted.put(entry.getKey(), fileList);
        }
        return converted;
    }

    protected Map<ComponentInfo, ComponentCheckResult> convertToComponentInfo(Map<PatchInventory.Component, ComponentCheckResult> m1) {
        LinkedHashMap<ComponentInfo, ComponentCheckResult> result = new LinkedHashMap<ComponentInfo, ComponentCheckResult>();
        for (Map.Entry<PatchInventory.Component, ComponentCheckResult> e1 : m1.entrySet()) {
            ComponentInfo compInfo = HomeOperationsFactory.getInstance().getComponentInfo(e1.getKey().getName(), e1.getKey().getVersion(), e1.getKey().getPatchLevel());
            result.put(compInfo, e1.getValue());
        }
        return result;
    }

    protected Map<String, ComponentCheckResult> convertToInventoryComponentInfo(Map<PatchInventory.Component, ComponentCheckResult> m1) {
        HashMap<String, ComponentCheckResult> result = new HashMap<String, ComponentCheckResult>();
        for (Map.Entry<PatchInventory.Component, ComponentCheckResult> e1 : m1.entrySet()) {
            PatchInventory.Component comp = e1.getKey();
            result.put(comp.getName() + comp.getVersion(), e1.getValue());
        }
        return result;
    }
}

