/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.util.perfmonitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.opatch.util.perfmonitor.MethodTrackerObj;

public class MethodTracker {
    private static Logger logger = Logger.getLogger(MethodTracker.class.getName());
    private static List<MethodTrackerObj> trackerList = new ArrayList<MethodTrackerObj>();
    private static boolean isMethodTrackingDisabled = false;
    private static int mb = 0x100000;
    private static int highCount = 1000;
    private static long highTime = 60000L;

    public static boolean isMethodTrackingDisabled() {
        return isMethodTrackingDisabled;
    }

    public static void setMethodTrackingDisabled(boolean isMethodTrackingDisabled) {
        MethodTracker.isMethodTrackingDisabled = isMethodTrackingDisabled;
    }

    public static MethodTrackerObj getTracker(String tag) {
        return MethodTracker.initializeTracker(tag);
    }

    public static MethodTrackerObj initializeTracker(String tag) {
        try {
            MethodTrackerObj parentObj;
            MethodTrackerObj obj = new MethodTrackerObj(isMethodTrackingDisabled);
            if (isMethodTrackingDisabled) {
                return obj;
            }
            StackTraceElement[] stes = Thread.currentThread().getStackTrace();
            String methodName = stes[3].getMethodName();
            String className = stes[3].getClassName();
            int lineNum = stes[3].getLineNumber();
            obj.setClassName(className);
            obj.setMethodName(methodName);
            obj.setLineNum(lineNum);
            obj.setStackTrace(stes);
            if (tag != null && tag.length() > 0) {
                obj.setTag(tag);
            }
            if ((parentObj = MethodTracker.findParentObj(4, stes)) != null) {
                obj.setPrintTabSpace(parentObj.getPrintTabSpace() + 2);
                obj.setParent(parentObj);
            }
            for (MethodTrackerObj existingObj : trackerList) {
                if (!existingObj.equals(obj)) continue;
                return existingObj;
            }
            if (parentObj != null) {
                parentObj.addChild(obj);
            }
            obj.setInitComplete(true);
            trackerList.add(obj);
            return obj;
        }
        catch (Exception ex) {
            logger.fine("Error while Initializing a Method Tracker Object for Tag - " + tag + ". Message: " + ex.getMessage());
            return new MethodTrackerObj();
        }
    }

    private static MethodTrackerObj findParentObj(int startIndex, StackTraceElement[] stes) {
        for (int i2 = startIndex; i2 < stes.length; ++i2) {
            StackTraceElement ste = stes[i2];
            for (MethodTrackerObj mtObj : trackerList) {
                if (!mtObj.isInprogress() || !ste.getClassName().equalsIgnoreCase(mtObj.getClassName()) || !ste.getMethodName().equalsIgnoreCase(mtObj.getMethodName()) || !MethodTracker.compareStackTrace(stes, mtObj.getStackTrace(), i2)) continue;
                return mtObj;
            }
        }
        return null;
    }

    private static boolean compareStackTrace(StackTraceElement[] src, StackTraceElement[] tar, int srcStartIndex) {
        int i2;
        StringBuffer srcStack = new StringBuffer();
        StringBuffer tarStack = new StringBuffer();
        for (i2 = 3; i2 < tar.length; ++i2) {
            tarStack.append(tar[i2].getClassName() + tar[i2].getMethodName());
        }
        for (i2 = srcStartIndex; i2 < src.length; ++i2) {
            srcStack.append(src[i2].getClassName() + src[i2].getMethodName());
        }
        return srcStack.toString().hashCode() == tarStack.toString().hashCode();
    }

    public static void printStatistics(boolean printFineStatistcis) {
        String str = MethodTracker.getStatistics(printFineStatistcis);
        System.out.println(str);
    }

    public static String getStatistics(boolean printFineStatistcis) {
        if (isMethodTrackingDisabled) {
            return "";
        }
        try {
            StringBuffer sbf = new StringBuffer("\n");
            sbf.append("____________________________________________Method Tracker_________________________________________________________________________________");
            sbf.append("\n");
            HashMap<String, MethodTrackerObj> consolidatedParents = new HashMap<String, MethodTrackerObj>();
            HashMap<String, Long> consolidatedTagTimes = new HashMap<String, Long>();
            MethodTracker.deductChildrenTime(trackerList);
            for (MethodTrackerObj trackerObj : trackerList) {
                if (trackerObj.getParent() == null) {
                    String key = trackerObj.getClassName() + "." + trackerObj.getMethodName() + "." + trackerObj.getTag();
                    MethodTrackerObj consParent = MethodTracker.mapToConsolidatedObj(consolidatedParents, trackerObj);
                    Map<String, MethodTrackerObj> consChildren = MethodTracker.consolidateChildren(trackerObj);
                    if (consChildren != null) {
                        consParent.setChildren(new ArrayList<MethodTrackerObj>(consChildren.values()));
                    }
                    consolidatedParents.put(key, consParent);
                }
                if (consolidatedTagTimes.containsKey(trackerObj.getTag())) {
                    long cumilativeTime = (Long)consolidatedTagTimes.get(trackerObj.getTag());
                    consolidatedTagTimes.put(trackerObj.getTag(), cumilativeTime += trackerObj.getTimeSpent());
                    continue;
                }
                consolidatedTagTimes.put(trackerObj.getTag(), trackerObj.getTimeSpent());
            }
            sbf.append("                        **** Method Statistics ****");
            sbf.append("\n");
            for (String key : consolidatedParents.keySet()) {
                MethodTrackerObj parent = (MethodTrackerObj)consolidatedParents.get(key);
                sbf.append(MethodTracker.getPrintableString(parent));
            }
            sbf.append("\n                        **** Phase Statistics ****");
            sbf.append("\n");
            long totalTagTime = 0L;
            for (String key : consolidatedTagTimes.keySet()) {
                totalTagTime += ((Long)consolidatedTagTimes.get(key)).longValue();
                sbf.append(key + " = " + MethodTracker.convertTime((Long)consolidatedTagTimes.get(key)));
                sbf.append("\n");
            }
            if (totalTagTime > 0L) {
                sbf.append("\nTotal Time in all Phases =  " + MethodTracker.convertTime(totalTagTime));
                sbf.append("\n");
            }
            sbf.append("\n");
            if (printFineStatistcis) {
                sbf.append("\n\n                        **** Tracker Utility Statistics ****");
                sbf.append("\n");
                sbf.append("Number of Tracker Objects Created  --> " + trackerList.size());
                sbf.append("\n");
                sbf.append("Number of times trackers used      --> " + MethodTrackerObj.trackerUseCount);
                sbf.append("\n");
                sbf.append("Overhead time spent in tracker tool --> " + MethodTracker.convertTime(MethodTrackerObj.trackerTimeSpent));
                sbf.append("\n");
            }
            sbf.append("___________________________________________________________________________________________________________________________________________");
            sbf.append("\n");
            return sbf.toString();
        }
        catch (Exception ex) {
            String errorMsg = "An error occured while generating Method Tracker Statistics. Message - " + ex.getMessage();
            return errorMsg;
        }
    }

    private static void deductChildrenTime(List<MethodTrackerObj> trackerObjs) {
        for (MethodTrackerObj obj : trackerObjs) {
            obj.setTimeSpent(obj.getTimeSpent() - obj.getChildrenTimeSpent());
        }
    }

    private static Map<String, MethodTrackerObj> consolidateChildren(MethodTrackerObj parent) {
        if (parent.hasChildren()) {
            HashMap<String, MethodTrackerObj> consolidatedChildren = new HashMap<String, MethodTrackerObj>();
            for (MethodTrackerObj child : parent.getChildren()) {
                String key = child.getClassName() + "." + child.getMethodName() + "." + child.getTag();
                MethodTrackerObj consChild = MethodTracker.mapToConsolidatedObj(consolidatedChildren, child);
                consChild.setPrintTabSpace(parent.getPrintTabSpace() + 2);
                Map<String, MethodTrackerObj> consChildren2 = MethodTracker.consolidateChildren(child);
                if (consChildren2 != null) {
                    consChild.setChildren(new ArrayList<MethodTrackerObj>(consChildren2.values()));
                }
                consolidatedChildren.put(key, consChild);
            }
            return consolidatedChildren;
        }
        return null;
    }

    private static MethodTrackerObj mapToConsolidatedObj(Map<String, MethodTrackerObj> list, MethodTrackerObj obj) {
        String key = obj.getClassName() + "." + obj.getMethodName() + "." + obj.getTag();
        if (list.containsKey(key)) {
            MethodTrackerObj consChildObj = list.get(key);
            long cumulativeTime = consChildObj.getTimeSpent();
            consChildObj.setTimeSpent(cumulativeTime += obj.getTimeSpent());
            consChildObj.setCumulativeCount(obj.getCumulativeCount());
            if (consChildObj.getMaxHeapSize() < obj.getMaxHeapSize()) {
                consChildObj.setMaxHeapSize(obj.getMaxHeapSize());
            }
            return consChildObj;
        }
        MethodTrackerObj consChildObj = new MethodTrackerObj();
        consChildObj.setClassName(obj.getClassName());
        consChildObj.setMethodName(obj.getMethodName());
        consChildObj.setMaxHeapSize(obj.getMaxHeapSize());
        consChildObj.setTimeSpent(obj.getTimeSpent());
        consChildObj.setCumulativeCount(obj.getCumulativeCount());
        consChildObj.setTag(obj.getTag());
        return consChildObj;
    }

    private static String getPrintableString(MethodTrackerObj parent) {
        StringBuffer sbf = new StringBuffer();
        String methodName = parent.getClassName() + "." + parent.getMethodName();
        String prefix = "";
        if (parent.getPrintTabSpace() > 0) {
            for (int i2 = 0; i2 < parent.getPrintTabSpace(); ++i2) {
                prefix = prefix + " ";
            }
            prefix = prefix + "|__";
        } else {
            sbf.append("\n");
        }
        if (parent.getCumulativeCount() > (long)highCount || parent.getTimeSpent() > highTime) {
            prefix = prefix + "**";
        }
        sbf.append(prefix + " " + methodName + "--> Tag=" + parent.getTag() + ", Count=" + parent.getCumulativeCount() + ", Time=" + MethodTracker.convertTime(parent.getTimeSpent()) + ", Max Heap Size(MB)=" + parent.getMaxHeapSize() / (long)mb);
        sbf.append("\n");
        if (parent.hasChildren()) {
            for (MethodTrackerObj child : parent.getChildren()) {
                sbf.append(MethodTracker.getPrintableString(child));
                sbf.append("\n");
            }
        }
        return sbf.toString();
    }

    private static String convertTime(long millis) {
        if (millis < 0L) {
            millis = 0L;
        }
        long second = millis / 1000L % 60L;
        long minute = millis / 60000L % 60L;
        long hour = millis / 3600000L % 24L;
        String time = String.format("%02d:%02d:%02d", hour, minute, second);
        return time;
    }

    static {
        String isMethodTrackDisabledStr = System.getenv("ORACLE_GLCM_METHOD_TRACKER_DISABLE");
        if (isMethodTrackDisabledStr != null && isMethodTrackDisabledStr.equalsIgnoreCase("true")) {
            isMethodTrackingDisabled = true;
        }
        String highCountEnvVar = System.getenv("ORACLE_GLCM_METHOD_TRACKER_HIGH_COUNT");
        String highTimeEnvVar = System.getenv("ORACLE_GLCM_METHOD_TRACKER_HIGH_TIME");
        try {
            if (highCountEnvVar != null && highCountEnvVar.length() > 0) {
                highCount = Integer.parseInt(highCountEnvVar);
            }
            if (highTimeEnvVar != null && highTimeEnvVar.length() > 0) {
                highTime = Integer.parseInt(highTimeEnvVar);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

