/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.PostScriptAction;
import oracle.opatch.Rules;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.twophase.INonBinaryPatchAction;

public class PhaseTwoPostScriptAction
implements INonBinaryPatchAction {
    private PostScriptAction post;
    private static final long serialVersionUID = 1L;

    public PhaseTwoPostScriptAction(PostScriptAction act) {
        this.post = act;
    }

    @Override
    public void run() {
        OLogger.printlnOnLog("Invoking post scripts..");
        int postReturnVal = this.post.process();
        if (postReturnVal != 0) {
            String postMsg = OLogger.getString("OUI-67133", new Object[]{"POST", Integer.toString(postReturnVal)});
            OLogger.warn("OUI-67133", new Object[]{"POST", Integer.toString(postReturnVal)});
            if (!Rules.shouldContinueInCaseOfPrePostError("")) {
                OPatchStateManagerFactory.getInstance().setErrorCode(201);
                RuntimeException postRe = new RuntimeException(postMsg);
                throw postRe;
            }
        }
        OLogger.printlnOnLog("Finished invoking post scripts.");
    }

    @Override
    public boolean isRealEmpty() {
        return this.post.isRealEmpty();
    }
}

