/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.twophase;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.PatchObject;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.twophase.NApplyOperator;
import oracle.opatch.twophase.NRollbackOperator;
import oracle.opatch.wrappers.WrapperFactory;

public class PhaseOneExecutor {
    public void execute(String soh, PatchObject[] nApplyPatch, PatchObject[] nRollbackPatch) {
        OLogger.justlog(OLogger.INFO, "ENTERING METHOD: PhaseOneExecutor::execute(String soh, PatchObject[] nApplyPatch, PatchObject[] nRollbackPatch)");
        NRollbackOperator nRollback = new NRollbackOperator();
        OLogger.justlog(OLogger.INFO, "Start to run phase one for rollback patches.");
        nRollback.run(soh, nRollbackPatch);
        ArrayList<Path> files = new ArrayList<Path>();
        String comps = soh + File.separator + "inventory" + File.separator + "ContentsXML" + File.separator + "comps.xml";
        files.add(WrapperFactory.getNioServiceWrapper().getPath(comps, new String[0]));
        String ouiPatch = soh + File.separator + "inventory" + File.separator + "ContentsXML" + File.separator + "oui-patch.xml";
        if (new File(ouiPatch).exists()) {
            files.add(WrapperFactory.getNioServiceWrapper().getPath(ouiPatch, new String[0]));
        }
        this.breakHardLink(files);
        OLogger.justlog(OLogger.INFO, "Start to run phase one for apply patches.");
        NApplyOperator nApply = new NApplyOperator();
        nApply.run(soh, nApplyPatch);
        OLogger.justlog(OLogger.INFO, "EXITING METHOD: PhaseOneExecutor::execute(String soh, PatchObject[] nApplyPatch, PatchObject[] nRollbackPatch)");
    }

    private void breakHardLink(List<Path> files) {
        for (Path f2 : files) {
            OLogger.justlog(OLogger.INFO, "Start to break hardlink for file \" {0} \"" + f2.toAbsolutePath().toString());
            SystemCall.breakHardLink(f2);
            OLogger.justlog(OLogger.INFO, "Complete breaking hardlink for file \" {0} \"" + f2.toAbsolutePath().toString());
        }
    }
}

