/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk.engineeredsystem;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.patchsdk.bundle_xml.Subpatch;
import oracle.opatch.patchsdk.bundle_xml.SystemPatchBundleXML;
import oracle.opatch.patchsdk.engineeredsystem.EngineeredSystemPatchValidatorAndGenerator;
import oracle.opatch.patchsdk.engineeredsystem.HashComputeFunction;
import oracle.opatch.patchsdk.patchmodel.PatchingTool;
import oracle.opatch.wrappers.WrapperFactory;

public class InventoryAndActionOnlyV2
extends HashComputeFunction {
    private static String fileSeparator = File.separator;

    @Override
    protected List<String> fileList(String patchLocation, SystemPatchBundleXML bundleXml) {
        ArrayList<String> metaList = new ArrayList<String>();
        for (Subpatch subPatch : bundleXml.getSubpatches()) {
            if (subPatch.getPatchingTool() != PatchingTool.OPATCH) continue;
            String subPatchLoc = subPatch.getLocation();
            String subPatchAbsLoc = patchLocation + fileSeparator + subPatchLoc;
            if (EngineeredSystemPatchValidatorAndGenerator.IsSubPatchCompositePatch(subPatchAbsLoc)) {
                Path compositePatchDir = WrapperFactory.getNioServiceWrapper().getPath(subPatchAbsLoc, new String[0]);
                if (!Files.exists(compositePatchDir, new LinkOption[0])) continue;
                try {
                    for (Path sp : Files.newDirectoryStream(compositePatchDir)) {
                        if (!Files.isDirectory(sp, new LinkOption[0])) continue;
                        metaList.add(WrapperFactory.getNioServiceWrapper().getPath(sp.toAbsolutePath().toString() + fileSeparator + EngineeredSystemPatchValidatorAndGenerator.ACTIONS_XML, new String[0]).toAbsolutePath().toString());
                        metaList.add(WrapperFactory.getNioServiceWrapper().getPath(sp.toAbsolutePath().toString() + fileSeparator + EngineeredSystemPatchValidatorAndGenerator.INVENTORY_XML, new String[0]).toAbsolutePath().toString());
                    }
                    continue;
                }
                catch (IOException e2) {
                    OLogger.debug(e2.getMessage());
                    continue;
                }
            }
            metaList.add(WrapperFactory.getNioServiceWrapper().getPath(patchLocation, subPatchLoc + fileSeparator + EngineeredSystemPatchValidatorAndGenerator.ACTIONS_XML).toAbsolutePath().toString());
            metaList.add(WrapperFactory.getNioServiceWrapper().getPath(patchLocation, subPatchLoc + fileSeparator + EngineeredSystemPatchValidatorAndGenerator.INVENTORY_XML).toAbsolutePath().toString());
        }
        return metaList;
    }

    @Override
    protected String getHashFunction() {
        return "sha1";
    }
}

