/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchsdk;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.opatch.patchsdk.patchmodel.EngineeredSystemPatch;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchEngineeredSystemPatch
extends EngineeredSystemPatch {
    private boolean isAuto = false;
    private String applyAutomationXMLLocation;
    private String rollbackAutomationXMLLocation;

    protected OPatchEngineeredSystemPatch() {
        this.setPatchTool("opatch");
    }

    protected OPatchEngineeredSystemPatch(String patchLocation) {
        this.setPatchLocation(patchLocation);
        this.setPatchTool("opatch");
        StringBuffer bundleXmlLocBuff = new StringBuffer(patchLocation);
        bundleXmlLocBuff.append(File.separator);
        bundleXmlLocBuff.append("bundle.xml");
        Path bundleXml = WrapperFactory.getNioServiceWrapper().getPath(bundleXmlLocBuff.toString(), new String[0]);
        assert (Files.exists(bundleXml, new LinkOption[0]));
        this.setBundleXmlLoc(bundleXmlLocBuff.toString());
    }

    public String getRollbackAutomationXMLLoc() {
        return this.rollbackAutomationXMLLocation;
    }

    public String getApplyAutomationXMLLoc() {
        return this.applyAutomationXMLLocation;
    }

    protected void setApplyAutomationXMLLoc(String applyAutomationXMLLoc) {
        this.applyAutomationXMLLocation = applyAutomationXMLLoc;
    }

    protected void setRollbackAutomationXMLLoc(String rollbackAutomationXMLLoc) {
        this.rollbackAutomationXMLLocation = rollbackAutomationXMLLoc;
    }

    protected void setIsAuto(boolean isAuto) {
        this.isAuto = isAuto;
    }

    public boolean isAutoPatch() {
        return this.isAuto;
    }
}

