/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchlevel;

import oracle.opatch.patchlevel.AbstractPatchLevel;
import oracle.opatch.patchlevel.PatchLevel;
import oracle.opatch.patchlevel.PatchLevelRelation;

public class ThreeDigitPatchLevel
extends AbstractPatchLevel {
    public ThreeDigitPatchLevel(int[] digits) {
        this.digits = digits;
    }

    @Override
    public PatchLevelRelation compare(PatchLevel other) {
        if (other == null) {
            return PatchLevelRelation.HIGHER;
        }
        if (other.getType() == 2) {
            return this.compareAgainst2(other);
        }
        if (other.getType() == 3) {
            return this.compareAgainst3(other);
        }
        if (other.getType() == 4) {
            return this.compareAgainst4(other);
        }
        return PatchLevelRelation.INVALID;
    }

    protected PatchLevelRelation compareAgainst4(PatchLevel other) {
        int[] digits4 = other.getValues();
        int[] digits3 = this.digits;
        if (digits3[2] != 0) {
            return PatchLevelRelation.DIFFERENT_BRANCH;
        }
        if (digits3[0] != digits4[0]) {
            return PatchLevelRelation.DIFFERENT_BRANCH;
        }
        if (digits3[1] > digits4[1]) {
            return PatchLevelRelation.DIFFERENT_BRANCH;
        }
        return PatchLevelRelation.LOWER;
    }

    protected PatchLevelRelation compareAgainst3(PatchLevel other) {
        int[] otherDigits3 = other.getValues();
        int[] digits3 = this.digits;
        if (otherDigits3[2] == 0 && digits3[2] == 0) {
            if (digits3[0] != otherDigits3[0]) {
                return PatchLevelRelation.DIFFERENT_BRANCH;
            }
            if (digits3[1] > otherDigits3[1]) {
                return PatchLevelRelation.HIGHER;
            }
            if (digits3[1] < otherDigits3[1]) {
                return PatchLevelRelation.LOWER;
            }
            return PatchLevelRelation.SAME;
        }
        if (otherDigits3[2] != 0 && digits3[2] != 0) {
            if (digits3[0] == otherDigits3[0] && digits3[1] == otherDigits3[1]) {
                if (digits3[2] > otherDigits3[2]) {
                    return PatchLevelRelation.HIGHER;
                }
                if (digits3[2] < otherDigits3[2]) {
                    return PatchLevelRelation.LOWER;
                }
                return PatchLevelRelation.SAME;
            }
            return PatchLevelRelation.DIFFERENT_BRANCH;
        }
        return PatchLevelRelation.DIFFERENT_BRANCH;
    }

    protected PatchLevelRelation compareAgainst2(PatchLevel other) {
        int[] digits3;
        int[] digits2 = other.getValues();
        if (digits2[0] > (digits3 = this.digits)[0]) {
            return PatchLevelRelation.DIFFERENT_BRANCH;
        }
        if (digits2[0] < digits3[0]) {
            return PatchLevelRelation.HIGHER;
        }
        if (digits3[2] == 0) {
            if (digits2[1] == 0) {
                return PatchLevelRelation.HIGHER;
            }
            return PatchLevelRelation.DIFFERENT_BRANCH;
        }
        if (digits2[1] <= digits3[1]) {
            return PatchLevelRelation.HIGHER;
        }
        return PatchLevelRelation.DIFFERENT_BRANCH;
    }

    @Override
    public String getReleaseType() {
        if (this.digits[2] == 0) {
            return "RUR";
        }
        return "CEU_for_RUorRUI";
    }
}

