/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchlevel;

import java.util.StringTokenizer;
import oracle.opatch.patchlevel.FourDigitPatchLevel;
import oracle.opatch.patchlevel.InvalidPatchLevelFormatException;
import oracle.opatch.patchlevel.OneDigitPatchLevel;
import oracle.opatch.patchlevel.PatchLevel;
import oracle.opatch.patchlevel.ThreeDigitPatchLevel;
import oracle.opatch.patchlevel.TwoDigitPatchLevel;

public class PatchLevelFactory {
    public static PatchLevel createPatchLevelInstance(String strPL) {
        if (strPL == null || strPL.equalsIgnoreCase("")) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(strPL, ".");
        int tokenCount = st.countTokens();
        int[] digits = new int[tokenCount];
        if (tokenCount >= 0 && tokenCount < 5) {
            for (int i2 = 0; i2 < tokenCount; ++i2) {
                try {
                    digits[i2] = Integer.parseInt(st.nextToken());
                    continue;
                }
                catch (NumberFormatException e2) {
                    throw new InvalidPatchLevelFormatException("Invalid patch level format (patch level must be integer, seperated by dot .)" + e2.getMessage());
                }
            }
        } else {
            throw new InvalidPatchLevelFormatException("Invalid patch level format: must be from 0 to 4 number");
        }
        if (tokenCount == 1) {
            return new OneDigitPatchLevel(digits);
        }
        if (tokenCount == 2) {
            return new TwoDigitPatchLevel(digits);
        }
        if (tokenCount == 3) {
            return new ThreeDigitPatchLevel(digits);
        }
        if (tokenCount == 4) {
            return new FourDigitPatchLevel(digits);
        }
        return null;
    }
}

