/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.patchlevel;

import oracle.opatch.patchlevel.AbstractPatchLevel;
import oracle.opatch.patchlevel.PatchLevel;
import oracle.opatch.patchlevel.PatchLevelRelation;

public class OneDigitPatchLevel
extends AbstractPatchLevel {
    public OneDigitPatchLevel(int[] digits) {
        this.digits = digits;
    }

    @Override
    public PatchLevelRelation compare(PatchLevel other) {
        if (other == null) {
            return PatchLevelRelation.HIGHER;
        }
        if (other.getType() == 1) {
            return this.compareAgainst1(other);
        }
        return PatchLevelRelation.INVALID;
    }

    protected PatchLevelRelation compareAgainst1(PatchLevel other) {
        int[] digits1 = this.digits;
        int[] otherDigits1 = other.getValues();
        if (digits1[0] > otherDigits1[0]) {
            return PatchLevelRelation.HIGHER;
        }
        if (digits1[0] < otherDigits1[0]) {
            return PatchLevelRelation.LOWER;
        }
        return PatchLevelRelation.SAME;
    }

    @Override
    public String getReleaseType() {
        return "FMW_PL";
    }
}

